/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;

public class EMSA_PSS
implements Cloneable {
    private static final Logger log = null;
    private IMessageDigest hash;
    private int hLen;

    private EMSA_PSS(IMessageDigest iMessageDigest) {
        this.hash = iMessageDigest;
        this.hLen = iMessageDigest.hashSize();
    }

    public static EMSA_PSS getInstance(String string) {
        IMessageDigest iMessageDigest = HashFactory.getInstance(string);
        return new EMSA_PSS(iMessageDigest);
    }

    public Object clone() {
        return EMSA_PSS.getInstance(this.hash.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encode(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3;
        int n2;
        int n3 = byArray2.length;
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n3 + 9) {
            throw new IllegalArgumentException("encoding error");
        }
        int n4 = (n + 7) / 8;
        Object object = this.hash;
        synchronized (object) {
            for (n2 = 0; n2 < 8; ++n2) {
                this.hash.update((byte)0);
            }
            this.hash.update(byArray, 0, this.hLen);
            this.hash.update(byArray2, 0, n3);
            byArray3 = this.hash.digest();
        }
        object = new byte[n4 - n3 - this.hLen - 2 + 1 + n3];
        object[n4 - n3 - this.hLen - 2] = true;
        System.arraycopy(byArray2, 0, object, n4 - n3 - this.hLen - 1, n3);
        byte[] byArray4 = this.MGF(byArray3, n4 - this.hLen - 1);
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            object[n2] = (byte)(object[n2] ^ byArray4[n2]);
        }
        Object object2 = object;
        object2[0] = (byte)(object2[0] & 255 >>> 8 * n4 - n);
        byte[] byArray5 = new byte[n4];
        System.arraycopy(object, 0, byArray5, 0, n4 - this.hLen - 1);
        System.arraycopy(byArray3, 0, byArray5, n4 - this.hLen - 1, this.hLen);
        byArray5[n4 - 1] = -68;
        return byArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decode(byte[] byArray, byte[] byArray2, int n, int n2) {
        byte[] byArray3;
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("sLen");
        }
        if (this.hLen != byArray.length) {
            throw new IllegalArgumentException("wrong hash");
        }
        if (n < 8 * this.hLen + 8 * n2 + 9) {
            throw new IllegalArgumentException("decoding error");
        }
        int n4 = (n + 7) / 8;
        if ((byArray2[byArray2.length - 1] & 0xFF) != 188) {
            return false;
        }
        if ((byArray2[0] & 255 << 8 - (8 * n4 - n)) != 0) {
            return false;
        }
        byte[] byArray4 = new byte[n4 - this.hLen - 1];
        byte[] byArray5 = new byte[this.hLen];
        System.arraycopy(byArray2, 0, byArray4, 0, n4 - this.hLen - 1);
        System.arraycopy(byArray2, n4 - this.hLen - 1, byArray5, 0, this.hLen);
        byte[] byArray6 = this.MGF(byArray5, n4 - this.hLen - 1);
        for (n3 = 0; n3 < byArray4.length; ++n3) {
            byArray4[n3] = (byte)(byArray4[n3] ^ byArray6[n3]);
        }
        byArray4[0] = (byte)(byArray4[0] & 255 >>> 8 * n4 - n);
        for (n3 = 0; n3 < n4 - this.hLen - n2 - 2; ++n3) {
            if (byArray4[n3] == 0) continue;
            return false;
        }
        if (byArray4[n3] != 1) {
            return false;
        }
        byte[] byArray7 = new byte[n2];
        System.arraycopy(byArray4, byArray4.length - n2, byArray7, 0, n2);
        IMessageDigest iMessageDigest = this.hash;
        synchronized (iMessageDigest) {
            for (n3 = 0; n3 < 8; ++n3) {
                this.hash.update((byte)0);
            }
            this.hash.update(byArray, 0, this.hLen);
            this.hash.update(byArray7, 0, n2);
            byArray3 = this.hash.digest();
        }
        return Arrays.equals(byArray5, byArray3);
    }

    private byte[] MGF(byte[] byArray, int n) {
        if (n < 1 || ((long)n & 0xFFFFFFFFL) > ((long)this.hLen & 0xFFFFFFFFL) << 32) {
            throw new IllegalArgumentException("mask too long");
        }
        byte[] byArray2 = new byte[n];
        int n2 = (n + this.hLen - 1) / this.hLen - 1;
        IMessageDigest iMessageDigest = null;
        iMessageDigest = (IMessageDigest)this.hash.clone();
        iMessageDigest.digest();
        iMessageDigest.update(byArray, 0, byArray.length);
        IMessageDigest iMessageDigest2 = null;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            iMessageDigest2 = (IMessageDigest)iMessageDigest.clone();
            iMessageDigest2.update((byte)(i >>> 24));
            iMessageDigest2.update((byte)(i >>> 16));
            iMessageDigest2.update((byte)(i >>> 8));
            iMessageDigest2.update((byte)i);
            byte[] byArray3 = iMessageDigest2.digest();
            int n4 = n - n3;
            n4 = n4 > this.hLen ? this.hLen : n4;
            System.arraycopy(byArray3, 0, byArray2, n3, n4);
            n3 += n4;
        }
        return byArray2;
    }
}

