/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.dss;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.hash.Sha160;
import gnu.java.security.prng.IRandom;
import gnu.java.security.sig.BaseSignature;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;
import java.util.Random;

public class DSSSignature
extends BaseSignature {
    public DSSSignature() {
        super("dss", new Sha160());
    }

    private DSSSignature(DSSSignature dSSSignature) {
        this();
        this.publicKey = dSSSignature.publicKey;
        this.privateKey = dSSSignature.privateKey;
        this.md = (IMessageDigest)dSSSignature.md.clone();
    }

    public static final BigInteger[] sign(DSAPrivateKey dSAPrivateKey, byte[] byArray) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, DSAPrivateKey> hashMap = new HashMap<String, DSAPrivateKey>();
        hashMap.put("gnu.crypto.sig.private.key", dSAPrivateKey);
        dSSSignature.setupSign(hashMap);
        return dSSSignature.computeRS(byArray);
    }

    public static final BigInteger[] sign(DSAPrivateKey dSAPrivateKey, byte[] byArray, Random random) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("gnu.crypto.sig.private.key", dSAPrivateKey);
        if (random != null) {
            hashMap.put("gnu.crypto.sig.prng", random);
        }
        dSSSignature.setupSign(hashMap);
        return dSSSignature.computeRS(byArray);
    }

    public static final BigInteger[] sign(DSAPrivateKey dSAPrivateKey, byte[] byArray, IRandom iRandom) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("gnu.crypto.sig.private.key", dSAPrivateKey);
        if (iRandom != null) {
            hashMap.put("gnu.crypto.sig.prng", iRandom);
        }
        dSSSignature.setupSign(hashMap);
        return dSSSignature.computeRS(byArray);
    }

    public static final boolean verify(DSAPublicKey dSAPublicKey, byte[] byArray, BigInteger[] bigIntegerArray) {
        DSSSignature dSSSignature = new DSSSignature();
        HashMap<String, DSAPublicKey> hashMap = new HashMap<String, DSAPublicKey>();
        hashMap.put("gnu.crypto.sig.public.key", dSAPublicKey);
        dSSSignature.setupVerify(hashMap);
        return dSSSignature.checkRS(bigIntegerArray, byArray);
    }

    public Object clone() {
        return new DSSSignature(this);
    }

    protected void setupForVerification(PublicKey publicKey) throws IllegalArgumentException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = publicKey;
    }

    protected void setupForSigning(PrivateKey privateKey) throws IllegalArgumentException {
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = privateKey;
    }

    protected Object generateSignature() throws IllegalStateException {
        BigInteger[] bigIntegerArray = this.computeRS(this.md.digest());
        return this.encodeSignature(bigIntegerArray[0], bigIntegerArray[1]);
    }

    protected boolean verifySignature(Object object) throws IllegalStateException {
        BigInteger[] bigIntegerArray = this.decodeSignature(object);
        return this.checkRS(bigIntegerArray, this.md.digest());
    }

    private Object encodeSignature(BigInteger bigInteger, BigInteger bigInteger2) {
        return new BigInteger[]{bigInteger, bigInteger2};
    }

    private BigInteger[] decodeSignature(Object object) {
        return (BigInteger[])object;
    }

    private BigInteger[] computeRS(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = ((DSAPrivateKey)this.privateKey).getParams().getP();
        BigInteger bigInteger5 = ((DSAPrivateKey)this.privateKey).getParams().getQ();
        BigInteger bigInteger6 = ((DSAPrivateKey)this.privateKey).getParams().getG();
        BigInteger bigInteger7 = ((DSAPrivateKey)this.privateKey).getX();
        BigInteger bigInteger8 = new BigInteger(1, byArray);
        byte[] byArray2 = new byte[20];
        do {
            this.nextRandomBytes(byArray2);
            bigInteger2 = new BigInteger(1, byArray2);
            bigInteger2.clearBit(159);
        } while ((bigInteger3 = bigInteger6.modPow(bigInteger2, bigInteger4).mod(bigInteger5)).equals(BigInteger.ZERO) || (bigInteger = bigInteger8.add(bigInteger7.multiply(bigInteger3)).multiply(bigInteger2.modInverse(bigInteger5)).mod(bigInteger5)).equals(BigInteger.ZERO));
        return new BigInteger[]{bigInteger3, bigInteger};
    }

    private boolean checkRS(BigInteger[] bigIntegerArray, byte[] byArray) {
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        BigInteger bigInteger3 = ((DSAPublicKey)this.publicKey).getParams().getG();
        BigInteger bigInteger4 = ((DSAPublicKey)this.publicKey).getParams().getP();
        BigInteger bigInteger5 = ((DSAPublicKey)this.publicKey).getParams().getQ();
        BigInteger bigInteger6 = ((DSAPublicKey)this.publicKey).getY();
        BigInteger bigInteger7 = bigInteger2.modInverse(bigInteger5);
        BigInteger bigInteger8 = bigInteger7.multiply(new BigInteger(1, byArray)).mod(bigInteger5);
        BigInteger bigInteger9 = bigInteger.multiply(bigInteger7).mod(bigInteger5);
        BigInteger bigInteger10 = bigInteger3.modPow(bigInteger8, bigInteger4).multiply(bigInteger6.modPow(bigInteger9, bigInteger4)).mod(bigInteger4).mod(bigInteger5);
        return bigInteger10.equals(bigInteger);
    }
}

