/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RSAKeyPairX509Codec
implements IKeyPairCodec {
    private static final Logger log = null;
    private static final OID RSA_ALG_OID = new OID("1.2.840.113549.1.1.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        byte[] byArray;
        if (!(publicKey instanceof GnuRSAPublicKey)) {
            throw new InvalidParameterException("key");
        }
        DERValue dERValue = new DERValue(6, RSA_ALG_OID);
        GnuRSAPublicKey gnuRSAPublicKey = (GnuRSAPublicKey)publicKey;
        BigInteger bigInteger = gnuRSAPublicKey.getN();
        BigInteger bigInteger2 = gnuRSAPublicKey.getE();
        DERValue dERValue2 = new DERValue(2, bigInteger);
        DERValue dERValue3 = new DERValue(2, bigInteger2);
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(2);
        arrayList.add(dERValue);
        arrayList.add(new DERValue(5, null));
        DERValue dERValue4 = new DERValue(48, arrayList);
        ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(2);
        arrayList2.add(dERValue2);
        arrayList2.add(dERValue3);
        DERValue dERValue5 = new DERValue(48, arrayList2);
        byte[] byArray2 = dERValue5.getEncoded();
        DERValue dERValue6 = new DERValue(3, new BitString(byArray2));
        ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(2);
        arrayList3.add(dERValue4);
        arrayList3.add(dERValue6);
        DERValue dERValue7 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue7);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            object = dERReader.read();
            DerUtil.checkIsConstructed((DERValue)object, "Wrong SubjectPublicKeyInfo field");
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong AlgorithmIdentifier field");
            DERValue dERValue2 = dERReader.read();
            if (!(dERValue2.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID oID = (OID)dERValue2.getValue();
            if (!oID.equals(RSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue3 = dERReader.read();
            if (dERValue3.getTag() == 5) {
                dERValue3 = dERReader.read();
            }
            if (!(dERValue3.getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] byArray2 = ((BitString)dERValue3.getValue()).toByteArray();
            dERReader = new DERReader(byArray2);
            dERValue3 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong subjectPublicKey field");
            dERValue3 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue3, "Wrong modulus field");
            bigInteger2 = (BigInteger)dERValue3.getValue();
            dERValue3 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue3, "Wrong publicExponent field");
            bigInteger = (BigInteger)dERValue3.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        object = new GnuRSAPublicKey(2, bigInteger2, bigInteger);
        return object;
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

