/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.interfaces.RSAKey;

public abstract class GnuRSAKey
implements Key,
RSAKey {
    private final BigInteger n;
    private final BigInteger e;
    protected final int defaultFormat;
    private transient String str;

    protected GnuRSAKey(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        this.defaultFormat = n <= 0 ? 1 : n;
        this.n = bigInteger;
        this.e = bigInteger2;
    }

    public BigInteger getModulus() {
        return this.getN();
    }

    public String getAlgorithm() {
        return "rsa";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public BigInteger getN() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.getE();
    }

    public BigInteger getE() {
        return this.e;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RSAKey)) {
            return false;
        }
        RSAKey rSAKey = (RSAKey)object;
        return this.n.equals(rSAKey.getModulus());
    }

    public String toString() {
        if (this.str == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = new CPStringBuilder(string).append("defaultFormat=").append(this.defaultFormat).append(",").append(string).append("n=0x").append(this.n.toString(16)).append(",").append(string).append("e=0x").append(this.e.toString(16)).toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);
}

