/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.hash.Sha160;
import gnu.java.security.util.PRNG;
import java.math.BigInteger;
import java.security.SecureRandom;

public class FIPS186 {
    public static final int DSA_PARAMS_SEED = 0;
    public static final int DSA_PARAMS_COUNTER = 1;
    public static final int DSA_PARAMS_Q = 2;
    public static final int DSA_PARAMS_P = 3;
    public static final int DSA_PARAMS_E = 4;
    public static final int DSA_PARAMS_G = 5;
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger TWO_POW_160 = TWO.pow(160);
    private Sha160 sha = new Sha160();
    private int L;
    private SecureRandom rnd = null;
    private PRNG prng = null;

    public FIPS186(int n, SecureRandom secureRandom) {
        this.L = n;
        this.rnd = secureRandom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger[] generateParameters() {
        BigInteger bigInteger;
        int n;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        byte[] byArray = new byte[20];
        int n2 = (this.L - 1) % 160;
        int n3 = (this.L - 1 - n2) / 160;
        BigInteger[] bigIntegerArray = new BigInteger[n3 + 1];
        block6: while (true) {
            int n4;
            byte[] byArray2;
            byte[] byArray3;
            this.nextRandomBytes(byArray);
            bigInteger3 = new BigInteger(1, byArray).setBit(159).setBit(0);
            BigInteger bigInteger4 = bigInteger3.add(BigInteger.ONE).mod(TWO_POW_160);
            Sha160 sha160 = this.sha;
            synchronized (sha160) {
                byArray3 = bigInteger3.toByteArray();
                this.sha.update(byArray3, 0, byArray3.length);
                byArray3 = this.sha.digest();
                byArray2 = bigInteger4.toByteArray();
                this.sha.update(byArray2, 0, byArray2.length);
                byArray2 = this.sha.digest();
            }
            for (n4 = 0; n4 < byArray3.length; ++n4) {
                int n5 = n4;
                byArray3[n5] = (byte)(byArray3[n5] ^ byArray2[n4]);
            }
            BigInteger bigInteger5 = new BigInteger(1, byArray3);
            bigInteger2 = bigInteger5.setBit(159).setBit(0);
            if (!bigInteger2.isProbablePrime(80)) continue;
            n = 0;
            int n6 = 2;
            do {
                BigInteger bigInteger6;
                BigInteger bigInteger7 = BigInteger.valueOf((long)n6 & 0xFFFFFFFFL);
                BigInteger bigInteger8 = bigInteger3.add(bigInteger7);
                Sha160 sha1602 = this.sha;
                synchronized (sha1602) {
                    for (int i = 0; i <= n3; ++i) {
                        byArray3 = bigInteger8.add(BigInteger.valueOf((long)i & 0xFFFFFFFFL)).mod(TWO_POW_160).toByteArray();
                        this.sha.update(byArray3, 0, byArray3.length);
                        bigIntegerArray[i] = new BigInteger(1, this.sha.digest());
                    }
                }
                BigInteger bigInteger9 = bigIntegerArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bigInteger9 = bigInteger9.add(bigIntegerArray[n4].multiply(TWO.pow(n4 * 160)));
                }
                BigInteger bigInteger10 = (bigInteger9 = bigInteger9.add(bigIntegerArray[n3].mod(TWO.pow(n2)).multiply(TWO.pow(n3 * 160)))).add(TWO.pow(this.L - 1));
                bigInteger = bigInteger10.subtract((bigInteger6 = bigInteger10.mod(TWO.multiply(bigInteger2))).subtract(BigInteger.ONE));
                if (bigInteger.compareTo(TWO.pow(this.L - 1)) >= 0 && bigInteger.isProbablePrime(80)) break block6;
                n6 += n3 + 1;
            } while (++n < 4096);
        }
        BigInteger bigInteger11 = bigInteger.subtract(BigInteger.ONE).divide(bigInteger2);
        BigInteger bigInteger12 = TWO;
        BigInteger bigInteger13 = bigInteger.subtract(BigInteger.ONE);
        BigInteger bigInteger14 = TWO;
        while (bigInteger12.compareTo(bigInteger13) < 0 && (bigInteger14 = bigInteger12.modPow(bigInteger11, bigInteger)).equals(BigInteger.ONE)) {
            bigInteger12 = bigInteger12.add(BigInteger.ONE);
        }
        return new BigInteger[]{bigInteger3, BigInteger.valueOf(n), bigInteger2, bigInteger, bigInteger11, bigInteger14};
    }

    private void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

