/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSPrivateKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class DSSKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final Logger log = null;
    private static final OID DSA_ALG_OID = new OID("1.2.840.10040.4.1");

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        byte[] byArray;
        if (!(privateKey instanceof DSSPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue dERValue = new DERValue(2, BigInteger.ZERO);
        DERValue dERValue2 = new DERValue(6, DSA_ALG_OID);
        DSSPrivateKey dSSPrivateKey = (DSSPrivateKey)privateKey;
        BigInteger bigInteger = dSSPrivateKey.getParams().getP();
        BigInteger bigInteger2 = dSSPrivateKey.getParams().getQ();
        BigInteger bigInteger3 = dSSPrivateKey.getParams().getG();
        BigInteger bigInteger4 = dSSPrivateKey.getX();
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(3);
        arrayList.add(new DERValue(2, bigInteger));
        arrayList.add(new DERValue(2, bigInteger2));
        arrayList.add(new DERValue(2, bigInteger3));
        DERValue dERValue3 = new DERValue(48, arrayList);
        ArrayList<DERValue> arrayList2 = new ArrayList<DERValue>(2);
        arrayList2.add(dERValue2);
        arrayList2.add(dERValue3);
        DERValue dERValue4 = new DERValue(48, arrayList2);
        DERValue dERValue5 = new DERValue(2, bigInteger4);
        DERValue dERValue6 = new DERValue(4, dERValue5.getEncoded());
        ArrayList<DERValue> arrayList3 = new ArrayList<DERValue>(3);
        arrayList3.add(dERValue);
        arrayList3.add(dERValue4);
        arrayList3.add(dERValue6);
        DERValue dERValue7 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue7);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong PrivateKeyInfo field");
            DERValue dERValue2 = dERReader.read();
            if (!(dERValue2.getValue() instanceof BigInteger)) {
                throw new InvalidParameterException("Wrong Version field");
            }
            BigInteger bigInteger5 = (BigInteger)dERValue2.getValue();
            if (bigInteger5.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + bigInteger5);
            }
            DERValue dERValue3 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue3, "Wrong AlgorithmIdentifier field");
            DERValue dERValue4 = dERReader.read();
            OID oID = (OID)dERValue4.getValue();
            if (!oID.equals(DSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue5 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue5, "Wrong DSS Parameters field");
            DERValue dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong P field");
            bigInteger4 = (BigInteger)dERValue6.getValue();
            dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong Q field");
            bigInteger3 = (BigInteger)dERValue6.getValue();
            dERValue6 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong G field");
            bigInteger2 = (BigInteger)dERValue6.getValue();
            dERValue6 = dERReader.read();
            byte[] byArray2 = (byte[])dERValue6.getValue();
            DERReader dERReader2 = new DERReader(byArray2);
            dERValue6 = dERReader2.read();
            DerUtil.checkIsBigInteger(dERValue6, "Wrong X field");
            bigInteger = (BigInteger)dERValue6.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException(iOException.getMessage());
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new DSSPrivateKey(3, bigInteger4, bigInteger3, bigInteger2, bigInteger);
    }
}

