/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.lang.CPStringBuilder;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public abstract class DSSKey
implements Key,
DSAKey {
    protected final BigInteger p;
    protected final BigInteger q;
    protected final BigInteger g;
    protected final int defaultFormat;
    private transient String str;

    protected DSSKey(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.defaultFormat = n <= 0 ? 1 : n;
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
    }

    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public String getAlgorithm() {
        return "dss";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public boolean equals(Object object) {
        if (this.hasInheritedParameters()) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DSAKey)) {
            return false;
        }
        DSAKey dSAKey = (DSAKey)object;
        return this.p.equals(dSAKey.getParams().getP()) && this.q.equals(dSAKey.getParams().getQ()) && this.g.equals(dSAKey.getParams().getG());
    }

    public String toString() {
        if (this.str == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            CPStringBuilder cPStringBuilder = new CPStringBuilder(string).append("defaultFormat=").append(this.defaultFormat).append(",").append(string);
            if (this.hasInheritedParameters()) {
                cPStringBuilder.append("p=inherited,").append(string).append("q=inherited,").append(string).append("g=inherited");
            } else {
                cPStringBuilder.append("p=0x").append(this.p.toString(16)).append(",").append(string).append("q=0x").append(this.q.toString(16)).append(",").append(string).append("g=0x").append(this.g.toString(16));
            }
            this.str = cPStringBuilder.toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);

    public boolean hasInheritedParameters() {
        return this.p == null && this.q == null && this.g == null;
    }
}

