/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.sig.SignatureFactory;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.logging.Logger;

class SignatureAdapter
extends SignatureSpi
implements Cloneable {
    private static final Logger log = null;
    private ISignature adaptee;
    private ISignatureCodec codec;

    protected SignatureAdapter(String string, ISignatureCodec iSignatureCodec) {
        this(SignatureFactory.getInstance(string), iSignatureCodec);
    }

    private SignatureAdapter(ISignature iSignature, ISignatureCodec iSignatureCodec) {
        this.adaptee = iSignature;
        this.codec = iSignatureCodec;
    }

    public Object clone() {
        return new SignatureAdapter((ISignature)this.adaptee.clone(), this.codec);
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        HashMap<String, PublicKey> hashMap = new HashMap<String, PublicKey>();
        hashMap.put("gnu.crypto.sig.public.key", publicKey);
        try {
            this.adaptee.setupVerify(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        HashMap<String, PrivateKey> hashMap = new HashMap<String, PrivateKey>();
        hashMap.put("gnu.crypto.sig.private.key", privateKey);
        try {
            this.adaptee.setupSign(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("gnu.crypto.sig.private.key", privateKey);
        hashMap.put("gnu.crypto.sig.prng", secureRandom);
        try {
            this.adaptee.setupSign(hashMap);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidKeyException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public void engineUpdate(byte by) throws SignatureException {
        try {
            this.adaptee.update(by);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    public void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.adaptee.update(byArray, n, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(illegalStateException.getMessage(), illegalStateException);
        }
    }

    public byte[] engineSign() throws SignatureException {
        Object object = null;
        try {
            object = this.adaptee.sign();
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(illegalStateException.getMessage(), illegalStateException);
        }
        byte[] byArray = this.codec.encodeSignature(object);
        return byArray;
    }

    public int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        int n3 = byArray2.length;
        if (n3 > n2) {
            throw new SignatureException("Not enough room to store signature");
        }
        System.arraycopy(byArray2, 0, byArray, n, n3);
        return n3;
    }

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        Object object = this.codec.decodeSignature(byArray);
        boolean bl = false;
        try {
            bl = this.adaptee.verify(object);
        }
        catch (IllegalStateException illegalStateException) {
            throw new SignatureException(illegalStateException.getMessage(), illegalStateException);
        }
        return bl;
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("deprecated");
    }

    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("deprecated");
    }
}

