/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.jce.sig.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.HashMap;

public class RSAKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public RSAKeyPairGeneratorSpi() {
        super("rsa");
    }

    public void initialize(int n, SecureRandom secureRandom) {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put("gnu.crypto.rsa.L", Integer.valueOf(n));
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.rsa.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.rsa.encoding", Integer.valueOf(4));
        this.adaptee.setup(hashMap);
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            hashMap.put("gnu.crypto.rsa.params", algorithmParameterSpec);
        }
        if (secureRandom != null) {
            hashMap.put("gnu.crypto.rsa.prng", secureRandom);
        }
        hashMap.put("gnu.crypto.rsa.encoding", 4);
        this.adaptee.setup(hashMap);
    }
}

