/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.prng;

import gnu.classpath.SystemProperties;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.java.security.jce.prng.VMSecureRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.java.security.prng.MDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SecureRandomAdapter
extends SecureRandomSpi {
    private boolean isSeeded = false;
    private MDGenerator adaptee = new MDGenerator();
    private String mdName;
    private static final Logger logger = Logger.getLogger(SecureRandom.class.getName());
    private static final String SECURERANDOM_SOURCE = "securerandom.source";
    private static final String JAVA_SECURITY_EGD = "java.security.egd";

    protected SecureRandomAdapter(String string) {
        this.mdName = string;
        this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.md.hash.name", string));
    }

    public static final byte[] getSeed(int n) {
        URL uRL = null;
        String string = null;
        byte[] byArray = new byte[n];
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction(SECURERANDOM_SOURCE);
        try {
            string = AccessController.doPrivileged(getSecurityPropertyAction);
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "securerandom.source property is malformed: {0}", string);
        }
        if (uRL == null) {
            try {
                string = SystemProperties.getProperty(JAVA_SECURITY_EGD);
                if (string != null) {
                    uRL = new URL(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.WARNING, "java.security.egd property is malformed: {0}", string);
            }
        }
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                inputStream.read(byArray);
                return byArray;
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "error reading random bytes", iOException);
            }
        }
        VMSecureRandom.generateSeed(byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] engineGenerateSeed(int n) {
        return SecureRandomAdapter.getSeed(n);
    }

    public void engineNextBytes(byte[] byArray) {
        if (!this.isSeeded) {
            this.engineSetSeed(this.engineGenerateSeed(32));
        }
        try {
            this.adaptee.nextBytes(byArray, 0, byArray.length);
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
    }

    public void engineSetSeed(byte[] byArray) {
        this.adaptee.addRandomBytes(byArray);
        this.isSeeded = true;
    }
}

