/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.hash;

import gnu.java.security.hash.BaseHash;
import gnu.java.security.util.Util;

public class Haval
extends BaseHash {
    public static final int HAVAL_VERSION = 1;
    public static final int HAVAL_128_BIT = 16;
    public static final int HAVAL_160_BIT = 20;
    public static final int HAVAL_192_BIT = 24;
    public static final int HAVAL_224_BIT = 28;
    public static final int HAVAL_256_BIT = 32;
    public static final int HAVAL_3_ROUND = 3;
    public static final int HAVAL_4_ROUND = 4;
    public static final int HAVAL_5_ROUND = 5;
    private static final int BLOCK_SIZE = 128;
    private static final String DIGEST0 = "C68F39913F901F3DDF44C707357A7D70";
    private static Boolean valid;
    private int rounds = 3;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int h5;
    private int h6;
    private int h7;

    public Haval() {
        this(16, 3);
    }

    public Haval(int n) {
        this(n, 3);
    }

    public Haval(int n, int n2) {
        super("haval", n, 128);
        if (n != 16 && n != 20 && n != 24 && n != 28 && n != 32) {
            throw new IllegalArgumentException("Invalid HAVAL output size");
        }
        if (n2 != 3 && n2 != 4 && n2 != 5) {
            throw new IllegalArgumentException("Invalid HAVAL number of rounds");
        }
        this.rounds = n2;
    }

    private Haval(Haval haval) {
        this(haval.hashSize, haval.rounds);
        this.h0 = haval.h0;
        this.h1 = haval.h1;
        this.h2 = haval.h2;
        this.h3 = haval.h3;
        this.h4 = haval.h4;
        this.h5 = haval.h5;
        this.h6 = haval.h6;
        this.h7 = haval.h7;
        this.count = haval.count;
        this.buffer = (byte[])haval.buffer.clone();
    }

    public Object clone() {
        return new Haval(this);
    }

    protected synchronized void transform(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n7 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n8 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n9 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n10 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n11 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n12 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n13 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n14 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n15 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n16 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n17 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n18 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n19 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n20 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n21 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n22 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n23 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n24 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n25 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n26 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n27 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n28 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n29 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n30 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n31 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n32 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n33 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n34 = this.h0;
        int n35 = this.h1;
        int n36 = this.h2;
        int n37 = this.h3;
        int n38 = this.h4;
        int n39 = this.h5;
        int n40 = this.h6;
        int n41 = this.h7;
        n41 = this.FF1(n41, n40, n39, n38, n37, n36, n35, n34, n2);
        n40 = this.FF1(n40, n39, n38, n37, n36, n35, n34, n41, n3);
        n39 = this.FF1(n39, n38, n37, n36, n35, n34, n41, n40, n4);
        n38 = this.FF1(n38, n37, n36, n35, n34, n41, n40, n39, n5);
        n37 = this.FF1(n37, n36, n35, n34, n41, n40, n39, n38, n6);
        n36 = this.FF1(n36, n35, n34, n41, n40, n39, n38, n37, n7);
        n35 = this.FF1(n35, n34, n41, n40, n39, n38, n37, n36, n8);
        n34 = this.FF1(n34, n41, n40, n39, n38, n37, n36, n35, n9);
        n41 = this.FF1(n41, n40, n39, n38, n37, n36, n35, n34, n10);
        n40 = this.FF1(n40, n39, n38, n37, n36, n35, n34, n41, n11);
        n39 = this.FF1(n39, n38, n37, n36, n35, n34, n41, n40, n12);
        n38 = this.FF1(n38, n37, n36, n35, n34, n41, n40, n39, n13);
        n37 = this.FF1(n37, n36, n35, n34, n41, n40, n39, n38, n14);
        n36 = this.FF1(n36, n35, n34, n41, n40, n39, n38, n37, n15);
        n35 = this.FF1(n35, n34, n41, n40, n39, n38, n37, n36, n16);
        n34 = this.FF1(n34, n41, n40, n39, n38, n37, n36, n35, n17);
        n41 = this.FF1(n41, n40, n39, n38, n37, n36, n35, n34, n18);
        n40 = this.FF1(n40, n39, n38, n37, n36, n35, n34, n41, n19);
        n39 = this.FF1(n39, n38, n37, n36, n35, n34, n41, n40, n20);
        n38 = this.FF1(n38, n37, n36, n35, n34, n41, n40, n39, n21);
        n37 = this.FF1(n37, n36, n35, n34, n41, n40, n39, n38, n22);
        n36 = this.FF1(n36, n35, n34, n41, n40, n39, n38, n37, n23);
        n35 = this.FF1(n35, n34, n41, n40, n39, n38, n37, n36, n24);
        n34 = this.FF1(n34, n41, n40, n39, n38, n37, n36, n35, n25);
        n41 = this.FF1(n41, n40, n39, n38, n37, n36, n35, n34, n26);
        n40 = this.FF1(n40, n39, n38, n37, n36, n35, n34, n41, n27);
        n39 = this.FF1(n39, n38, n37, n36, n35, n34, n41, n40, n28);
        n38 = this.FF1(n38, n37, n36, n35, n34, n41, n40, n39, n29);
        n37 = this.FF1(n37, n36, n35, n34, n41, n40, n39, n38, n30);
        n36 = this.FF1(n36, n35, n34, n41, n40, n39, n38, n37, n31);
        n35 = this.FF1(n35, n34, n41, n40, n39, n38, n37, n36, n32);
        n34 = this.FF1(n34, n41, n40, n39, n38, n37, n36, n35, n33);
        n41 = this.FF2(n41, n40, n39, n38, n37, n36, n35, n34, n7, 1160258022);
        n40 = this.FF2(n40, n39, n38, n37, n36, n35, n34, n41, n16, 953160567);
        n39 = this.FF2(n39, n38, n37, n36, n35, n34, n41, n40, n28, -1101764913);
        n38 = this.FF2(n38, n37, n36, n35, n34, n41, n40, n39, n20, 887688300);
        n37 = this.FF2(n37, n36, n35, n34, n41, n40, n39, n38, n13, -1062458953);
        n36 = this.FF2(n36, n35, n34, n41, n40, n39, n38, n37, n30, -914599715);
        n35 = this.FF2(n35, n34, n41, n40, n39, n38, n37, n36, n9, 1065670069);
        n34 = this.FF2(n34, n41, n40, n39, n38, n37, n36, n35, n18, -1253635817);
        n41 = this.FF2(n41, n40, n39, n38, n37, n36, n35, n34, n2, -1843997223);
        n40 = this.FF2(n40, n39, n38, n37, n36, n35, n34, n41, n25, -1988494565);
        n39 = this.FF2(n39, n38, n37, n36, n35, n34, n41, n40, n22, -785314906);
        n38 = this.FF2(n38, n37, n36, n35, n34, n41, n40, n39, n24, -1730169428);
        n37 = this.FF2(n37, n36, n35, n34, n41, n40, n39, n38, n3, 805139163);
        n36 = this.FF2(n36, n35, n34, n41, n40, n39, n38, n37, n12, -803545161);
        n35 = this.FF2(n35, n34, n41, n40, n39, n38, n37, n36, n6, -1193168915);
        n34 = this.FF2(n34, n41, n40, n39, n38, n37, n36, n35, n10, 1780907670);
        n41 = this.FF2(n41, n40, n39, n38, n37, n36, n35, n34, n32, -1166241723);
        n40 = this.FF2(n40, n39, n38, n37, n36, n35, n34, n41, n5, -248741991);
        n39 = this.FF2(n39, n38, n37, n36, n35, n34, n41, n40, n23, 614570311);
        n38 = this.FF2(n38, n37, n36, n35, n34, n41, n40, n39, n11, -1282315017);
        n37 = this.FF2(n37, n36, n35, n34, n41, n40, n39, n38, n19, 134345442);
        n36 = this.FF2(n36, n35, n34, n41, n40, n39, n38, n37, n26, -2054226922);
        n35 = this.FF2(n35, n34, n41, n40, n39, n38, n37, n36, n31, 1667834072);
        n34 = this.FF2(n34, n41, n40, n39, n38, n37, n36, n35, n8, 1901547113);
        n41 = this.FF2(n41, n40, n39, n38, n37, n36, n35, n34, n21, -1537671517);
        n40 = this.FF2(n40, n39, n38, n37, n36, n35, n34, n41, n14, -191677058);
        n39 = this.FF2(n39, n38, n37, n36, n35, n34, n41, n40, n17, 227898511);
        n38 = this.FF2(n38, n37, n36, n35, n34, n41, n40, n39, n15, 1921955416);
        n37 = this.FF2(n37, n36, n35, n34, n41, n40, n39, n38, n4, 1904987480);
        n36 = this.FF2(n36, n35, n34, n41, n40, n39, n38, n37, n27, -2112533778);
        n35 = this.FF2(n35, n34, n41, n40, n39, n38, n37, n36, n33, 2069144605);
        n34 = this.FF2(n34, n41, n40, n39, n38, n37, n36, n35, n29, -1034266187);
        n41 = this.FF3(n41, n40, n39, n38, n37, n36, n35, n34, n21, -1674521287);
        n40 = this.FF3(n40, n39, n38, n37, n36, n35, n34, n41, n11, 720527379);
        n39 = this.FF3(n39, n38, n37, n36, n35, n34, n41, n40, n6, -976113629);
        n38 = this.FF3(n38, n37, n36, n35, n34, n41, n40, n39, n22, 677414384);
        n37 = this.FF3(n37, n36, n35, n34, n41, n40, n39, n38, n30, -901678824);
        n36 = this.FF3(n36, n35, n34, n41, n40, n39, n38, n37, n19, -1193592593);
        n35 = this.FF3(n35, n34, n41, n40, n39, n38, n37, n36, n10, -1904616272);
        n34 = this.FF3(n34, n41, n40, n39, n38, n37, n36, n35, n24, 1614419982);
        n41 = this.FF3(n41, n40, n39, n38, n37, n36, n35, n34, n31, 1822297739);
        n40 = this.FF3(n40, n39, n38, n37, n36, n35, n34, n41, n16, -1340175810);
        n39 = this.FF3(n39, n38, n37, n36, n35, n34, n41, n40, n27, -686458943);
        n38 = this.FF3(n38, n37, n36, n35, n34, n41, n40, n39, n14, -1120842969);
        n37 = this.FF3(n37, n36, n35, n34, n41, n40, n39, n38, n26, 2024746970);
        n36 = this.FF3(n36, n35, n34, n41, n40, n39, n38, n37, n32, 1432378464);
        n35 = this.FF3(n35, n34, n41, n40, n39, n38, n37, n36, n18, -430627341);
        n34 = this.FF3(n34, n41, n40, n39, n38, n37, n36, n35, n28, -1437226092);
        n41 = this.FF3(n41, n40, n39, n38, n37, n36, n35, n34, n33, 1464375394);
        n40 = this.FF3(n40, n39, n38, n37, n36, n35, n34, n41, n17, 1676153920);
        n39 = this.FF3(n39, n38, n37, n36, n35, n34, n41, n40, n9, 1439316330);
        n38 = this.FF3(n38, n37, n36, n35, n34, n41, n40, n39, n5, 715854006);
        n37 = this.FF3(n37, n36, n35, n34, n41, n40, n39, n38, n3, -1261675468);
        n36 = this.FF3(n36, n35, n34, n41, n40, n39, n38, n37, n2, 289532110);
        n35 = this.FF3(n35, n34, n41, n40, n39, n38, n37, n36, n20, -1588296017);
        n34 = this.FF3(n34, n41, n40, n39, n38, n37, n36, n35, n29, 2087905683);
        n41 = this.FF3(n41, n40, n39, n38, n37, n36, n35, n34, n15, -1276242927);
        n40 = this.FF3(n40, n39, n38, n37, n36, n35, n34, n41, n8, 1668267050);
        n39 = this.FF3(n39, n38, n37, n36, n35, n34, n41, n40, n23, 732546397);
        n38 = this.FF3(n38, n37, n36, n35, n34, n41, n40, n39, n12, 1947742710);
        n37 = this.FF3(n37, n36, n35, n34, n41, n40, n39, n38, n25, -832815594);
        n36 = this.FF3(n36, n35, n34, n41, n40, n39, n38, n37, n13, -1685613794);
        n35 = this.FF3(n35, n34, n41, n40, n39, n38, n37, n36, n7, -1344882125);
        n34 = this.FF3(n34, n41, n40, n39, n38, n37, n36, n35, n4, 1814351708);
        if (this.rounds >= 4) {
            n41 = this.FF4(n41, n40, n39, n38, n37, n36, n35, n34, n26, 2050118529);
            n40 = this.FF4(n40, n39, n38, n37, n36, n35, n34, n41, n6, 680887927);
            n39 = this.FF4(n39, n38, n37, n36, n35, n34, n41, n40, n2, 999245976);
            n38 = this.FF4(n38, n37, n36, n35, n34, n41, n40, n39, n16, 1800124847);
            n37 = this.FF4(n37, n36, n35, n34, n41, n40, n39, n38, n4, -994056165);
            n36 = this.FF4(n36, n35, n34, n41, n40, n39, n38, n37, n9, 1713906067);
            n35 = this.FF4(n35, n34, n41, n40, n39, n38, n37, n36, n30, 1641548236);
            n34 = this.FF4(n34, n41, n40, n39, n38, n37, n36, n35, n25, -81679983);
            n41 = this.FF4(n41, n40, n39, n38, n37, n36, n35, n34, n28, 1216130144);
            n40 = this.FF4(n40, n39, n38, n37, n36, n35, n34, n41, n8, 1575780402);
            n39 = this.FF4(n39, n38, n37, n36, n35, n34, n41, n40, n32, -276538019);
            n38 = this.FF4(n38, n37, n36, n35, n34, n41, n40, n39, n22, -377129551);
            n37 = this.FF4(n37, n36, n35, n34, n41, n40, n39, n38, n20, -601480446);
            n36 = this.FF4(n36, n35, n34, n41, n40, n39, n38, n37, n27, -345695352);
            n35 = this.FF4(n35, n34, n41, n40, n39, n38, n37, n36, n21, 596196993);
            n34 = this.FF4(n34, n41, n40, n39, n38, n37, n36, n35, n5, -745100091);
            n41 = this.FF4(n41, n40, n39, n38, n37, n36, n35, n34, n24, 258830323);
            n40 = this.FF4(n40, n39, n38, n37, n36, n35, n34, n41, n13, -2081144263);
            n39 = this.FF4(n39, n38, n37, n36, n35, n34, n41, n40, n33, 772490370);
            n38 = this.FF4(n38, n37, n36, n35, n34, n41, n40, n39, n23, -1534844924);
            n37 = this.FF4(n37, n36, n35, n34, n41, n40, n39, n38, n10, 1774776394);
            n36 = this.FF4(n36, n35, n34, n41, n40, n39, n38, n37, n29, -1642095778);
            n35 = this.FF4(n35, n34, n41, n40, n39, n38, n37, n36, n14, 566650946);
            n34 = this.FF4(n34, n41, n40, n39, n38, n37, n36, n35, n11, -152474470);
            n41 = this.FF4(n41, n40, n39, n38, n37, n36, n35, n34, n3, 1728879713);
            n40 = this.FF4(n40, n39, n38, n37, n36, n35, n34, n41, n31, -1412200208);
            n39 = this.FF4(n39, n38, n37, n36, n35, n34, n41, n40, n7, 1783734482);
            n38 = this.FF4(n38, n37, n36, n35, n34, n41, n40, n39, n17, -665571480);
            n37 = this.FF4(n37, n36, n35, n34, n41, n40, n39, n38, n19, -1777359064);
            n36 = this.FF4(n36, n35, n34, n41, n40, n39, n38, n37, n12, -1420741725);
            n35 = this.FF4(n35, n34, n41, n40, n39, n38, n37, n36, n18, 1861159788);
            n34 = this.FF4(n34, n41, n40, n39, n38, n37, n36, n35, n15, 326777828);
            if (this.rounds == 5) {
                n41 = this.FF5(n41, n40, n39, n38, n37, n36, n35, n34, n29, -1170476976);
                n40 = this.FF5(n40, n39, n38, n37, n36, n35, n34, n41, n5, 2130389656);
                n39 = this.FF5(n39, n38, n37, n36, n35, n34, n41, n40, n23, -1578015459);
                n38 = this.FF5(n38, n37, n36, n35, n34, n41, n40, n39, n28, 967770486);
                n37 = this.FF5(n37, n36, n35, n34, n41, n40, n39, n38, n19, 1724537150);
                n36 = this.FF5(n36, n35, n34, n41, n40, n39, n38, n37, n13, -2109534584);
                n35 = this.FF5(n35, n34, n41, n40, n39, n38, n37, n36, n22, -1930525159);
                n34 = this.FF5(n34, n41, n40, n39, n38, n37, n36, n35, n31, 1164943284);
                n41 = this.FF5(n41, n40, n39, n38, n37, n36, n35, n34, n21, 2105845187);
                n40 = this.FF5(n40, n39, n38, n37, n36, n35, n34, n41, n2, 998989502);
                n39 = this.FF5(n39, n38, n37, n36, n35, n34, n41, n40, n14, -529566248);
                n38 = this.FF5(n38, n37, n36, n35, n34, n41, n40, n39, n9, -2050940813);
                n37 = this.FF5(n37, n36, n35, n34, n41, n40, n39, n38, n15, 1075463327);
                n36 = this.FF5(n36, n35, n34, n41, n40, n39, n38, n37, n10, 1455516326);
                n35 = this.FF5(n35, n34, n41, n40, n39, n38, n37, n36, n33, 1322494562);
                n34 = this.FF5(n34, n41, n40, n39, n38, n37, n36, n35, n12, 910128902);
                n41 = this.FF5(n41, n40, n39, n38, n37, n36, n35, n34, n7, 469688178);
                n40 = this.FF5(n40, n39, n38, n37, n36, n35, n34, n41, n11, 1117454909);
                n39 = this.FF5(n39, n38, n37, n36, n35, n34, n41, n40, n16, 936433444);
                n38 = this.FF5(n38, n37, n36, n35, n34, n41, n40, n39, n32, -804646328);
                n37 = this.FF5(n37, n36, n35, n34, n41, n40, n39, n38, n20, -619713837);
                n36 = this.FF5(n36, n35, n34, n41, n40, n39, n38, n37, n8, 1240580251);
                n35 = this.FF5(n35, n34, n41, n40, n39, n38, n37, n36, n30, 122909385);
                n34 = this.FF5(n34, n41, n40, n39, n38, n37, n36, n35, n26, -2137449605);
                n41 = this.FF5(n41, n40, n39, n38, n37, n36, n35, n34, n4, 634681816);
                n40 = this.FF5(n40, n39, n38, n37, n36, n35, n34, n41, n25, -152510729);
                n39 = this.FF5(n39, n38, n37, n36, n35, n34, n41, n40, n18, -469872614);
                n38 = this.FF5(n38, n37, n36, n35, n34, n41, n40, n39, n24, -1233564613);
                n37 = this.FF5(n37, n36, n35, n34, n41, n40, n39, n38, n6, -1754472259);
                n36 = this.FF5(n36, n35, n34, n41, n40, n39, n38, n37, n3, 79693498);
                n35 = this.FF5(n35, n34, n41, n40, n39, n38, n37, n36, n27, -1045868618);
                n34 = this.FF5(n34, n41, n40, n39, n38, n37, n36, n35, n17, 1084186820);
            }
        }
        this.h7 += n41;
        this.h6 += n40;
        this.h5 += n39;
        this.h4 += n38;
        this.h3 += n37;
        this.h2 += n36;
        this.h1 += n35;
        this.h0 += n34;
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 128L);
        int n2 = n < 118 ? 118 - n : 246 - n;
        byte[] byArray = new byte[n2 + 10];
        byArray[0] = 1;
        int n3 = this.hashSize * 8;
        int n4 = (n3 & 3) << 6;
        n4 |= (this.rounds & 7) << 3;
        byArray[n2++] = (byte)(n4 |= 1);
        byArray[n2++] = (byte)(n3 >>> 2);
        long l = this.count << 3;
        byArray[n2++] = (byte)l;
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2] = (byte)(l >>> 56);
        return byArray;
    }

    protected byte[] getResult() {
        this.tailorDigestBits();
        byte[] byArray = new byte[this.hashSize];
        if (this.hashSize >= 32) {
            byArray[31] = (byte)(this.h7 >>> 24);
            byArray[30] = (byte)(this.h7 >>> 16);
            byArray[29] = (byte)(this.h7 >>> 8);
            byArray[28] = (byte)this.h7;
        }
        if (this.hashSize >= 28) {
            byArray[27] = (byte)(this.h6 >>> 24);
            byArray[26] = (byte)(this.h6 >>> 16);
            byArray[25] = (byte)(this.h6 >>> 8);
            byArray[24] = (byte)this.h6;
        }
        if (this.hashSize >= 24) {
            byArray[23] = (byte)(this.h5 >>> 24);
            byArray[22] = (byte)(this.h5 >>> 16);
            byArray[21] = (byte)(this.h5 >>> 8);
            byArray[20] = (byte)this.h5;
        }
        if (this.hashSize >= 20) {
            byArray[19] = (byte)(this.h4 >>> 24);
            byArray[18] = (byte)(this.h4 >>> 16);
            byArray[17] = (byte)(this.h4 >>> 8);
            byArray[16] = (byte)this.h4;
        }
        byArray[15] = (byte)(this.h3 >>> 24);
        byArray[14] = (byte)(this.h3 >>> 16);
        byArray[13] = (byte)(this.h3 >>> 8);
        byArray[12] = (byte)this.h3;
        byArray[11] = (byte)(this.h2 >>> 24);
        byArray[10] = (byte)(this.h2 >>> 16);
        byArray[9] = (byte)(this.h2 >>> 8);
        byArray[8] = (byte)this.h2;
        byArray[7] = (byte)(this.h1 >>> 24);
        byArray[6] = (byte)(this.h1 >>> 16);
        byArray[5] = (byte)(this.h1 >>> 8);
        byArray[4] = (byte)this.h1;
        byArray[3] = (byte)(this.h0 >>> 24);
        byArray[2] = (byte)(this.h0 >>> 16);
        byArray[1] = (byte)(this.h0 >>> 8);
        byArray[0] = (byte)this.h0;
        return byArray;
    }

    protected void resetContext() {
        this.h0 = 608135816;
        this.h1 = -2052912941;
        this.h2 = 320440878;
        this.h3 = 57701188;
        this.h4 = -1542899678;
        this.h5 = 698298832;
        this.h6 = 137296536;
        this.h7 = -330404727;
    }

    public boolean selfTest() {
        if (valid == null) {
            String string = Util.toString(new Haval().digest());
            valid = DIGEST0.equals(string);
        }
        return valid;
    }

    private void tailorDigestBits() {
        switch (this.hashSize) {
            case 16: {
                int n = this.h7 & 0xFF | this.h6 & 0xFF000000 | this.h5 & 0xFF0000 | this.h4 & 0xFF00;
                this.h0 += n >>> 8 | n << 24;
                n = this.h7 & 0xFF00 | this.h6 & 0xFF | this.h5 & 0xFF000000 | this.h4 & 0xFF0000;
                this.h1 += n >>> 16 | n << 16;
                n = this.h7 & 0xFF0000 | this.h6 & 0xFF00 | this.h5 & 0xFF | this.h4 & 0xFF000000;
                this.h2 += n >>> 24 | n << 8;
                n = this.h7 & 0xFF000000 | this.h6 & 0xFF0000 | this.h5 & 0xFF00 | this.h4 & 0xFF;
                this.h3 += n;
                break;
            }
            case 20: {
                int n = this.h7 & 0x3F | this.h6 & 0xFE000000 | this.h5 & 0x1F80000;
                this.h0 += n >>> 19 | n << 13;
                n = this.h7 & 0xFC0 | this.h6 & 0x3F | this.h5 & 0xFE000000;
                this.h1 += n >>> 25 | n << 7;
                n = this.h7 & 0x7F000 | this.h6 & 0xFC0 | this.h5 & 0x3F;
                this.h2 += n;
                n = this.h7 & 0x1F80000 | this.h6 & 0x7F000 | this.h5 & 0xFC0;
                this.h3 += n >>> 6;
                n = this.h7 & 0xFE000000 | this.h6 & 0x1F80000 | this.h5 & 0x7F000;
                this.h4 += n >>> 12;
                break;
            }
            case 24: {
                int n = this.h7 & 0x1F | this.h6 & 0xFC000000;
                this.h0 += n >>> 26 | n << 6;
                n = this.h7 & 0x3E0 | this.h6 & 0x1F;
                this.h1 += n;
                n = this.h7 & 0xFC00 | this.h6 & 0x3E0;
                this.h2 += n >>> 5;
                n = this.h7 & 0x1F0000 | this.h6 & 0xFC00;
                this.h3 += n >>> 10;
                n = this.h7 & 0x3E00000 | this.h6 & 0x1F0000;
                this.h4 += n >>> 16;
                n = this.h7 & 0xFC000000 | this.h6 & 0x3E00000;
                this.h5 += n >>> 21;
                break;
            }
            case 28: {
                this.h0 += this.h7 >>> 27 & 0x1F;
                this.h1 += this.h7 >>> 22 & 0x1F;
                this.h2 += this.h7 >>> 18 & 0xF;
                this.h3 += this.h7 >>> 13 & 0x1F;
                this.h4 += this.h7 >>> 9 & 0xF;
                this.h5 += this.h7 >>> 4 & 0x1F;
                this.h6 += this.h7 & 0xF;
            }
        }
    }

    private int FF1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        switch (this.rounds) {
            case 3: {
                n10 = this.f1(n7, n8, n5, n3, n2, n6, n4);
                break;
            }
            case 4: {
                n10 = this.f1(n6, n2, n7, n4, n3, n5, n8);
                break;
            }
            default: {
                n10 = this.f1(n5, n4, n7, n8, n3, n6, n2);
            }
        }
        return (n10 >>> 7 | n10 << 25) + (n >>> 11 | n << 21) + n9;
    }

    private int FF2(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.rounds) {
            case 3: {
                n11 = this.f2(n4, n6, n7, n8, n3, n5, n2);
                break;
            }
            case 4: {
                n11 = this.f2(n5, n3, n6, n8, n7, n2, n4);
                break;
            }
            default: {
                n11 = this.f2(n2, n6, n7, n8, n5, n4, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF3(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.rounds) {
            case 3: {
                n11 = this.f3(n2, n7, n6, n5, n4, n3, n8);
                break;
            }
            case 4: {
                n11 = this.f3(n7, n4, n5, n2, n8, n6, n3);
                break;
            }
            default: {
                n11 = this.f3(n6, n2, n8, n4, n5, n7, n3);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF4(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11;
        switch (this.rounds) {
            case 4: {
                n11 = this.f4(n2, n4, n8, n3, n6, n7, n5);
                break;
            }
            default: {
                n11 = this.f4(n7, n3, n5, n6, n8, n4, n2);
            }
        }
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int FF5(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = this.f5(n6, n3, n8, n2, n4, n5, n7);
        return (n11 >>> 7 | n11 << 25) + (n >>> 11 | n << 21) + n9 + n10;
    }

    private int f1(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n6 & (n7 ^ n3) ^ n5 & n2 ^ n4 & n ^ n7;
    }

    private int f2(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n5 & (n6 & ~n4 ^ n3 & n2 ^ n ^ n7) ^ n3 & (n6 ^ n2) ^ n4 & n2 ^ n7;
    }

    private int f3(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n4 & (n6 & n5 ^ n ^ n7) ^ n6 & n3 ^ n5 & n2 ^ n7;
    }

    private int f4(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n3 & (n2 & ~n5 ^ n4 & ~n ^ n6 ^ n ^ n7) ^ n4 & (n6 & n5 ^ n2 ^ n) ^ n5 & n ^ n7;
    }

    private int f5(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return n7 & (n6 & n5 & n4 ^ ~n2) ^ n6 & n3 ^ n5 & n2 ^ n4 & n;
    }
}

