/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.action.GetPropertyAction;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PolicyFile
extends Policy {
    protected static final Logger logger = SystemLogger.SYSTEM;
    private static GetPropertyAction prop = new GetPropertyAction("file.separator");
    private static final String fs = AccessController.doPrivileged(prop);
    private static final String DEFAULT_POLICY = AccessController.doPrivileged(prop.setParameters("java.home")) + fs + "lib" + fs + "security" + fs + "java.policy";
    private static final String DEFAULT_USER_POLICY = AccessController.doPrivileged(prop.setParameters("user.home")) + fs + ".java.policy";
    private final Map cs2pc = new HashMap();
    private static final int STATE_BEGIN = 0;
    private static final int STATE_GRANT = 1;
    private static final int STATE_PERMS = 2;

    public PolicyFile() {
        this.refresh();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        for (Map.Entry entry : this.cs2pc.entrySet()) {
            CodeSource codeSource2 = (CodeSource)entry.getKey();
            if (codeSource2.implies(codeSource)) {
                logger.log((Level)Component.POLICY, "{0} -> {1}", new Object[]{codeSource2, codeSource});
                PermissionCollection permissionCollection = (PermissionCollection)entry.getValue();
                Enumeration<Permission> enumeration = permissionCollection.elements();
                while (enumeration.hasMoreElements()) {
                    permissions.add(enumeration.nextElement());
                }
                continue;
            }
            logger.log((Level)Component.POLICY, "{0} !-> {1}", new Object[]{codeSource2, codeSource});
        }
        logger.log((Level)Component.POLICY, "returning permissions {0} for {1}", new Object[]{permissions, codeSource});
        return permissions;
    }

    public void refresh() {
        this.cs2pc.clear();
        final LinkedList linkedList = new LinkedList();
        try {
            linkedList.add(new File(DEFAULT_POLICY).toURL());
            linkedList.add(new File(DEFAULT_USER_POLICY).toURL());
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string = Security.getProperty("policy.allowSystemProperty");
                    if (string == null || Boolean.getBoolean(string)) {
                        String string2 = System.getProperty("java.security.policy");
                        logger.log((Level)Component.POLICY, "java.security.policy={0}", string2);
                        if (string2 != null) {
                            boolean bl = string2.startsWith("=");
                            if (bl) {
                                string2 = string2.substring(1);
                            }
                            linkedList.clear();
                            linkedList.add(new URL(string2));
                            if (bl) {
                                return null;
                            }
                        }
                    }
                    int n = 1;
                    while (true) {
                        String string3 = "policy.url." + n;
                        String string4 = Security.getProperty(string3);
                        logger.log((Level)Component.POLICY, "{0}={1}", new Object[]{string3, string4});
                        if (string4 == null) break;
                        linkedList.add(new URL(string4));
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            logger.log((Level)Component.POLICY, "reading policy properties", privilegedActionException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log((Level)Component.POLICY, "setting default policies", malformedURLException);
        }
        logger.log((Level)Component.POLICY, "building policy from URLs {0}", linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            try {
                URL uRL = (URL)iterator.next();
                this.parse(uRL);
            }
            catch (IOException iOException) {
                logger.log((Level)Component.POLICY, "reading policy", iOException);
            }
        }
    }

    public String toString() {
        return super.toString() + " [ " + this.cs2pc.toString() + " ]";
    }

    private void parse(URL uRL) throws IOException {
        int n;
        logger.log((Level)Component.POLICY, "reading policy file from {0}", uRL);
        StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(uRL.openStream()));
        streamTokenizer.resetSyntax();
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(12, 12);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.quoteChar(39);
        streamTokenizer.quoteChar(34);
        int n2 = 0;
        LinkedList linkedList = new LinkedList();
        URL uRL2 = null;
        LinkedList<Certificate> linkedList2 = new LinkedList<Certificate>();
        Permissions permissions = new Permissions();
        block26: while ((n = streamTokenizer.nextToken()) != -1) {
            Object object;
            Constructor constructor2;
            Object object22;
            Object object3;
            Object object4;
            switch (n) {
                case 123: {
                    if (n2 != 1) {
                        PolicyFile.error(uRL, streamTokenizer, "spurious '{'");
                    }
                    n2 = 2;
                    n = streamTokenizer.nextToken();
                    break;
                }
                case 125: {
                    if (n2 != 2) {
                        PolicyFile.error(uRL, streamTokenizer, "spurious '}'");
                    }
                    n2 = 0;
                    permissions.setReadOnly();
                    object4 = null;
                    if (!linkedList2.isEmpty()) {
                        object4 = linkedList2.toArray((T[])new Certificate[linkedList2.size()]);
                    }
                    this.cs2pc.put(new CodeSource(uRL2, (Certificate[])object4), permissions);
                    linkedList2.clear();
                    permissions = new Permissions();
                    uRL2 = null;
                    n = streamTokenizer.nextToken();
                    if (n == 59) continue block26;
                    streamTokenizer.pushBack();
                    continue block26;
                }
            }
            if (n != -3) {
                PolicyFile.error(uRL, streamTokenizer, "expecting word token");
            }
            if (streamTokenizer.sval.equalsIgnoreCase("keystore")) {
                object4 = KeyStore.getDefaultType();
                n = streamTokenizer.nextToken();
                if (n != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting key store URL");
                }
                object3 = streamTokenizer.sval;
                n = streamTokenizer.nextToken();
                if (n == 44) {
                    n = streamTokenizer.nextToken();
                    if (n != 34 && n != 39) {
                        PolicyFile.error(uRL, streamTokenizer, "expecting key store type");
                    }
                    object4 = streamTokenizer.sval;
                    n = streamTokenizer.nextToken();
                }
                if (n != 59) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting semicolon");
                }
                try {
                    object22 = KeyStore.getInstance((String)object4);
                    ((KeyStore)object22).load(new URL(uRL, (String)object3).openStream(), null);
                    linkedList.add(object22);
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("grant")) {
                if (n2 != 0) {
                    PolicyFile.error(uRL, streamTokenizer, "extraneous grant keyword");
                }
                n2 = 1;
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("signedBy")) {
                if (n2 != 1 && n2 != 2) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'signedBy'");
                }
                if (linkedList.isEmpty()) {
                    PolicyFile.error(uRL, streamTokenizer, "'signedBy' with no keystores");
                }
                if ((n = streamTokenizer.nextToken()) != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting signedBy name");
                }
                object4 = new StringTokenizer(streamTokenizer.sval, ",");
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object4).nextToken();
                    for (Constructor constructor2 : linkedList) {
                        try {
                            if (!((KeyStore)((Object)constructor2)).isCertificateEntry((String)object3)) continue;
                            linkedList2.add(((KeyStore)((Object)constructor2)).getCertificate((String)object3));
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                }
                n = streamTokenizer.nextToken();
                if (n == 44) continue;
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious ','");
                }
                streamTokenizer.pushBack();
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("codeBase")) {
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'codeBase'");
                }
                if ((n = streamTokenizer.nextToken()) != 34 && n != 39) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting code base URL");
                }
                object4 = PolicyFile.expand(streamTokenizer.sval);
                if (File.separatorChar != '/') {
                    object4 = ((String)object4).replace(File.separatorChar, '/');
                }
                try {
                    uRL2 = new URL((String)object4);
                }
                catch (MalformedURLException malformedURLException) {
                    PolicyFile.error(uRL, streamTokenizer, malformedURLException.toString());
                }
                if ((n = streamTokenizer.nextToken()) == 44) continue;
                streamTokenizer.pushBack();
                continue;
            }
            if (streamTokenizer.sval.equalsIgnoreCase("principal")) {
                if (n2 != 1) {
                    PolicyFile.error(uRL, streamTokenizer, "spurious 'principal'");
                }
                if ((n = streamTokenizer.nextToken()) == -3) {
                    n = streamTokenizer.nextToken();
                    if (n != 34 && n != 39) {
                        PolicyFile.error(uRL, streamTokenizer, "expecting principal name");
                    }
                    object4 = streamTokenizer.sval;
                    object3 = null;
                    try {
                        object22 = Class.forName(streamTokenizer.sval);
                        constructor2 = ((Class)object22).getConstructor(String.class);
                        object3 = (Principal)constructor2.newInstance(object4);
                    }
                    catch (Exception exception) {
                        PolicyFile.error(uRL, streamTokenizer, exception.toString());
                    }
                    for (Constructor constructor2 : linkedList) {
                        try {
                            object = ((KeyStore)((Object)constructor2)).aliases();
                            while (object.hasMoreElements()) {
                                Certificate certificate;
                                String string = object.nextElement();
                                if (!((KeyStore)((Object)constructor2)).isCertificateEntry(string) || !((certificate = ((KeyStore)((Object)constructor2)).getCertificate(string)) instanceof X509Certificate) || !object3.equals(((X509Certificate)certificate).getSubjectDN()) && !object3.equals(((X509Certificate)certificate).getSubjectX500Principal())) continue;
                                linkedList2.add(certificate);
                            }
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                } else if (n == 34 || n == 39) {
                    object4 = streamTokenizer.sval;
                    for (Object object22 : linkedList) {
                        try {
                            if (!((KeyStore)object22).isCertificateEntry((String)object4)) continue;
                            linkedList2.add(((KeyStore)object22).getCertificate((String)object4));
                        }
                        catch (KeyStoreException keyStoreException) {
                            PolicyFile.error(uRL, streamTokenizer, keyStoreException.toString());
                        }
                    }
                } else {
                    PolicyFile.error(uRL, streamTokenizer, "expecting principal");
                }
                if ((n = streamTokenizer.nextToken()) == 44) continue;
                streamTokenizer.pushBack();
                continue;
            }
            if (!streamTokenizer.sval.equalsIgnoreCase("permission")) continue;
            if (n2 != 2) {
                PolicyFile.error(uRL, streamTokenizer, "spurious 'permission'");
            }
            if ((n = streamTokenizer.nextToken()) != -3) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission class name");
            }
            object4 = streamTokenizer.sval;
            object3 = null;
            try {
                object3 = Class.forName((String)object4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            n = streamTokenizer.nextToken();
            if (n == 59) {
                if (object3 == null) {
                    permissions.add(new UnresolvedPermission((String)object4, null, null, linkedList2.toArray((T[])new Certificate[linkedList2.size()])));
                    continue;
                }
                try {
                    permissions.add((Permission)((Class)object3).newInstance());
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (n != 34 && n != 39) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission target");
            }
            object22 = PolicyFile.expand(streamTokenizer.sval);
            n = streamTokenizer.nextToken();
            if (n == 59) {
                if (object3 == null) {
                    permissions.add(new UnresolvedPermission((String)object4, (String)object22, null, linkedList2.toArray((T[])new Certificate[linkedList2.size()])));
                    continue;
                }
                try {
                    constructor2 = ((Class)object3).getConstructor(String.class);
                    permissions.add((Permission)constructor2.newInstance(object22));
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                continue;
            }
            if (n != 44) {
                PolicyFile.error(uRL, streamTokenizer, "expecting ','");
            }
            if ((n = streamTokenizer.nextToken()) == -3) {
                if (!streamTokenizer.sval.equalsIgnoreCase("signedBy")) {
                    PolicyFile.error(uRL, streamTokenizer, "expecting 'signedBy'");
                }
                try {
                    constructor2 = ((Class)object3).getConstructor(String.class);
                    permissions.add((Permission)constructor2.newInstance(object22));
                }
                catch (Exception exception) {
                    PolicyFile.error(uRL, streamTokenizer, exception.toString());
                }
                streamTokenizer.pushBack();
                continue;
            }
            if (n != 34 && n != 39) {
                PolicyFile.error(uRL, streamTokenizer, "expecting permission action");
            }
            constructor2 = streamTokenizer.sval;
            if (object3 == null) {
                permissions.add(new UnresolvedPermission((String)object4, (String)object22, (String)((Object)constructor2), linkedList2.toArray((T[])new Certificate[linkedList2.size()])));
                continue;
            }
            try {
                object = ((Class)object3).getConstructor(String.class, String.class);
                permissions.add((Permission)((Constructor)object).newInstance(object22, constructor2));
            }
            catch (Exception exception) {
                PolicyFile.error(uRL, streamTokenizer, exception.toString());
            }
            if ((n = streamTokenizer.nextToken()) == 59 || n == 44) continue;
            PolicyFile.error(uRL, streamTokenizer, "expecting ';' or ','");
        }
    }

    private static String expand(String string) {
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        CPStringBuilder cPStringBuilder2 = new CPStringBuilder();
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (n) {
                case 0: {
                    if (string.charAt(i) == '$') {
                        n = 1;
                        continue block5;
                    }
                    cPStringBuilder.append(string.charAt(i));
                    continue block5;
                }
                case 1: {
                    if (string.charAt(i) == '{') {
                        n = 2;
                        continue block5;
                    }
                    n = 0;
                    cPStringBuilder.append('$').append(string.charAt(i));
                    continue block5;
                }
                case 2: {
                    if (string.charAt(i) == '}') {
                        String string2 = cPStringBuilder2.toString();
                        if (string2.equals("/")) {
                            string2 = "file.separator";
                        }
                        if ((string2 = System.getProperty(string2)) == null) {
                            string2 = "";
                        }
                        cPStringBuilder.append(string2);
                        cPStringBuilder2.setLength(0);
                        n = 0;
                        continue block5;
                    }
                    cPStringBuilder2.append(string.charAt(i));
                }
            }
        }
        if (n != 0) {
            cPStringBuilder.append('$').append('{').append(cPStringBuilder2);
        }
        return cPStringBuilder.toString();
    }

    private static void error(URL uRL, StreamTokenizer streamTokenizer, String string) throws IOException {
        throw new IOException(uRL + ":" + streamTokenizer.lineno() + ": " + string);
    }
}

