/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security;

import gnu.java.lang.CPStringBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Enumeration;

public final class Engine {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final int MAX_ALIASES = 5;
    private static final Object[] NO_ARGS = new Object[0];

    private Engine() {
    }

    public static Object getInstance(String string, String string2, Provider provider) throws InvocationTargetException, NoSuchAlgorithmException {
        return Engine.getInstance(string, string2, provider, NO_ARGS);
    }

    public static Object getInstance(String string, String string2, Provider provider, Object[] objectArray) throws InvocationTargetException, NoSuchAlgorithmException {
        if (string == null) {
            throw new IllegalArgumentException("service MUST NOT be null");
        }
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException("service MUST NOT be empty");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("algorithm MUST NOT be null");
        }
        if ((string2 = string2.trim()).length() == 0) {
            throw new IllegalArgumentException("algorithm MUST NOT be empty");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if (objectArray == null) {
            throw new IllegalArgumentException("Constructor's parameters MUST NOT be null");
        }
        Enumeration<?> enumeration = provider.propertyNames();
        String string3 = null;
        int n = 0;
        boolean bl = false;
        CPStringBuilder cPStringBuilder = new CPStringBuilder();
        while (enumeration.hasMoreElements()) {
            String string4;
            string3 = (String)enumeration.nextElement();
            if (string3.equalsIgnoreCase(string + "." + string2)) {
                string2 = string3.substring(string.length() + 1);
                bl = true;
                break;
            }
            if (!string3.equalsIgnoreCase(ALG_ALIAS + string + "." + string2) || string2.equalsIgnoreCase(string4 = provider.getProperty(string3))) continue;
            string2 = string4;
            if (n++ > 5) {
                cPStringBuilder.append("Algorithm [").append(string2).append("] of type [").append(string).append("] from provider [").append(provider).append("] has too many aliases");
                throw new NoSuchAlgorithmException(cPStringBuilder.toString());
            }
            enumeration = provider.propertyNames();
        }
        if (!bl) {
            cPStringBuilder.append("Algorithm [").append(string2).append("] of type [").append(string).append("] from provider [").append(provider).append("] is not found");
            throw new NoSuchAlgorithmException(cPStringBuilder.toString());
        }
        Class<?> clazz = null;
        ClassLoader classLoader = provider.getClass().getClassLoader();
        Constructor constructor = null;
        String string5 = provider.getProperty(string3);
        cPStringBuilder.append("Class [").append(string5).append("] for algorithm [").append(string2).append("] of type [").append(string).append("] from provider [").append(provider).append("] ");
        Throwable throwable = null;
        try {
            clazz = classLoader != null ? classLoader.loadClass(string5) : Class.forName(string5);
            constructor = Engine.getCompatibleConstructor(clazz, objectArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            cPStringBuilder.append("cannot not be found");
            throwable = classNotFoundException;
        }
        catch (IllegalAccessException illegalAccessException) {
            cPStringBuilder.append("cannot be accessed");
            throwable = illegalAccessException;
        }
        catch (InstantiationException instantiationException) {
            cPStringBuilder.append("cannot be instantiated");
            throwable = instantiationException;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            cPStringBuilder.append("cannot be initialized");
            throwable = exceptionInInitializerError;
        }
        catch (SecurityException securityException) {
            cPStringBuilder.append("caused a security violation");
            throwable = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            cPStringBuilder.append("does not have/expose an appropriate constructor");
            throwable = noSuchMethodException;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(cPStringBuilder.toString());
        noSuchAlgorithmException.initCause(throwable);
        throw noSuchAlgorithmException;
    }

    private static Constructor getCompatibleConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        block0: for (int i = 0; i < constructorArray.length; ++i) {
            Class<?>[] classArray = constructorArray[i].getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            for (int j = 0; j < classArray.length; ++j) {
                if (objectArray[j] != null && !classArray[j].isAssignableFrom(objectArray[j].getClass())) continue block0;
            }
            return constructorArray[i];
        }
        throw new NoSuchMethodException();
    }
}

