/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.dgc.LeaseRenewingTask;
import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastConnectionManager;
import gnu.java.rmi.server.UnicastRemoteCall;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.dgc.Lease;
import java.rmi.server.ObjID;
import java.rmi.server.Operation;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.UID;

public class UnicastRef
implements RemoteRef,
ProtocolConstants {
    private static final long serialVersionUID = 1L;
    public ObjID objid;
    UnicastConnectionManager manager;
    static long dgcSequence;
    static final ObjID dgcId;
    ObjID[] this_id;
    static int DIRTY;
    static final long dgcInterfaceHash = -669196253586618813L;

    public UnicastRef() {
    }

    public UnicastRef(ObjID objID, String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        this(objID);
        this.manager = UnicastConnectionManager.getInstance(string, n, rMIClientSocketFactory);
    }

    public UnicastRef(ObjID objID) {
        this.objid = objID;
    }

    public Object invoke(Remote remote, Method method, Object[] objectArray, long l) throws Exception {
        Object object = this.manager.serverobj;
        if (object != null && method.getDeclaringClass().isInstance(object)) {
            Object object2 = null;
            try {
                object2 = method.invoke(object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Exception)invocationTargetException.getTargetException();
            }
            return object2;
        }
        return this.invokeCommon(remote, method, objectArray, -1, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease notifyDGC(Lease lease) throws Exception {
        Object object;
        int n;
        long l;
        Object object2 = dgcId;
        synchronized (object2) {
            l = dgcSequence++;
        }
        if (this.this_id == null) {
            this.this_id = new ObjID[]{this.objid};
        }
        try {
            object2 = this.manager.getConnection();
        }
        catch (IOException iOException) {
            throw new RemoteException("connection failed to host: " + this.manager.serverName, iOException);
        }
        try {
            DataOutputStream dataOutputStream = ((UnicastConnection)object2).getDataOutputStream();
            dataOutputStream.writeByte(80);
            ObjectOutputStream objectOutputStream = ((UnicastConnection)object2).startObjectOutputStream();
            dgcId.write(objectOutputStream);
            objectOutputStream.writeInt(DIRTY);
            objectOutputStream.writeLong(-669196253586618813L);
            RMIObjectOutputStream rMIObjectOutputStream = (RMIObjectOutputStream)objectOutputStream;
            rMIObjectOutputStream.writeValue(this.this_id, this.this_id.getClass());
            rMIObjectOutputStream.writeLong(l);
            rMIObjectOutputStream.writeValue(lease, lease.getClass());
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RemoteException("DGC call failed: ", iOException);
        }
        try {
            DataInputStream dataInputStream = ((UnicastConnection)object2).getDataInputStream();
            n = dataInputStream.readUnsignedByte();
            if (n != 81) {
                ((UnicastConnection)object2).disconnect();
                throw new RemoteException("DGC Call not acked:" + n);
            }
            ObjectInputStream objectInputStream = ((UnicastConnection)object2).startObjectInputStream();
            n = objectInputStream.readUnsignedByte();
            UID uID = UID.read(objectInputStream);
            object = n == 2 ? objectInputStream.readObject() : ((RMIObjectInputStream)objectInputStream).readValue(Lease.class);
        }
        catch (IOException iOException) {
            throw new RemoteException("DGC call return failed: ", iOException);
        }
        this.manager.discardConnection((UnicastConnection)object2);
        if (n != 1 && object != null) {
            if (n == 2) {
                throw (Exception)object;
            }
            throw new RemoteException("DGC unexpected returncode: " + n);
        }
        return (Lease)object;
    }

    protected Object invokeCommon(Remote remote, Method method, Object[] objectArray, int n, long l) throws Exception {
        try {
            UnicastConnection unicastConnection = this.manager.getConnection();
            return this.invokeCommon(unicastConnection, remote, method, objectArray, n, l);
        }
        catch (IOException iOException) {
            throw new RemoteException("connection failed to host: " + this.manager.serverName, iOException);
        }
    }

    protected Object invokeCommon(UnicastConnection unicastConnection, Remote remote, Method method, Object[] objectArray, int n, long l) throws Exception {
        Object object;
        int n2;
        try {
            DataOutputStream dataOutputStream = unicastConnection.getDataOutputStream();
            dataOutputStream.writeByte(80);
            ObjectOutputStream objectOutputStream = unicastConnection.startObjectOutputStream();
            this.objid.write(objectOutputStream);
            objectOutputStream.writeInt(n);
            objectOutputStream.writeLong(l);
            Class<?>[] classArray = method.getParameterTypes();
            for (int i = 0; i < classArray.length; ++i) {
                ((RMIObjectOutputStream)objectOutputStream).writeValue(objectArray[i], classArray[i]);
            }
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RemoteException("call failed: ", iOException);
        }
        try {
            DataInputStream dataInputStream = unicastConnection.getDataInputStream();
            n2 = dataInputStream.readUnsignedByte();
            if (n2 != 81) {
                unicastConnection.disconnect();
                throw new RemoteException("Call not acked:" + n2);
            }
            ObjectInputStream objectInputStream = unicastConnection.startObjectInputStream();
            n2 = objectInputStream.readUnsignedByte();
            UID uID = UID.read(objectInputStream);
            Class<?> clazz = method.getReturnType();
            object = n2 == 2 ? objectInputStream.readObject() : (clazz == Void.TYPE ? null : ((RMIObjectInputStream)objectInputStream).readValue(clazz));
        }
        catch (IOException iOException) {
            throw new RemoteException("call return failed: ", iOException);
        }
        this.manager.discardConnection(unicastConnection);
        if (n2 != 1 && object != null) {
            if (n2 == 2) {
                throw (Exception)object;
            }
            throw new RemoteException("unexpected returncode: " + n2);
        }
        return object;
    }

    public RemoteCall newCall(RemoteObject remoteObject, Operation[] operationArray, int n, long l) throws RemoteException {
        UnicastConnection unicastConnection;
        try {
            unicastConnection = this.manager.getConnection();
        }
        catch (IOException iOException) {
            throw new ConnectException("connection failed to host: " + this.manager.serverName, iOException);
        }
        return new UnicastRemoteCall(unicastConnection, this.objid, n, l);
    }

    public void invoke(RemoteCall remoteCall) throws Exception {
        UnicastRemoteCall unicastRemoteCall = (UnicastRemoteCall)remoteCall;
        remoteCall.executeCall();
    }

    public void done(RemoteCall remoteCall) throws RemoteException {
        UnicastRemoteCall unicastRemoteCall = (UnicastRemoteCall)remoteCall;
        try {
            unicastRemoteCall.done();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        UnicastConnection unicastConnection = unicastRemoteCall.getConnection();
        this.manager.discardConnection(unicastConnection);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.manager == null) {
            throw new IOException("no connection");
        }
        this.manager.write(objectOutput);
        this.objid.write(objectOutput);
        objectOutput.writeByte(0);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.manager = UnicastConnectionManager.read(objectInput);
        this.objid = ObjID.read(objectInput);
        byte by = objectInput.readByte();
        if (by != 1 && by != 0) {
            throw new IOException("no ack found");
        }
        if (this.manager.serverobj == null) {
            LeaseRenewingTask.scheduleLeases(this);
        }
    }

    public boolean remoteEquals(RemoteRef remoteRef) {
        throw new Error("Not implemented");
    }

    public int remoteHashCode() {
        throw new Error("Not implemented");
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastRef";
    }

    public String remoteToString() {
        if (this.manager != null) {
            return this.manager.toString();
        }
        return "null manager";
    }

    public void dump(UnicastConnection unicastConnection) {
        try {
            DataInputStream dataInputStream = unicastConnection.getDataInputStream();
            while (true) {
                int n = dataInputStream.readUnsignedByte();
                System.out.print(Integer.toHexString(n));
                if (n >= 32 && n < 128) {
                    System.out.print(": " + (char)n);
                }
                System.out.println();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof UnicastRef) {
            UnicastRef unicastRef = (UnicastRef)object;
            return unicastRef.manager.equals(this.manager) && unicastRef.objid.equals(this.objid);
        }
        return false;
    }

    public int hashCode() {
        return this.manager.hashCode() ^ this.objid.hashCode();
    }

    static {
        dgcId = new ObjID(2);
        DIRTY = 1;
    }
}

