/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.classpath.VMStackWalker;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;

public class RMIObjectInputStream
extends ObjectInputStream {
    public RMIObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.enableResolveObject(true);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return RMIClassLoader.loadClass((String)this.getAnnotation(), objectStreamClass.getName(), VMStackWalker.firstNonNullClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(objectStreamClass.getName(), malformedURLException);
        }
    }

    protected Object getAnnotation() throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        try {
            return RMIClassLoader.loadProxyClass((String)this.getAnnotation(), stringArray, VMStackWalker.firstNonNullClassLoader());
        }
        catch (MalformedURLException malformedURLException) {
            throw new ClassNotFoundException(null, malformedURLException);
        }
    }

    protected Object readValue(Class clazz) throws IOException, ClassNotFoundException {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return this.readBoolean();
            }
            if (clazz == Byte.TYPE) {
                return new Byte(this.readByte());
            }
            if (clazz == Character.TYPE) {
                return new Character(this.readChar());
            }
            if (clazz == Short.TYPE) {
                return new Short(this.readShort());
            }
            if (clazz == Integer.TYPE) {
                return new Integer(this.readInt());
            }
            if (clazz == Long.TYPE) {
                return new Long(this.readLong());
            }
            if (clazz == Float.TYPE) {
                return new Float(this.readFloat());
            }
            if (clazz == Double.TYPE) {
                return new Double(this.readDouble());
            }
            throw new Error("Unsupported primitive class: " + clazz);
        }
        return this.readObject();
    }
}

