/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import java.util.ArrayList;
import java.util.Arrays;

class ConnectionRunnerPool {
    private static int size = 5;
    private static int max_size = 10;
    static ArrayList freelist;
    private static ThreadGroup group;

    ConnectionRunnerPool() {
    }

    public static void setSize(int n) {
        size = n;
    }

    public static void setMaxSize(int n) {
        max_size = n;
    }

    private static synchronized ConnectionRunner getConnectionRunner() {
        ConnectionRunner connectionRunner;
        if (freelist.size() == 0) {
            if (size < max_size) {
                connectionRunner = new ConnectionRunner(group, Integer.toString(++size));
                connectionRunner.start();
                freelist.add(connectionRunner);
            } else {
                while (freelist.size() == 0) {
                    try {
                        ConnectionRunnerPool.class.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        connectionRunner = (ConnectionRunner)freelist.get(0);
        freelist.remove(connectionRunner);
        return connectionRunner;
    }

    public static void dispatchConnection(UnicastConnection unicastConnection) {
        ConnectionRunner connectionRunner = ConnectionRunnerPool.getConnectionRunner();
        connectionRunner.dispatch(unicastConnection);
    }

    public static void exit() {
        Thread[] threadArray = new Thread[group.activeCount()];
        group.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            ((ConnectionRunner)threadArray[i]).exit();
        }
    }

    static {
        group = new ThreadGroup("pool");
        ConnectionRunner[] connectionRunnerArray = new ConnectionRunner[size];
        for (int i = 0; i < connectionRunnerArray.length; ++i) {
            connectionRunnerArray[i] = new ConnectionRunner(group, Integer.toString(i));
            connectionRunnerArray[i].setContextClassLoader(Thread.currentThread().getContextClassLoader());
            connectionRunnerArray[i].start();
        }
        freelist = new ArrayList<ConnectionRunner>(Arrays.asList(connectionRunnerArray));
    }

    public static class ConnectionRunner
    extends Thread {
        private UnicastConnection conn;
        private volatile boolean exiting = false;

        public ConnectionRunner(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized void run() {
            while (!this.exiting) {
                if (this.conn == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.conn.run();
                this.conn = null;
                Class<ConnectionRunnerPool> clazz = ConnectionRunnerPool.class;
                // MONITORENTER : gnu.java.rmi.server.ConnectionRunnerPool.class
                freelist.add(this);
                if (freelist.size() == 1) {
                    ConnectionRunnerPool.class.notifyAll();
                }
                // MONITOREXIT : clazz
            }
        }

        public synchronized void dispatch(UnicastConnection unicastConnection) {
            this.conn = unicastConnection;
            this.notify();
        }

        void exit() {
            this.exiting = true;
            if (this.conn != null) {
                try {
                    this.join(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.interrupt();
        }
    }
}

