/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastRef;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.rmi.server.RemoteRef;

public class ActivatableRef
extends UnicastRef {
    private static final long serialVersionUID = 1L;
    ActivationID actId;

    public ActivatableRef() {
    }

    public ActivatableRef(ObjID objID, String string, int n, RMIClientSocketFactory rMIClientSocketFactory) {
        super(objID, string, n, rMIClientSocketFactory);
    }

    public ActivatableRef(ObjID objID) {
        super(objID);
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "ActivatableRef";
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.actId = (ActivationID)objectInput.readObject();
        String string = objectInput.readUTF();
        super.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.actId);
        objectOutput.writeUTF("UnicastRef2");
        super.writeExternal(objectOutput);
    }

    protected Object invokeCommon(Remote remote, Method method, Object[] objectArray, int n, long l) throws Exception {
        UnicastConnection unicastConnection;
        try {
            unicastConnection = this.manager.getConnection();
        }
        catch (IOException iOException) {
            Remote remote2 = this.actId.activate(false);
            if (remote2 instanceof RemoteObject) {
                RemoteRef remoteRef = ((RemoteObject)remote2).getRef();
                this.manager = ((UnicastRef)remoteRef).manager;
            } else if (Proxy.isProxyClass(remote2.getClass())) {
                RemoteObjectInvocationHandler remoteObjectInvocationHandler = (RemoteObjectInvocationHandler)Proxy.getInvocationHandler(remote2);
                RemoteRef remoteRef = remoteObjectInvocationHandler.getRef();
                this.manager = ((UnicastRef)remoteRef).manager;
            } else {
                throw new ActivationException("Activating into unsupported class " + remote2.getClass());
            }
            try {
                unicastConnection = this.manager.getConnection();
            }
            catch (IOException iOException2) {
                throw new RemoteException("connection failed to host: " + this.manager.serverName, iOException);
            }
        }
        return this.invokeCommon(unicastConnection, remote, method, objectArray, n, l);
    }
}

