/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.activation;

import gnu.java.rmi.activation.BidiTable;
import gnu.java.rmi.activation.DefaultActivationSystem;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class ActivationSystemTransient
extends DefaultActivationSystem
implements ActivationSystem,
ActivationMonitor,
Activator {
    protected final BidiTable groupDescs;
    protected final BidiTable descriptions;
    protected final transient Map groupInstantiators = new Hashtable();
    protected final transient Map activatedObjects = new HashMap();
    static long groupIncarnations = 0L;
    static ActivationSystem singleton;
    public static boolean debug;

    protected ActivationSystemTransient(BidiTable bidiTable, BidiTable bidiTable2) {
        this.descriptions = bidiTable;
        this.groupDescs = bidiTable2;
    }

    protected ActivationSystemTransient() {
        this(new BidiTable(), new BidiTable());
    }

    public static ActivationSystem getInstance() {
        if (singleton == null) {
            singleton = new ActivationSystemTransient();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public MarshalledObject activate(ActivationID activationID, boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        if (!bl) {
            object3 = this.activatedObjects;
            // MONITORENTER : object3
            object2 = (MarshalledObject)this.activatedObjects.get(activationID);
            if (object2 != null) {
                // MONITOREXIT : object3
                return object2;
            }
            // MONITOREXIT : object3
        }
        if ((object3 = (ActivationDesc)this.descriptions.get(activationID)) == null) {
            String string;
            if ("Activating unknown object  " + activationID == null) {
                string = "null";
                throw new UnknownObjectException(string);
            }
            string = activationID.toString();
            throw new UnknownObjectException(string);
        }
        object2 = (ActivationInstantiator)this.groupInstantiators.get(((ActivationDesc)object3).getGroupID());
        if (object2 == null) {
            serializable = ((ActivationDesc)object3).getGroupID();
            object = (ActivationGroupDesc)this.groupDescs.get(serializable);
            if (object == null) {
                throw new UnknownGroupException("Activating unknown group " + serializable + " for " + activationID + " this " + this);
            }
            Class<ActivationSystemTransient> clazz = ActivationSystemTransient.class;
            // MONITORENTER : gnu.java.rmi.activation.ActivationSystemTransient.class
            // MONITOREXIT : clazz
            object2 = ActivationGroup.createGroup(serializable, (ActivationGroupDesc)object, ++groupIncarnations);
            this.activeGroup((ActivationGroupID)serializable, (ActivationInstantiator)object2, groupIncarnations);
        }
        serializable = object2.newInstance(activationID, (ActivationDesc)object3);
        object = this.activatedObjects;
        // MONITORENTER : object
        this.activatedObjects.put(activationID, serializable);
        // MONITOREXIT : object
        return serializable;
    }

    public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws UnknownGroupException, ActivationException, RemoteException {
        this.groupInstantiators.put(activationGroupID, activationInstantiator);
        return this;
    }

    public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        ActivationDesc activationDesc = (ActivationDesc)this.descriptions.get(activationID);
        if (activationDesc == null) {
            throw new UnknownObjectException("No desc for " + activationID == null ? "null" : activationID.toString());
        }
        return activationDesc;
    }

    public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)this.groupDescs.get(activationGroupID);
        if (activationGroupDesc == null) {
            throw new UnknownGroupException(activationGroupID == null ? "null" : activationGroupID.toString());
        }
        return activationGroupDesc;
    }

    public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
        ActivationGroupID activationGroupID = (ActivationGroupID)this.groupDescs.getKey(activationGroupDesc);
        if (activationGroupID == null) {
            activationGroupID = new ActivationGroupID(this);
            this.groupDescs.put(activationGroupID, activationGroupDesc);
        }
        if (debug) {
            System.out.println("Register group " + activationGroupID + ":" + activationGroupDesc + " this " + this);
        }
        return activationGroupID;
    }

    public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationID activationID = (ActivationID)this.descriptions.getKey(activationDesc);
        if (activationID == null) {
            activationID = new ActivationID(this);
            this.descriptions.put(activationID, activationDesc);
        }
        if (debug) {
            System.out.println("Register object " + activationID + ":" + activationDesc + " this " + this);
        }
        return activationID;
    }

    public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownObjectException, UnknownGroupException, RemoteException {
        ActivationDesc activationDesc2 = this.getActivationDesc(activationID);
        this.descriptions.put(activationID, activationDesc);
        return activationDesc2;
    }

    public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
        ActivationGroupDesc activationGroupDesc2 = this.getActivationGroupDesc(activationGroupID);
        this.groupDescs.put(activationGroupID, activationGroupDesc);
        return activationGroupDesc2;
    }

    public void shutdown() throws RemoteException {
        this.descriptions.shutdown();
        this.groupDescs.shutdown();
    }

    public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
        if (!this.groupDescs.containsKey(activationGroupID)) {
            throw new UnknownGroupException("Unknown group " + activationGroupID);
        }
        this.groupDescs.removeKey(activationGroupID);
        this.groupInstantiators.remove(activationGroupID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Unregistering unknown object");
        }
        this.descriptions.removeKey(activationID);
        Map map = this.activatedObjects;
        synchronized (map) {
            this.activatedObjects.remove(activationID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Activating unknown object " + activationID + " this " + this);
        }
        try {
            Map map = this.activatedObjects;
            synchronized (map) {
                this.activatedObjects.put(activationID, marshalledObject.get());
            }
        }
        catch (RemoteException remoteException) {
            throw remoteException;
        }
        catch (Exception exception) {
            UnknownObjectException unknownObjectException = new UnknownObjectException("Cannot get Remote for MarshalledObject of " + activationID);
            unknownObjectException.detail = exception;
            throw unknownObjectException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inactiveGroup(ActivationGroupID activationGroupID, long l) throws UnknownGroupException, RemoteException {
        if (!this.groupInstantiators.containsKey(activationGroupID)) {
            throw new UnknownGroupException("Inactivating unkwnon group");
        }
        this.groupInstantiators.remove(activationGroupID);
        Map map = this.activatedObjects;
        synchronized (map) {
            for (ActivationID activationID : this.activatedObjects.keySet()) {
                ActivationDesc activationDesc = (ActivationDesc)this.descriptions.get(activationID);
                if (!activationDesc.getGroupID().equals(activationGroupID)) continue;
                this.activatedObjects.remove(activationID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
        if (!this.descriptions.containsKey(activationID)) {
            throw new UnknownObjectException("Inactivating unknown object");
        }
        Map map = this.activatedObjects;
        synchronized (map) {
            this.activatedObjects.remove(activationID);
        }
    }

    static {
        debug = false;
    }
}

