/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ISO_8859_1;
import gnu.java.nio.charset.US_ASCII;
import gnu.java.nio.charset.UTF_16;
import gnu.java.nio.charset.UTF_16BE;
import gnu.java.nio.charset.UTF_16LE;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class UTF_8
extends Charset {
    UTF_8() {
        super("UTF-8", new String[]{"ibm-1208", "ibm-1209", "ibm-5304", "ibm-5305", "windows-65001", "cp1208", "UTF8"});
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof UTF_8 || charset instanceof UTF_16BE || charset instanceof UTF_16LE || charset instanceof UTF_16;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        Encoder(Charset charset) {
            super(charset, 1.1f, 4.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            CoderResult coderResult;
            int n;
            block23: {
                CoderResult coderResult2;
                block22: {
                    CoderResult coderResult3;
                    block21: {
                        CoderResult coderResult4;
                        block20: {
                            CoderResult coderResult5;
                            block19: {
                                CoderResult coderResult6;
                                block18: {
                                    CoderResult coderResult7;
                                    block17: {
                                        CoderResult coderResult8;
                                        block16: {
                                            n = charBuffer.position();
                                            try {
                                                while (charBuffer.hasRemaining()) {
                                                    int n2 = byteBuffer.remaining();
                                                    char c = charBuffer.get();
                                                    if (c <= '\u007f') {
                                                        if (n2 < 1) {
                                                            coderResult8 = CoderResult.OVERFLOW;
                                                            Object var9_16 = null;
                                                            break block16;
                                                        } else {
                                                            byteBuffer.put((byte)c);
                                                            ++n;
                                                            continue;
                                                        }
                                                    }
                                                    if (c <= '\u07ff') {
                                                        if (n2 < 2) {
                                                            coderResult7 = CoderResult.OVERFLOW;
                                                            break block17;
                                                        } else {
                                                            byteBuffer.put((byte)(0xC0 | c >> 6));
                                                            byteBuffer.put((byte)(0x80 | c & 0x3F));
                                                            ++n;
                                                            continue;
                                                        }
                                                    }
                                                    if ('\ud800' <= c && c <= '\udfff') {
                                                        if (n2 < 4) {
                                                            coderResult6 = CoderResult.OVERFLOW;
                                                            break block18;
                                                        }
                                                        if (c > '\udbff') {
                                                            coderResult5 = CoderResult.malformedForLength(1);
                                                            break block19;
                                                        }
                                                        if (!charBuffer.hasRemaining()) {
                                                            coderResult4 = CoderResult.UNDERFLOW;
                                                            break block20;
                                                        }
                                                        char c2 = charBuffer.get();
                                                        if (c2 < '\udc00' || c2 > '\udfff') {
                                                            coderResult3 = CoderResult.malformedForLength(1);
                                                            break block21;
                                                        } else {
                                                            int n3 = ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
                                                            byteBuffer.put((byte)(0xF0 | n3 >> 18 & 7));
                                                            byteBuffer.put((byte)(0x80 | n3 >> 12 & 0x3F));
                                                            byteBuffer.put((byte)(0x80 | n3 >> 6 & 0x3F));
                                                            byteBuffer.put((byte)(0x80 | n3 & 0x3F));
                                                            n += 2;
                                                            continue;
                                                        }
                                                    }
                                                    if (n2 < 3) {
                                                        coderResult2 = CoderResult.OVERFLOW;
                                                        break block22;
                                                    }
                                                    byteBuffer.put((byte)(0xE0 | c >> 12));
                                                    byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                                                    byteBuffer.put((byte)(0x80 | c & 0x3F));
                                                    ++n;
                                                }
                                                coderResult = CoderResult.UNDERFLOW;
                                                break block23;
                                            }
                                            catch (Throwable throwable) {
                                                Object var9_24 = null;
                                                charBuffer.position(n);
                                                throw throwable;
                                            }
                                        }
                                        charBuffer.position(n);
                                        return coderResult8;
                                    }
                                    Object var9_17 = null;
                                    charBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var9_18 = null;
                                charBuffer.position(n);
                                return coderResult6;
                            }
                            Object var9_19 = null;
                            charBuffer.position(n);
                            return coderResult5;
                        }
                        Object var9_20 = null;
                        charBuffer.position(n);
                        return coderResult4;
                    }
                    Object var9_21 = null;
                    charBuffer.position(n);
                    return coderResult3;
                }
                Object var9_22 = null;
                charBuffer.position(n);
                return coderResult2;
            }
            Object var9_23 = null;
            charBuffer.position(n);
            return coderResult;
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            CoderResult coderResult;
            int n;
            block46: {
                CoderResult coderResult2;
                block45: {
                    CoderResult coderResult3;
                    block44: {
                        CoderResult coderResult4;
                        block43: {
                            CoderResult coderResult5;
                            block42: {
                                CoderResult coderResult6;
                                block41: {
                                    CoderResult coderResult7;
                                    block40: {
                                        CoderResult coderResult8;
                                        block39: {
                                            CoderResult coderResult9;
                                            block38: {
                                                CoderResult coderResult10;
                                                block37: {
                                                    CoderResult coderResult11;
                                                    block36: {
                                                        CoderResult coderResult12;
                                                        block35: {
                                                            CoderResult coderResult13;
                                                            block34: {
                                                                CoderResult coderResult14;
                                                                block33: {
                                                                    CoderResult coderResult15;
                                                                    block32: {
                                                                        CoderResult coderResult16;
                                                                        block31: {
                                                                            CoderResult coderResult17;
                                                                            block30: {
                                                                                CoderResult coderResult18;
                                                                                block29: {
                                                                                    n = byteBuffer.position();
                                                                                    try {
                                                                                        block8: while (byteBuffer.hasRemaining()) {
                                                                                            byte by = byteBuffer.get();
                                                                                            int n2 = (by & 0xFF) >> 4 & 0xF;
                                                                                            switch (n2) {
                                                                                                case 0: 
                                                                                                case 1: 
                                                                                                case 2: 
                                                                                                case 3: 
                                                                                                case 4: 
                                                                                                case 5: 
                                                                                                case 6: 
                                                                                                case 7: {
                                                                                                    if (charBuffer.remaining() < 1) {
                                                                                                        coderResult18 = CoderResult.OVERFLOW;
                                                                                                        Object var15_30 = null;
                                                                                                        break block29;
                                                                                                    } else {
                                                                                                        charBuffer.put((char)by);
                                                                                                        ++n;
                                                                                                        continue block8;
                                                                                                    }
                                                                                                }
                                                                                                case 12: 
                                                                                                case 13: {
                                                                                                    if (byteBuffer.remaining() < 1) {
                                                                                                        coderResult17 = CoderResult.UNDERFLOW;
                                                                                                        break block30;
                                                                                                    }
                                                                                                    if (charBuffer.remaining() < 1) {
                                                                                                        coderResult16 = CoderResult.OVERFLOW;
                                                                                                        break block31;
                                                                                                    }
                                                                                                    byte by2 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by2)) {
                                                                                                        coderResult15 = CoderResult.malformedForLength(1);
                                                                                                        break block32;
                                                                                                    }
                                                                                                    char c = (char)((by & 0x1F) << 6 | by2 & 0x3F);
                                                                                                    if (c <= '\u007f') {
                                                                                                        coderResult14 = CoderResult.malformedForLength(2);
                                                                                                        break block33;
                                                                                                    } else {
                                                                                                        charBuffer.put(c);
                                                                                                        n += 2;
                                                                                                        continue block8;
                                                                                                    }
                                                                                                }
                                                                                                case 14: {
                                                                                                    if (byteBuffer.remaining() < 2) {
                                                                                                        coderResult13 = CoderResult.UNDERFLOW;
                                                                                                        break block34;
                                                                                                    }
                                                                                                    if (charBuffer.remaining() < 1) {
                                                                                                        coderResult12 = CoderResult.OVERFLOW;
                                                                                                        break block35;
                                                                                                    }
                                                                                                    byte by2 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by2)) {
                                                                                                        coderResult11 = CoderResult.malformedForLength(1);
                                                                                                        break block36;
                                                                                                    }
                                                                                                    byte by3 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by3)) {
                                                                                                        coderResult10 = CoderResult.malformedForLength(1);
                                                                                                        break block37;
                                                                                                    }
                                                                                                    char c = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
                                                                                                    if (c <= '\u07ff') {
                                                                                                        coderResult9 = CoderResult.malformedForLength(3);
                                                                                                        break block38;
                                                                                                    } else {
                                                                                                        charBuffer.put(c);
                                                                                                        n += 3;
                                                                                                        continue block8;
                                                                                                    }
                                                                                                }
                                                                                                case 15: {
                                                                                                    if (byteBuffer.remaining() < 3) {
                                                                                                        coderResult8 = CoderResult.UNDERFLOW;
                                                                                                        break block39;
                                                                                                    }
                                                                                                    if ((by & 0xF) > 4) {
                                                                                                        coderResult7 = CoderResult.malformedForLength(4);
                                                                                                        break block40;
                                                                                                    }
                                                                                                    if (charBuffer.remaining() < 2) {
                                                                                                        coderResult6 = CoderResult.OVERFLOW;
                                                                                                        break block41;
                                                                                                    }
                                                                                                    byte by2 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by2)) {
                                                                                                        coderResult5 = CoderResult.malformedForLength(3);
                                                                                                        break block42;
                                                                                                    }
                                                                                                    byte by3 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by3)) {
                                                                                                        coderResult4 = CoderResult.malformedForLength(2);
                                                                                                        break block43;
                                                                                                    }
                                                                                                    byte by4 = byteBuffer.get();
                                                                                                    if (!Decoder.isContinuation(by4)) {
                                                                                                        coderResult3 = CoderResult.malformedForLength(1);
                                                                                                        break block44;
                                                                                                    } else {
                                                                                                        int n3 = ((by & 3) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | by4 & 0x3F) - 65536;
                                                                                                        char c = (char)(0xD800 | (n3 & 0xFFC00) >> 10);
                                                                                                        char c2 = (char)(0xDC00 | n3 & 0x3FF);
                                                                                                        charBuffer.put(c);
                                                                                                        charBuffer.put(c2);
                                                                                                        n += 4;
                                                                                                        continue block8;
                                                                                                    }
                                                                                                }
                                                                                                default: {
                                                                                                    coderResult2 = CoderResult.malformedForLength(1);
                                                                                                    break;
                                                                                                }
                                                                                            }
                                                                                            break block45;
                                                                                        }
                                                                                        coderResult = CoderResult.UNDERFLOW;
                                                                                        break block46;
                                                                                    }
                                                                                    catch (Throwable throwable) {
                                                                                        Object var15_48 = null;
                                                                                        byteBuffer.position(n);
                                                                                        throw throwable;
                                                                                    }
                                                                                }
                                                                                byteBuffer.position(n);
                                                                                return coderResult18;
                                                                            }
                                                                            Object var15_31 = null;
                                                                            byteBuffer.position(n);
                                                                            return coderResult17;
                                                                        }
                                                                        Object var15_32 = null;
                                                                        byteBuffer.position(n);
                                                                        return coderResult16;
                                                                    }
                                                                    Object var15_33 = null;
                                                                    byteBuffer.position(n);
                                                                    return coderResult15;
                                                                }
                                                                Object var15_34 = null;
                                                                byteBuffer.position(n);
                                                                return coderResult14;
                                                            }
                                                            Object var15_35 = null;
                                                            byteBuffer.position(n);
                                                            return coderResult13;
                                                        }
                                                        Object var15_36 = null;
                                                        byteBuffer.position(n);
                                                        return coderResult12;
                                                    }
                                                    Object var15_37 = null;
                                                    byteBuffer.position(n);
                                                    return coderResult11;
                                                }
                                                Object var15_38 = null;
                                                byteBuffer.position(n);
                                                return coderResult10;
                                            }
                                            Object var15_39 = null;
                                            byteBuffer.position(n);
                                            return coderResult9;
                                        }
                                        Object var15_40 = null;
                                        byteBuffer.position(n);
                                        return coderResult8;
                                    }
                                    Object var15_41 = null;
                                    byteBuffer.position(n);
                                    return coderResult7;
                                }
                                Object var15_42 = null;
                                byteBuffer.position(n);
                                return coderResult6;
                            }
                            Object var15_43 = null;
                            byteBuffer.position(n);
                            return coderResult5;
                        }
                        Object var15_44 = null;
                        byteBuffer.position(n);
                        return coderResult4;
                    }
                    Object var15_45 = null;
                    byteBuffer.position(n);
                    return coderResult3;
                }
                Object var15_46 = null;
                byteBuffer.position(n);
                return coderResult2;
            }
            Object var15_47 = null;
            byteBuffer.position(n);
            return coderResult;
        }

        private static boolean isContinuation(byte by) {
            return (by & 0xC0) == 128;
        }
    }
}

