/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.ByteDecodeLoopHelper;
import gnu.java.nio.charset.ByteEncodeLoopHelper;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class US_ASCII
extends Charset {
    US_ASCII() {
        super("US-ASCII", new String[]{"iso-ir-6", "ANSI_X3.4-1986", "ISO_646.irv:1991", "ASCII", "ISO646-US", "ASCII", "us", "IBM367", "cp367", "csASCII", "ANSI_X3.4-1968", "iso_646.irv:1983", "ascii7", "646", "windows-20127"});
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Encoder
    extends CharsetEncoder {
        private static final ByteEncodeLoopHelper helper = new ByteEncodeLoopHelper(){

            protected boolean isMappable(char c) {
                return c <= '\u007f';
            }

            protected byte mapToByte(char c) {
                return (byte)c;
            }
        };

        Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c <= '\u007f';
        }

        public boolean canEncode(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                if (this.canEncode(charSequence.charAt(i))) continue;
                return false;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            return helper.encodeLoop(charBuffer, byteBuffer);
        }
    }

    private static final class Decoder
    extends CharsetDecoder {
        private static final ByteDecodeLoopHelper helper = new ByteDecodeLoopHelper(){

            protected boolean isMappable(byte by) {
                return by >= 0;
            }

            protected char mapToChar(byte by) {
                return (char)by;
            }
        };

        Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            return helper.decodeLoop(byteBuffer, charBuffer);
        }
    }
}

