/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public abstract class ByteEncodeLoopHelper {
    protected abstract boolean isMappable(char var1);

    protected abstract byte mapToByte(char var1);

    CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.arrayEncodeLoop(charBuffer, byteBuffer);
        }
        return this.normalEncodeLoop(charBuffer, byteBuffer);
    }

    private CoderResult normalEncodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.remaining();
        for (n = charBuffer.remaining(); n > 0 && n2 > 0; --n, --n2) {
            char c = charBuffer.get();
            if (!this.isMappable(c)) {
                charBuffer.position(charBuffer.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            byte by = this.mapToByte(c);
            byteBuffer.put(by);
        }
        if (n > 0) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult arrayEncodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block6: {
            int n3;
            char[] cArray = charBuffer.array();
            byte[] byArray = byteBuffer.array();
            n2 = charBuffer.arrayOffset() + charBuffer.position();
            n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = charBuffer.remaining();
            if (n4 <= (n3 = byteBuffer.remaining())) {
                for (int i = 0; i < n4; ++i) {
                    byte by;
                    char c = cArray[n2];
                    ++n2;
                    if (!this.isMappable(c)) {
                        --n2;
                        coderResult = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    byArray[n] = by = this.mapToByte(c);
                    ++n;
                }
                coderResult = CoderResult.UNDERFLOW;
            } else {
                for (int i = 0; i < n3; ++i) {
                    byte by;
                    char c = cArray[n2];
                    ++n2;
                    if (!this.isMappable(c)) {
                        --n2;
                        coderResult = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    byArray[n] = by = this.mapToByte(c);
                    ++n;
                }
                coderResult = CoderResult.OVERFLOW;
            }
        }
        charBuffer.position(n2 - charBuffer.arrayOffset());
        byteBuffer.position(n - byteBuffer.arrayOffset());
        return coderResult;
    }
}

