/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public abstract class ByteDecodeLoopHelper {
    protected abstract boolean isMappable(byte var1);

    protected abstract char mapToChar(byte var1);

    CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            return this.arrayDecodeLoop(byteBuffer, charBuffer);
        }
        return this.normalDecodeLoop(byteBuffer, charBuffer);
    }

    private CoderResult normalDecodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n;
        int n2 = charBuffer.remaining();
        for (n = byteBuffer.remaining(); n > 0 && n2 > 0; --n, --n2) {
            byte by = byteBuffer.get();
            if (!this.isMappable(by)) {
                byteBuffer.position(byteBuffer.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            char c = this.mapToChar(by);
            charBuffer.put(c);
        }
        if (n > 0) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult arrayDecodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult;
        int n;
        int n2;
        block6: {
            int n3;
            byte[] byArray = byteBuffer.array();
            char[] cArray = charBuffer.array();
            n2 = byteBuffer.arrayOffset() + byteBuffer.position();
            n = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = byteBuffer.remaining();
            if (n4 <= (n3 = charBuffer.remaining())) {
                for (int i = 0; i < n4; ++i) {
                    char c;
                    byte by = byArray[n2];
                    ++n2;
                    if (!this.isMappable(by)) {
                        --n2;
                        coderResult = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    cArray[n] = c = this.mapToChar(by);
                    ++n;
                }
                coderResult = CoderResult.UNDERFLOW;
            } else {
                for (int i = 0; i < n3; ++i) {
                    char c;
                    byte by = byArray[n2];
                    ++n2;
                    if (!this.isMappable(by)) {
                        --n2;
                        coderResult = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    cArray[n] = c = this.mapToChar(by);
                    ++n;
                }
                coderResult = CoderResult.OVERFLOW;
            }
        }
        byteBuffer.position(n2 - byteBuffer.arrayOffset());
        charBuffer.position(n - charBuffer.arrayOffset());
        return coderResult;
    }
}

