/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public final class VMChannel {
    private final State nfd = new State();
    private Kind kind = Kind.OTHER;

    public VMChannel() {
    }

    VMChannel(int n) throws IOException {
        this();
        this.nfd.setNativeFD(n);
    }

    public State getState() {
        return this.nfd;
    }

    public static VMChannel getStdin() throws IOException {
        return new VMChannel(VMChannel.stdin_fd());
    }

    public static VMChannel getStdout() throws IOException {
        return new VMChannel(VMChannel.stdout_fd());
    }

    public static VMChannel getStderr() throws IOException {
        return new VMChannel(VMChannel.stderr_fd());
    }

    private static native int stdin_fd();

    private static native int stdout_fd();

    private static native int stderr_fd();

    public void setBlocking(boolean bl) throws IOException {
        VMChannel.setBlocking(this.nfd.getNativeFD(), bl);
    }

    private static native void setBlocking(int var0, boolean var1) throws IOException;

    public int available() throws IOException {
        return VMChannel.available(this.nfd.getNativeFD());
    }

    private static native int available(int var0) throws IOException;

    public int read(ByteBuffer byteBuffer) throws IOException {
        return VMChannel.read(this.nfd.getNativeFD(), byteBuffer);
    }

    private static native int read(int var0, ByteBuffer var1) throws IOException;

    public int read() throws IOException {
        return VMChannel.read(this.nfd.getNativeFD());
    }

    private static native int read(int var0) throws IOException;

    public long readScattering(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset + length > dsts.length");
        }
        return VMChannel.readScattering(this.nfd.getNativeFD(), byteBufferArray, n, n2);
    }

    private static native long readScattering(int var0, ByteBuffer[] var1, int var2, int var3) throws IOException;

    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (this.kind != Kind.SOCK_DGRAM) {
            throw new SocketException("not a datagram socket");
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(18);
        int n = VMChannel.receive(this.nfd.getNativeFD(), byteBuffer, byteBuffer2);
        if (n == 0) {
            return null;
        }
        if (n == 4) {
            byte[] byArray = new byte[4];
            byteBuffer2.get(byArray);
            int n2 = byteBuffer2.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet4Address.getByAddress(byArray), n2);
        }
        if (n == 16) {
            byte[] byArray = new byte[16];
            byteBuffer2.get(byArray);
            int n3 = byteBuffer2.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet6Address.getByAddress(byArray), n3);
        }
        throw new SocketException("host address received with invalid length: " + n);
    }

    private static native int receive(int var0, ByteBuffer var1, ByteBuffer var2) throws IOException;

    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.write(this.nfd.getNativeFD(), byteBuffer);
    }

    private native int write(int var1, ByteBuffer var2) throws IOException;

    public long writeGathering(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        if (n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset + length > srcs.length");
        }
        while (!byteBufferArray[n].hasRemaining() && n < byteBufferArray.length) {
            ++n;
        }
        if (n == byteBufferArray.length) {
            return 0L;
        }
        if (n2 > byteBufferArray.length - n) {
            n2 = byteBufferArray.length - n;
        }
        return this.writeGathering(this.nfd.getNativeFD(), byteBufferArray, n, n2);
    }

    private native long writeGathering(int var1, ByteBuffer[] var2, int var3, int var4) throws IOException;

    public int send(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) throws IOException {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            throw new NullPointerException();
        }
        if (inetAddress instanceof Inet4Address) {
            return VMChannel.send(this.nfd.getNativeFD(), byteBuffer, inetAddress.getAddress(), inetSocketAddress.getPort());
        }
        if (inetAddress instanceof Inet6Address) {
            return VMChannel.send6(this.nfd.getNativeFD(), byteBuffer, inetAddress.getAddress(), inetSocketAddress.getPort());
        }
        throw new SocketException("unrecognized inet address type");
    }

    private static native int send(int var0, ByteBuffer var1, byte[] var2, int var3) throws IOException;

    private static native int send6(int var0, ByteBuffer var1, byte[] var2, int var3) throws IOException;

    public void write(int n) throws IOException {
        VMChannel.write(this.nfd.getNativeFD(), n);
    }

    private static native void write(int var0, int var1) throws IOException;

    private static native void initIDs();

    public void initSocket(boolean bl) throws IOException {
        if (this.nfd.isValid()) {
            throw new IOException("native FD already initialized");
        }
        this.kind = bl ? Kind.SOCK_STREAM : Kind.SOCK_DGRAM;
        this.nfd.setNativeFD(VMChannel.socket(bl));
    }

    private static native int socket(boolean var0) throws IOException;

    public boolean connect(InetSocketAddress inetSocketAddress, int n) throws SocketException {
        int n2;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        try {
            n2 = this.nfd.getNativeFD();
        }
        catch (IOException iOException) {
            throw new SocketException(iOException.getMessage());
        }
        if (inetAddress instanceof Inet4Address) {
            return VMChannel.connect(n2, inetAddress.getAddress(), inetSocketAddress.getPort(), n);
        }
        if (inetAddress instanceof Inet6Address) {
            return VMChannel.connect6(n2, inetAddress.getAddress(), inetSocketAddress.getPort(), n);
        }
        throw new SocketException("unsupported internet address");
    }

    private static native boolean connect(int var0, byte[] var1, int var2, int var3) throws SocketException;

    private static native boolean connect6(int var0, byte[] var1, int var2, int var3) throws SocketException;

    public void disconnect() throws IOException {
        if (this.kind != Kind.SOCK_DGRAM) {
            throw new IOException("can only disconnect datagram channels");
        }
        VMChannel.disconnect(this.nfd.getNativeFD());
    }

    private static native void disconnect(int var0) throws IOException;

    public InetSocketAddress getLocalAddress() throws IOException {
        if (!this.nfd.isValid()) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(18);
        int n = VMChannel.getsockname(this.nfd.getNativeFD(), byteBuffer);
        if (n == 0) {
            return null;
        }
        if (n == 4) {
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            int n2 = byteBuffer.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet4Address.getByAddress(byArray), n2);
        }
        if (n == 16) {
            byte[] byArray = new byte[16];
            byteBuffer.get(byArray);
            int n3 = byteBuffer.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet6Address.getByAddress(byArray), n3);
        }
        throw new SocketException("invalid address length");
    }

    private static native int getsockname(int var0, ByteBuffer var1) throws IOException;

    public InetSocketAddress getPeerAddress() throws IOException {
        if (!this.nfd.isValid()) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(18);
        int n = VMChannel.getpeername(this.nfd.getNativeFD(), byteBuffer);
        if (n == 0) {
            return null;
        }
        if (n == 4) {
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            int n2 = byteBuffer.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet4Address.getByAddress(byArray), n2);
        }
        if (n == 16) {
            byte[] byArray = new byte[16];
            byteBuffer.get(byArray);
            int n3 = byteBuffer.getShort() & 0xFFFF;
            return new InetSocketAddress(Inet6Address.getByAddress(byArray), n3);
        }
        throw new SocketException("invalid address length");
    }

    private static native int getpeername(int var0, ByteBuffer var1) throws IOException;

    public VMChannel accept() throws IOException {
        int n = VMChannel.accept(this.nfd.getNativeFD());
        if (n == -1) {
            return null;
        }
        return new VMChannel(n);
    }

    private static native int accept(int var0) throws IOException;

    public void openFile(String string, int n) throws IOException {
        if (this.nfd.isValid() || this.nfd.isClosed()) {
            throw new IOException("can't reinitialize this channel");
        }
        int n2 = VMChannel.open(string, n);
        this.nfd.setNativeFD(n2);
        this.kind = Kind.FILE;
    }

    private static native int open(String var0, int var1) throws IOException;

    public long position() throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        return VMChannel.position(this.nfd.getNativeFD());
    }

    private static native long position(int var0) throws IOException;

    public void seek(long l) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        VMChannel.seek(this.nfd.getNativeFD(), l);
    }

    private static native void seek(int var0, long var1) throws IOException;

    public void truncate(long l) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        VMChannel.truncate(this.nfd.getNativeFD(), l);
    }

    private static native void truncate(int var0, long var1) throws IOException;

    public boolean lock(long l, long l2, boolean bl, boolean bl2) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        return VMChannel.lock(this.nfd.getNativeFD(), l, l2, bl, bl2);
    }

    private static native boolean lock(int var0, long var1, long var3, boolean var5, boolean var6) throws IOException;

    public void unlock(long l, long l2) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        VMChannel.unlock(this.nfd.getNativeFD(), l, l2);
    }

    private static native void unlock(int var0, long var1, long var3) throws IOException;

    public long size() throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        return VMChannel.size(this.nfd.getNativeFD());
    }

    private static native long size(int var0) throws IOException;

    public MappedByteBuffer map(char c, long l, int n) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        return VMChannel.map(this.nfd.getNativeFD(), c, l, n);
    }

    private static native MappedByteBuffer map(int var0, char var1, long var2, int var4) throws IOException;

    public boolean flush(boolean bl) throws IOException {
        if (this.kind != Kind.FILE) {
            throw new IOException("not a file");
        }
        return VMChannel.flush(this.nfd.getNativeFD(), bl);
    }

    private static native boolean flush(int var0, boolean var1) throws IOException;

    public void close() throws IOException {
        this.nfd.close();
    }

    static native void close(int var0) throws IOException;

    static boolean isThreadInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    static {
        System.loadLibrary("javanio");
        VMChannel.initIDs();
    }

    static class Kind {
        static final Kind SOCK_STREAM = new Kind();
        static final Kind SOCK_DGRAM = new Kind();
        static final Kind FILE = new Kind();
        static final Kind OTHER = new Kind();

        private Kind() {
        }
    }

    public final class State {
        private int native_fd = -1;
        private boolean valid = false;
        private boolean closed = false;

        State() {
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public int getNativeFD() throws IOException {
            if (!this.valid) {
                throw new IOException("invalid file descriptor");
            }
            return this.native_fd;
        }

        void setNativeFD(int n) throws IOException {
            if (this.valid) {
                throw new IOException("file descriptor already initialized");
            }
            this.native_fd = n;
            this.valid = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.valid) {
                throw new IOException("invalid file descriptor");
            }
            try {
                VMChannel.close(this.native_fd);
                Object var2_1 = null;
                this.valid = false;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.valid = false;
                this.closed = true;
                throw throwable;
            }
        }

        public String toString() {
            if (this.closed) {
                return "<<closed>>";
            }
            if (!this.valid) {
                return "<<invalid>>";
            }
            return String.valueOf(this.native_fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.valid) {
                    this.close();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }
    }
}

