/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.classpath.SystemProperties;
import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.EpollSelectorImpl;
import gnu.java.nio.KqueueSelectorImpl;
import gnu.java.nio.PipeImpl;
import gnu.java.nio.SelectorImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.SocketChannelImpl;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;

public class SelectorProviderImpl
extends SelectorProvider {
    private static final String SELECTOR_IMPL_KQUEUE = "kqueue";
    private static final String SELECTOR_IMPL_EPOLL = "epoll";
    private static final String SELECTOR_IMPL = "gnu.java.nio.selectorImpl";
    private static boolean epoll_failed = false;

    public DatagramChannel openDatagramChannel() throws IOException {
        return new DatagramChannelImpl(this);
    }

    public Pipe openPipe() throws IOException {
        return new PipeImpl(this);
    }

    public AbstractSelector openSelector() throws IOException {
        String string = "default";
        if (KqueueSelectorImpl.kqueue_supported()) {
            string = SELECTOR_IMPL_KQUEUE;
        }
        if (EpollSelectorImpl.epoll_supported() && !epoll_failed) {
            string = SELECTOR_IMPL_EPOLL;
        }
        if ((string = SystemProperties.getProperty(SELECTOR_IMPL, string)).equals(SELECTOR_IMPL_KQUEUE)) {
            return new KqueueSelectorImpl(this);
        }
        if (string.equals(SELECTOR_IMPL_EPOLL)) {
            try {
                return new EpollSelectorImpl(this);
            }
            catch (InternalError internalError) {
                epoll_failed = true;
            }
        }
        return new SelectorImpl(this);
    }

    public ServerSocketChannel openServerSocketChannel() throws IOException {
        return new ServerSocketChannelImpl(this);
    }

    public SocketChannel openSocketChannel() throws IOException {
        return new SocketChannelImpl(this);
    }
}

