/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.DatagramChannelImpl;
import gnu.java.nio.DatagramChannelSelectionKey;
import gnu.java.nio.SelectionKeyImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import gnu.java.nio.ServerSocketChannelSelectionKey;
import gnu.java.nio.SocketChannelImpl;
import gnu.java.nio.SocketChannelSelectionKey;
import gnu.java.nio.SocketChannelSelectionKeyImpl;
import gnu.java.nio.VMSelector;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorImpl
extends AbstractSelector {
    private Set<SelectionKey> keys;
    private Set<SelectionKey> selected;
    private Object selectThreadMutex = new Object();
    private Thread selectThread;
    private boolean unhandledWakeup;

    public SelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        this.keys = new HashSet<SelectionKey>();
        this.selected = new HashSet<SelectionKey>();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void implCloseSelector() throws IOException {
        this.wakeup();
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            Set<SelectionKey> set2 = this.selected;
            synchronized (set2) {
                Set<SelectionKey> set3 = this.cancelledKeys();
                synchronized (set3) {
                }
            }
        }
    }

    @Override
    public final Set<SelectionKey> keys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return Collections.unmodifiableSet(this.keys);
    }

    @Override
    public final int selectNow() throws IOException {
        return this.select(1L);
    }

    @Override
    public final int select() throws IOException {
        return this.select(0L);
    }

    private final int[] getFDsAsArray(int n) {
        int n2 = 0;
        for (SelectionKeyImpl selectionKeyImpl : this.keys) {
            if ((selectionKeyImpl.interestOps() & n) == 0) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        for (SelectionKeyImpl selectionKeyImpl : this.keys) {
            if ((selectionKeyImpl.interestOps() & n) == 0) continue;
            nArray[n2] = selectionKeyImpl.getNativeFD();
            ++n2;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int select(long l) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            Set<SelectionKey> set2 = this.selected;
            synchronized (set2) {
                SelectionKeyImpl selectionKeyImpl;
                this.deregisterCancelledKeys();
                int[] nArray = this.getFDsAsArray(17);
                int[] nArray2 = this.getFDsAsArray(12);
                int[] nArray3 = new int[]{};
                Object object = this.selectThreadMutex;
                synchronized (object) {
                    if (this.unhandledWakeup) {
                        this.unhandledWakeup = false;
                        return 0;
                    }
                    this.selectThread = Thread.currentThread();
                }
                int n = 0;
                try {
                    this.begin();
                    n = VMSelector.select(nArray, nArray2, nArray3, l);
                    selectionKeyImpl = null;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    this.end();
                    throw throwable;
                }
                this.end();
                Iterator<SelectionKey> iterator = this.selectThreadMutex;
                synchronized (iterator) {
                    if (this.unhandledWakeup) {
                        this.unhandledWakeup = false;
                        Thread.interrupted();
                    }
                    this.selectThread = null;
                }
                iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    int n2;
                    int n3 = 0;
                    selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    if (this.selected.contains(selectionKeyImpl)) {
                        n3 = selectionKeyImpl.readyOps();
                    }
                    for (n2 = 0; n2 < nArray.length; ++n2) {
                        if (selectionKeyImpl.getNativeFD() != nArray[n2]) continue;
                        if (selectionKeyImpl.channel() instanceof ServerSocketChannelImpl) {
                            n3 |= 0x10;
                            continue;
                        }
                        n3 |= 1;
                    }
                    for (n2 = 0; n2 < nArray2.length; ++n2) {
                        if (selectionKeyImpl.getNativeFD() != nArray2[n2]) continue;
                        if (selectionKeyImpl.channel() instanceof SocketChannel) {
                            if (((SocketChannel)selectionKeyImpl.channel()).isConnected()) {
                                n3 |= 4;
                                continue;
                            }
                            n3 |= 8;
                            continue;
                        }
                        n3 |= 4;
                    }
                    if (!this.selected.contains(selectionKeyImpl)) {
                        this.selected.add(selectionKeyImpl);
                    }
                    selectionKeyImpl.readyOps(selectionKeyImpl.interestOps() & n3);
                }
                this.deregisterCancelledKeys();
                return n;
            }
        }
    }

    @Override
    public final Set<SelectionKey> selectedKeys() {
        if (!this.isOpen()) {
            throw new ClosedSelectorException();
        }
        return this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Selector wakeup() {
        Object object = this.selectThreadMutex;
        synchronized (object) {
            this.unhandledWakeup = true;
            if (this.selectThread != null) {
                this.selectThread.interrupt();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deregisterCancelledKeys() {
        Set<SelectionKey> set;
        Set<SelectionKey> set2 = set = this.cancelledKeys();
        synchronized (set2) {
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.keys.remove((SelectionKeyImpl)iterator.next());
                iterator.remove();
            }
        }
    }

    protected SelectionKey register(SelectableChannel selectableChannel, int n, Object object) {
        return this.register((AbstractSelectableChannel)selectableChannel, n, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final SelectionKey register(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
        SelectionKeyImpl selectionKeyImpl;
        if (abstractSelectableChannel instanceof SocketChannelImpl) {
            selectionKeyImpl = new SocketChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof DatagramChannelImpl) {
            selectionKeyImpl = new DatagramChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof ServerSocketChannelImpl) {
            selectionKeyImpl = new ServerSocketChannelSelectionKey(abstractSelectableChannel, this);
        } else if (abstractSelectableChannel instanceof SocketChannelImpl) {
            selectionKeyImpl = new SocketChannelSelectionKeyImpl((SocketChannelImpl)abstractSelectableChannel, this);
        } else {
            throw new InternalError("No known channel type");
        }
        Set<SelectionKey> set = this.keys;
        synchronized (set) {
            this.keys.add(selectionKeyImpl);
            selectionKeyImpl.interestOps(n);
            selectionKeyImpl.attach(object);
        }
        return selectionKeyImpl;
    }
}

