/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainSocketImpl;
import gnu.java.nio.ServerSocketChannelImpl;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public final class NIOServerSocket
extends ServerSocket {
    private ServerSocketChannelImpl channel;

    protected NIOServerSocket(ServerSocketChannelImpl serverSocketChannelImpl) throws IOException {
        this.channel = serverSocketChannelImpl;
    }

    public PlainSocketImpl getPlainSocketImpl() {
        try {
            final NIOServerSocket nIOServerSocket = this;
            final Method method = ServerSocket.class.getDeclaredMethod("getImpl", new Class[0]);
            method.setAccessible(true);
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return method.invoke(nIOServerSocket, new Object[0]);
                }
            };
            return (PlainSocketImpl)AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("unable to invoke method ServerSocket.getImpl()");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public ServerSocketChannel getChannel() {
        return this.channel;
    }

    public Socket accept() throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(this.getLocalPort());
        }
        SocketChannel socketChannel = this.channel.provider().openSocketChannel();
        this.implAccept(socketChannel.socket());
        return socketChannel.socket();
    }
}

