/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.FileLockImpl;
import gnu.java.nio.VMChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public final class FileChannelImpl
extends FileChannel {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int APPEND = 4;
    public static final int EXCL = 8;
    public static final int SYNC = 16;
    public static final int DSYNC = 32;
    public static final FileChannelImpl in;
    public static final FileChannelImpl out;
    public static final FileChannelImpl err;
    private VMChannel ch;
    private int mode;
    final String description;

    public static FileChannelImpl create(File file, int n) throws IOException {
        return new FileChannelImpl(file, n);
    }

    private FileChannelImpl(File file, int n) throws IOException {
        String string;
        this.description = string = file.getPath();
        this.mode = n;
        this.ch = new VMChannel();
        this.ch.openFile(string, n);
        if (file.isDirectory()) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FileNotFoundException(this.description + " is a directory");
        }
    }

    FileChannelImpl(VMChannel vMChannel, int n) {
        this.mode = n;
        this.description = "descriptor(" + vMChannel.getState() + ")";
        this.ch = vMChannel;
    }

    public int available() throws IOException {
        return this.ch.available();
    }

    private long implPosition() throws IOException {
        return this.ch.position();
    }

    private void seek(long l) throws IOException {
        this.ch.seek(l);
    }

    private void implTruncate(long l) throws IOException {
        this.ch.truncate(l);
    }

    public void unlock(long l, long l2) throws IOException {
        this.ch.unlock(l, l2);
    }

    public long size() throws IOException {
        return this.ch.size();
    }

    protected void implCloseChannel() throws IOException {
        this.ch.close();
    }

    protected void finalize() throws IOException {
        if (this.ch.getState().isValid()) {
            this.close();
        }
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.ch.read(byteBuffer);
    }

    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("position: " + l);
        }
        long l2 = this.implPosition();
        this.position(l);
        int n = this.read(byteBuffer);
        this.position(l2);
        return n;
    }

    public int read() throws IOException {
        return this.ch.read();
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.ch.readScattering(byteBufferArray, n, n2);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.ch.write(byteBuffer);
    }

    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("position: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long l2 = this.implPosition();
        this.seek(l);
        int n = this.write(byteBuffer);
        this.seek(l2);
        return n;
    }

    public void write(int n) throws IOException {
        this.ch.write(n);
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.ch.writeGathering(byteBufferArray, n, n2);
    }

    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l, long l2) throws IOException {
        char c = '\u0000';
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            c = 'r';
            if ((this.mode & 1) == 0) {
                throw new NonReadableChannelException();
            }
        } else if (mapMode == FileChannel.MapMode.READ_WRITE || mapMode == FileChannel.MapMode.PRIVATE) {
            char c2 = c = mapMode == FileChannel.MapMode.READ_WRITE ? (char)'+' : 'c';
            if ((this.mode & 2) != 2) {
                throw new NonWritableChannelException();
            }
            if ((this.mode & 1) != 1) {
                throw new NonReadableChannelException();
            }
        } else {
            throw new IllegalArgumentException("mode: " + mapMode);
        }
        if (l < 0L || l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position: " + l + ", size: " + l2);
        }
        return this.ch.map(c, l, (int)l2);
    }

    public void force(boolean bl) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.ch.flush(bl);
    }

    private int smallTransferTo(long l, int n, WritableByteChannel writableByteChannel) throws IOException {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = this.map(FileChannel.MapMode.READ_ONLY, l, n);
        }
        catch (IOException iOException) {
            byteBuffer = ByteBuffer.allocate(n);
            this.read(byteBuffer, l);
            byteBuffer.flip();
        }
        return writableByteChannel.write(byteBuffer);
    }

    public long transferTo(long l, long l2, WritableByteChannel writableByteChannel) throws IOException {
        int n;
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", count: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        long l3 = 0L;
        while (l2 > 0L && (n = this.smallTransferTo(l, (int)Math.min(l2, 65536L), writableByteChannel)) >= 0) {
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    private int smallTransferFrom(ReadableByteChannel readableByteChannel, long l, int n) throws IOException {
        ByteBuffer byteBuffer = null;
        if (readableByteChannel instanceof FileChannel) {
            try {
                byteBuffer = ((FileChannel)readableByteChannel).map(FileChannel.MapMode.READ_ONLY, l, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(n);
            readableByteChannel.read(byteBuffer);
            byteBuffer.flip();
        }
        return this.write(byteBuffer, l);
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l, long l2) throws IOException {
        int n;
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", count: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        long l3 = 0L;
        while (l2 > 0L && (n = this.smallTransferFrom(readableByteChannel, l, (int)Math.min(l2, 65536L))) >= 0) {
            l3 += (long)n;
            l += (long)n;
            l2 -= (long)n;
        }
        return l3;
    }

    private void lockCheck(long l, long l2, boolean bl) throws IOException {
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("position: " + l + ", size: " + l2);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (bl && (this.mode & 1) == 0) {
            throw new NonReadableChannelException();
        }
        if (!bl && (this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(l, l2, bl);
        boolean bl2 = false;
        try {
            this.begin();
            boolean bl3 = this.ch.lock(l, l2, bl, false);
            bl2 = true;
            fileLockImpl = bl3 ? new FileLockImpl(this, l, l2, bl) : null;
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.end(bl2);
            throw throwable;
        }
        this.end(bl2);
        return fileLockImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLock lock(long l, long l2, boolean bl) throws IOException {
        FileLockImpl fileLockImpl;
        this.lockCheck(l, l2, bl);
        boolean bl2 = false;
        try {
            boolean bl3 = this.ch.lock(l, l2, bl, true);
            bl2 = true;
            fileLockImpl = bl3 ? new FileLockImpl(this, l, l2, bl) : null;
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.end(bl2);
            throw throwable;
        }
        this.end(bl2);
        return fileLockImpl;
    }

    public long position() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.implPosition();
    }

    public FileChannel position(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("newPosition: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.seek(l);
        return this;
    }

    public FileChannel truncate(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("size: " + l);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if ((this.mode & 2) == 0) {
            throw new NonWritableChannelException();
        }
        if (l < this.size()) {
            this.implTruncate(l);
        }
        return this;
    }

    public String toString() {
        return super.toString() + "[ fd: " + this.ch.getState() + "; mode: " + Integer.toOctalString(this.mode) + "; " + this.description + " ]";
    }

    static {
        System.loadLibrary("javanio");
        FileChannelImpl fileChannelImpl = null;
        try {
            fileChannelImpl = new FileChannelImpl(VMChannel.getStdin(), 1);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        in = fileChannelImpl;
        fileChannelImpl = null;
        try {
            fileChannelImpl = new FileChannelImpl(VMChannel.getStdout(), 2);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        out = fileChannelImpl;
        fileChannelImpl = null;
        try {
            fileChannelImpl = new FileChannelImpl(VMChannel.getStderr(), 2);
        }
        catch (IOException iOException) {
            throw new Error(iOException);
        }
        err = fileChannelImpl;
    }
}

