/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.lang.CPStringBuilder;
import gnu.java.net.protocol.http.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public class ChunkedInputStream
extends InputStream {
    Headers headers;
    private InputStream in;
    int size;
    int count;
    boolean meta;
    boolean eof;

    public ChunkedInputStream(InputStream inputStream, Headers headers) {
        this.in = inputStream;
        this.headers = headers;
        this.size = -1;
        this.count = 0;
        this.meta = true;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return 0xFF & byArray[0];
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        if (this.eof) {
            return -1;
        }
        if (this.meta) {
            n5 = 0;
            n4 = 0;
            CPStringBuilder cPStringBuilder = new CPStringBuilder();
            do {
                if ((n3 = this.in.read()) == 59) {
                    n4 = 1;
                } else {
                    if (n3 == 10 && n5 == 13) {
                        try {
                            this.size = Integer.parseInt(cPStringBuilder.toString(), 16);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            IOException iOException = new IOException("Bad chunk header");
                            iOException.initCause(numberFormatException);
                            this.in.close();
                            throw iOException;
                        }
                    }
                    if (n4 == 0 && n3 >= 48) {
                        cPStringBuilder.append((char)n3);
                    }
                }
                n5 = n3;
            } while (n3 != -1);
            this.count = 0;
            this.meta = false;
        }
        if (this.size == 0) {
            this.headers.parse(this.in);
            this.eof = true;
            return -1;
        }
        n3 = Math.min(this.size - this.count, n2);
        n5 = this.in.read(byArray, n, n3);
        if (n5 == -1) {
            this.eof = true;
            return -1;
        }
        this.count += n5;
        if (this.count == this.size) {
            n4 = this.in.read();
            int n6 = this.in.read();
            if (n4 == -1 || n6 == -1) {
                this.eof = true;
                return -1;
            }
            if (n4 != 13 || n6 != 10) {
                throw new ProtocolException("expecting CRLF: " + n4 + "," + n6);
            }
            this.meta = true;
        }
        return n5;
    }

    public int available() throws IOException {
        if (this.meta) {
            return 0;
        }
        return Math.min(this.in.available(), this.size - this.count);
    }

    public void close() throws IOException {
        this.in.close();
    }
}

