/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net;

import gnu.java.nio.VMChannel;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;

public final class VMPlainSocketImpl {
    private static final int CP_IP_TTL = 7777;
    private final State nfd = new State();

    public VMPlainSocketImpl() {
    }

    public VMPlainSocketImpl(VMChannel vMChannel) throws IOException {
        this();
        this.nfd.setChannelFD(vMChannel.getState());
    }

    public State getState() {
        return this.nfd;
    }

    public void setTimeToLive(int n) throws SocketException {
        try {
            VMPlainSocketImpl.setOption(this.nfd.getNativeFD(), 7777, n);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    public int getTimeToLive() throws SocketException {
        try {
            return VMPlainSocketImpl.getOption(this.nfd.getNativeFD(), 7777);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    public void setOption(int n, Object object) throws SocketException {
        int n2;
        if (object instanceof Integer) {
            n2 = (Integer)object;
        } else if (object instanceof Boolean) {
            n2 = (Boolean)object != false ? 1 : (n == 128 ? -1 : 0);
        } else {
            throw new IllegalArgumentException("option value type " + object.getClass().getName());
        }
        try {
            VMPlainSocketImpl.setOption(this.nfd.getNativeFD(), n, n2);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    private static native void setOption(int var0, int var1, int var2) throws SocketException;

    public void setMulticastInterface(int n, InetAddress inetAddress) throws SocketException {
        block5: {
            try {
                if (inetAddress instanceof Inet4Address) {
                    VMPlainSocketImpl.setMulticastInterface(this.nfd.getNativeFD(), n, (Inet4Address)inetAddress);
                    break block5;
                }
                if (inetAddress instanceof Inet6Address) {
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
                    VMPlainSocketImpl.setMulticastInterface6(this.nfd.getNativeFD(), n, networkInterface.getName());
                    break block5;
                }
                throw new SocketException("Unknown address format: " + inetAddress);
            }
            catch (SocketException socketException) {
                throw socketException;
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
        }
    }

    private static native void setMulticastInterface(int var0, int var1, Inet4Address var2);

    private static native void setMulticastInterface6(int var0, int var1, String var2);

    public Object getOption(int n) throws SocketException {
        int n2;
        try {
            n2 = VMPlainSocketImpl.getOption(this.nfd.getNativeFD(), n);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        switch (n) {
            case 1: 
            case 4: 
            case 8: 
            case 18: 
            case 32: 
            case 4099: {
                return n2 != 0;
            }
            case 3: 
            case 128: 
            case 4097: 
            case 4098: 
            case 4102: {
                return new Integer(n2);
            }
        }
        throw new SocketException("getting option " + n + " not supported here");
    }

    private static native int getOption(int var0, int var1) throws SocketException;

    public InetAddress getMulticastInterface(int n) throws SocketException {
        try {
            return VMPlainSocketImpl.getMulticastInterface(this.nfd.getNativeFD(), n);
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    private static native InetAddress getMulticastInterface(int var0, int var1);

    public void bind(InetSocketAddress inetSocketAddress) throws IOException {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            VMPlainSocketImpl.bind(this.nfd.getNativeFD(), inetAddress.getAddress(), inetSocketAddress.getPort());
        } else if (inetAddress instanceof Inet6Address) {
            VMPlainSocketImpl.bind6(this.nfd.getNativeFD(), inetAddress.getAddress(), inetSocketAddress.getPort());
        } else {
            throw new SocketException("unsupported address type");
        }
    }

    private static native void bind(int var0, byte[] var1, int var2) throws IOException;

    private static native void bind6(int var0, byte[] var1, int var2) throws IOException;

    public void listen(int n) throws IOException {
        VMPlainSocketImpl.listen(this.nfd.getNativeFD(), n);
    }

    private static native void listen(int var0, int var1) throws IOException;

    public void join(InetAddress inetAddress) throws IOException {
        if (inetAddress instanceof Inet4Address) {
            VMPlainSocketImpl.join(this.nfd.getNativeFD(), inetAddress.getAddress());
        } else if (inetAddress instanceof Inet6Address) {
            VMPlainSocketImpl.join6(this.nfd.getNativeFD(), inetAddress.getAddress());
        } else {
            throw new IllegalArgumentException("unknown address type");
        }
    }

    private static native void join(int var0, byte[] var1) throws IOException;

    private static native void join6(int var0, byte[] var1) throws IOException;

    public void leave(InetAddress inetAddress) throws IOException {
        if (inetAddress instanceof Inet4Address) {
            VMPlainSocketImpl.leave(this.nfd.getNativeFD(), inetAddress.getAddress());
        } else if (inetAddress instanceof Inet6Address) {
            VMPlainSocketImpl.leave6(this.nfd.getNativeFD(), inetAddress.getAddress());
        } else {
            throw new IllegalArgumentException("unknown address type");
        }
    }

    private static native void leave(int var0, byte[] var1) throws IOException;

    private static native void leave6(int var0, byte[] var1) throws IOException;

    public void joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) throws IOException {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            VMPlainSocketImpl.joinGroup(this.nfd.getNativeFD(), inetAddress.getAddress(), networkInterface != null ? networkInterface.getName() : null);
        } else if (inetAddress instanceof Inet6Address) {
            VMPlainSocketImpl.joinGroup6(this.nfd.getNativeFD(), inetAddress.getAddress(), networkInterface != null ? networkInterface.getName() : null);
        } else {
            throw new IllegalArgumentException("unknown address type");
        }
    }

    private static native void joinGroup(int var0, byte[] var1, String var2) throws IOException;

    private static native void joinGroup6(int var0, byte[] var1, String var2) throws IOException;

    public void leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) throws IOException {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            VMPlainSocketImpl.leaveGroup(this.nfd.getNativeFD(), inetAddress.getAddress(), networkInterface != null ? networkInterface.getName() : null);
        } else if (inetAddress instanceof Inet6Address) {
            VMPlainSocketImpl.leaveGroup6(this.nfd.getNativeFD(), inetAddress.getAddress(), networkInterface != null ? networkInterface.getName() : null);
        } else {
            throw new IllegalArgumentException("unknown address type");
        }
    }

    private static native void leaveGroup(int var0, byte[] var1, String var2) throws IOException;

    private static native void leaveGroup6(int var0, byte[] var1, String var2) throws IOException;

    public void shutdownInput() throws IOException {
        VMPlainSocketImpl.shutdownInput(this.nfd.getNativeFD());
    }

    private static native void shutdownInput(int var0) throws IOException;

    public void shutdownOutput() throws IOException {
        VMPlainSocketImpl.shutdownOutput(this.nfd.getNativeFD());
    }

    private static native void shutdownOutput(int var0) throws IOException;

    public void sendUrgentData(int n) throws IOException {
        VMPlainSocketImpl.sendUrgentData(this.nfd.getNativeFD(), n);
    }

    private static native void sendUrgentData(int var0, int var1) throws IOException;

    public void close() throws IOException {
        this.nfd.close();
    }

    static {
        System.loadLibrary("javanet");
    }

    public final class State {
        private VMChannel.State channelFd = null;

        State() {
        }

        public boolean isValid() {
            if (this.channelFd != null) {
                return this.channelFd.isValid();
            }
            return false;
        }

        public int getNativeFD() throws IOException {
            return this.channelFd.getNativeFD();
        }

        public void setChannelFD(VMChannel.State state) throws IOException {
            if (this.channelFd != null && this.channelFd.isValid()) {
                throw new IOException("file descriptor already initialized");
            }
            this.channelFd = state;
        }

        public void close() throws IOException {
            if (this.channelFd == null) {
                throw new IOException("invalid file descriptor");
            }
            this.channelFd.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.isValid()) {
                    this.close();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                super.finalize();
                throw throwable;
            }
            super.finalize();
        }
    }
}

