/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.math;

import gnu.classpath.Pointer;

public final class GMP {
    private Pointer native_ptr;
    private int refCount = 1;

    public GMP() {
        this.natInitialize();
    }

    private synchronized void acquireRef() {
        ++this.refCount;
    }

    private synchronized void releaseRef() {
        --this.refCount;
        if (this.refCount == 0) {
            this.natFinalize();
            this.native_ptr = null;
        }
    }

    protected void finalize() {
        this.releaseRef();
    }

    public void fromByteArray(byte[] byArray) {
        this.acquireRef();
        this.natFromByteArray(byArray);
        this.releaseRef();
    }

    public void fromBI(GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natFromBI(gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void fromLong(long l) {
        this.acquireRef();
        this.natFromLong(l);
        this.releaseRef();
    }

    public int fromString(String string, int n) {
        this.acquireRef();
        int n2 = this.natFromString(string, n);
        this.releaseRef();
        return n2;
    }

    public void fromSignedMagnitude(byte[] byArray, boolean bl) {
        this.acquireRef();
        this.natFromSignedMagnitude(byArray, bl);
        this.releaseRef();
    }

    public String toString(int n) {
        this.acquireRef();
        String string = this.natToString(n);
        this.releaseRef();
        return string;
    }

    public void toByteArray(byte[] byArray) {
        this.acquireRef();
        this.natToByteArray(byArray);
        this.releaseRef();
    }

    public double doubleValue() {
        this.acquireRef();
        double d = this.natDoubleValue();
        this.releaseRef();
        return d;
    }

    public int absIntValue() {
        this.acquireRef();
        int n = this.natAbsIntValue();
        this.releaseRef();
        return n;
    }

    public int compare(GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        int n = this.natCompare(gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
        return n;
    }

    public void add(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natAdd(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void subtract(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natSubtract(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void multiply(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natMultiply(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void quotient(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natQuotient(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void remainder(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natRemainder(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void quotientAndRemainder(GMP gMP, GMP gMP2, GMP gMP3) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        gMP3.acquireRef();
        this.natQuotientAndRemainder(gMP.native_ptr, gMP2.native_ptr, gMP3.native_ptr);
        gMP3.releaseRef();
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void modulo(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natModulo(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void pow(int n, GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natPow(n, gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void modPow(GMP gMP, GMP gMP2, GMP gMP3) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        gMP3.acquireRef();
        this.natModPow(gMP.native_ptr, gMP2.native_ptr, gMP3.native_ptr);
        gMP3.releaseRef();
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void modInverse(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natModInverse(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void gcd(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natGCD(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void shiftLeft(int n, GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natShiftLeft(n, gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void shiftRight(int n, GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natShiftRight(n, gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void abs(GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natAbs(gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void negate(GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natNegate(gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public int bitLength() {
        this.acquireRef();
        int n = this.natBitLength();
        this.releaseRef();
        return n;
    }

    public int bitCount() {
        this.acquireRef();
        int n = this.natSetBitCount();
        this.releaseRef();
        return n;
    }

    public void and(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natAnd(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void or(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natOr(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void xor(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natXor(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void andNot(GMP gMP, GMP gMP2) {
        this.acquireRef();
        gMP.acquireRef();
        gMP2.acquireRef();
        this.natAndNot(gMP.native_ptr, gMP2.native_ptr);
        gMP2.releaseRef();
        gMP.releaseRef();
        this.releaseRef();
    }

    public void not(GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natNot(gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public void flipBit(int n, GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natFlipBit(n, gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public int testBit(int n) {
        this.acquireRef();
        int n2 = this.natTestBit(n);
        this.releaseRef();
        return n2;
    }

    public void setBit(int n, boolean bl, GMP gMP) {
        this.acquireRef();
        gMP.acquireRef();
        this.natSetBit(n, bl, gMP.native_ptr);
        gMP.releaseRef();
        this.releaseRef();
    }

    public int testPrimality(int n) {
        this.acquireRef();
        int n2 = this.natTestPrimality(n);
        this.releaseRef();
        return n2;
    }

    public int lowestSetBit() {
        this.acquireRef();
        int n = this.natLowestSetBit();
        this.releaseRef();
        return n;
    }

    public static native void natInitializeLibrary();

    private native void natInitialize();

    private native void natFinalize();

    private native void natFromLong(long var1);

    private native void natFromBI(Pointer var1);

    private native void natFromByteArray(byte[] var1);

    private native int natFromString(String var1, int var2);

    private native void natFromSignedMagnitude(byte[] var1, boolean var2);

    private native String natToString(int var1);

    private native void natToByteArray(byte[] var1);

    private native int natAbsIntValue();

    private native double natDoubleValue();

    private native int natCompare(Pointer var1);

    private native void natAdd(Pointer var1, Pointer var2);

    private native void natSubtract(Pointer var1, Pointer var2);

    private native void natMultiply(Pointer var1, Pointer var2);

    private native void natQuotient(Pointer var1, Pointer var2);

    private native void natRemainder(Pointer var1, Pointer var2);

    private native void natQuotientAndRemainder(Pointer var1, Pointer var2, Pointer var3);

    private native void natModulo(Pointer var1, Pointer var2);

    private native void natPow(int var1, Pointer var2);

    private native void natModPow(Pointer var1, Pointer var2, Pointer var3);

    private native void natModInverse(Pointer var1, Pointer var2);

    private native void natGCD(Pointer var1, Pointer var2);

    private native int natTestPrimality(int var1);

    private native void natShiftLeft(int var1, Pointer var2);

    private native void natShiftRight(int var1, Pointer var2);

    private native int natLowestSetBit();

    private native void natAbs(Pointer var1);

    private native void natNegate(Pointer var1);

    private native int natBitLength();

    private native int natSetBitCount();

    private native void natXor(Pointer var1, Pointer var2);

    private native void natOr(Pointer var1, Pointer var2);

    private native void natAnd(Pointer var1, Pointer var2);

    private native void natAndNot(Pointer var1, Pointer var2);

    private native void natFlipBit(int var1, Pointer var2);

    private native int natTestBit(int var1);

    private native void natSetBit(int var1, boolean var2, Pointer var3);

    private native void natNot(Pointer var1);
}

