/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.reflect;

import gnu.java.lang.reflect.TypeImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

final class UnresolvedTypeVariable
extends TypeImpl
implements Type {
    private GenericDeclaration decl;
    private String name;

    UnresolvedTypeVariable(GenericDeclaration genericDeclaration, String string) {
        this.decl = genericDeclaration;
        this.name = string;
    }

    Type resolve() {
        GenericDeclaration genericDeclaration = this.decl;
        while (genericDeclaration != null) {
            for (TypeVariable<?> typeVariable : genericDeclaration.getTypeParameters()) {
                if (!typeVariable.getName().equals(this.name)) continue;
                return typeVariable;
            }
            genericDeclaration = UnresolvedTypeVariable.getParent(genericDeclaration);
        }
        throw new MalformedParameterizedTypeException();
    }

    private static GenericDeclaration getParent(GenericDeclaration genericDeclaration) {
        if (genericDeclaration instanceof Class) {
            Method method = ((Class)genericDeclaration).getEnclosingMethod();
            if (method != null) {
                return method;
            }
            Constructor<?> constructor = ((Class)genericDeclaration).getEnclosingConstructor();
            if (constructor != null) {
                return constructor;
            }
            return ((Class)genericDeclaration).getEnclosingClass();
        }
        if (genericDeclaration instanceof Method) {
            return ((Method)genericDeclaration).getDeclaringClass();
        }
        if (genericDeclaration instanceof Constructor) {
            return ((Constructor)genericDeclaration).getDeclaringClass();
        }
        throw new Error();
    }
}

