/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.java.lang.management.BeanImpl;
import gnu.java.lang.management.VMMemoryMXBeanImpl;
import gnu.javax.management.ListenerData;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class MemoryMXBeanImpl
extends BeanImpl
implements MemoryMXBean,
NotificationEmitter {
    private List listeners = new ArrayList();
    private long notificationCount = 0L;
    public static CompositeType notifType;
    public static CompositeType usageType;

    public MemoryMXBeanImpl() throws NotCompliantMBeanException {
        super((Class)MemoryMXBean.class);
    }

    public void gc() {
        System.gc();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return VMMemoryMXBeanImpl.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return VMMemoryMXBeanImpl.getNonHeapMemoryUsage();
    }

    public int getObjectPendingFinalizationCount() {
        return VMMemoryMXBeanImpl.getObjectPendingFinalizationCount();
    }

    public boolean isVerbose() {
        return VMMemoryMXBeanImpl.isVerbose();
    }

    public void setVerbose(boolean bl) {
        this.checkControlPermissions();
        VMMemoryMXBeanImpl.setVerbose(bl);
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        if (notificationListener == null) {
            throw new IllegalArgumentException("Null listener added to bean.");
        }
        this.listeners.add(new ListenerData(notificationListener, notificationFilter, object));
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"java.management.memory.collection.threshold.exceeded", "java.management.memory.threshold.exceeded"}, Notification.class.getName(), "Memory Usage Notifications")};
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        Iterator iterator = this.listeners.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            ListenerData listenerData = (ListenerData)iterator.next();
            if (listenerData.getListener() != notificationListener) continue;
            iterator.remove();
            bl = true;
        }
        if (!bl) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(notificationListener, notificationFilter, object))) {
            throw new ListenerNotFoundException("The specified listener, " + notificationListener + " with filter " + notificationFilter + "and passback " + object + ", is not registered with this bean.");
        }
    }

    void fireNotification(String string, String string2, long l, long l2, long l3, long l4, long l5) {
        CompositeDataSupport compositeDataSupport;
        Notification notification = new Notification(string, this, this.notificationCount);
        MemoryUsage memoryUsage = new MemoryUsage(l, l2, l3, l4);
        try {
            compositeDataSupport = new CompositeDataSupport(notifType, new String[]{"poolName", "usage", "count"}, new Object[]{string2, memoryUsage, l5});
        }
        catch (OpenDataException openDataException) {
            throw new IllegalStateException("Something went wrong in creating the composite data instance.", openDataException);
        }
        notification.setUserData(compositeDataSupport);
        for (ListenerData listenerData : this.listeners) {
            NotificationFilter notificationFilter = listenerData.getFilter();
            if (notificationFilter != null && !notificationFilter.isNotificationEnabled(notification)) continue;
            listenerData.getListener().handleNotification(notification, listenerData.getPassback());
        }
        ++this.notificationCount;
    }

    void fireThresholdExceededNotification(String string, long l, long l2, long l3, long l4, long l5) {
        this.fireNotification("java.management.memory.threshold.exceeded", string, l, l2, l3, l4, l5);
    }

    void fireCollectionThresholdExceededNotification(String string, long l, long l2, long l3, long l4, long l5) {
        this.fireNotification("java.management.memory.collection.threshold.exceeded", string, l, l2, l3, l4, l5);
    }

    static {
        try {
            CompositeType compositeType = new CompositeType(MemoryUsage.class.getName(), "Describes the usage levels of a pool", new String[]{"init", "used", "committed", "max"}, new String[]{"Initial level", "Used level", "Committed level", "Maximum level"}, new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG});
            CompositeType compositeType2 = new CompositeType(MemoryNotificationInfo.class.getName(), "Provides the notification info on memory usage", new String[]{"poolName", "usage", "count"}, new String[]{"Name of the memory pool", "Usage level of the memory pool", "Number of times the threshold has been crossed"}, new OpenType[]{SimpleType.STRING, compositeType, SimpleType.LONG});
        }
        catch (OpenDataException openDataException) {
            throw new IllegalStateException("Something went wrong in creating the composite data types.", openDataException);
        }
    }
}

