/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.lang.management;

import gnu.javax.management.Translator;
import java.lang.management.ManagementPermission;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class BeanImpl
extends StandardMBean {
    private OpenMBeanInfo openInfo;

    protected BeanImpl(Class clazz) throws NotCompliantMBeanException {
        super(clazz);
    }

    protected void cacheMBeanInfo(MBeanInfo mBeanInfo) {
        if (mBeanInfo == null) {
            return;
        }
        try {
            OpenMBeanConstructorInfo[] openMBeanConstructorInfoArray;
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            OpenMBeanAttributeInfo[] openMBeanAttributeInfoArray = new OpenMBeanAttributeInfoSupport[mBeanAttributeInfoArray.length];
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                openMBeanConstructorInfoArray = Translator.translate(mBeanAttributeInfoArray[i].getType());
                if (openMBeanConstructorInfoArray.getMinValue() == null) {
                    Object[] objectArray = openMBeanConstructorInfoArray.getLegalValues() == null ? null : openMBeanConstructorInfoArray.getLegalValues().toArray();
                    openMBeanAttributeInfoArray[i] = new OpenMBeanAttributeInfoSupport(mBeanAttributeInfoArray[i].getName(), mBeanAttributeInfoArray[i].getDescription(), openMBeanConstructorInfoArray.getOpenType(), mBeanAttributeInfoArray[i].isReadable(), mBeanAttributeInfoArray[i].isWritable(), mBeanAttributeInfoArray[i].isIs(), openMBeanConstructorInfoArray.getDefaultValue(), objectArray);
                    continue;
                }
                openMBeanAttributeInfoArray[i] = new OpenMBeanAttributeInfoSupport(mBeanAttributeInfoArray[i].getName(), mBeanAttributeInfoArray[i].getDescription(), openMBeanConstructorInfoArray.getOpenType(), mBeanAttributeInfoArray[i].isReadable(), mBeanAttributeInfoArray[i].isWritable(), mBeanAttributeInfoArray[i].isIs(), openMBeanConstructorInfoArray.getDefaultValue(), openMBeanConstructorInfoArray.getMinValue(), openMBeanConstructorInfoArray.getMaxValue());
            }
            MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
            openMBeanConstructorInfoArray = new OpenMBeanConstructorInfoSupport[mBeanConstructorInfoArray.length];
            for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
                openMBeanConstructorInfoArray[i] = new OpenMBeanConstructorInfoSupport(mBeanConstructorInfoArray[i].getName(), mBeanConstructorInfoArray[i].getDescription(), this.translateSignature(mBeanConstructorInfoArray[i].getSignature()));
            }
            MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
            OpenMBeanOperationInfo[] openMBeanOperationInfoArray = new OpenMBeanOperationInfoSupport[mBeanOperationInfoArray.length];
            for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                openMBeanOperationInfoArray[i] = new OpenMBeanOperationInfoSupport(mBeanOperationInfoArray[i].getName(), mBeanOperationInfoArray[i].getDescription(), this.translateSignature(mBeanOperationInfoArray[i].getSignature()), Translator.translate(mBeanOperationInfoArray[i].getReturnType()).getOpenType(), mBeanOperationInfoArray[i].getImpact());
            }
            this.openInfo = new OpenMBeanInfoSupport(mBeanInfo.getClassName(), mBeanInfo.getDescription(), openMBeanAttributeInfoArray, openMBeanConstructorInfoArray, openMBeanOperationInfoArray, mBeanInfo.getNotifications());
        }
        catch (OpenDataException openDataException) {
            throw (InternalError)new InternalError("A problem occurred creating the open type descriptors.").initCause(openDataException);
        }
    }

    protected void checkMonitorPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("monitor"));
        }
    }

    protected void checkControlPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new ManagementPermission("control"));
        }
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object = super.getAttribute(string);
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        Class<Object> clazz = object.getClass();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string2 = clazz.getName();
        String[] stringArray = OpenType.ALLOWED_CLASSNAMES;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return object;
        }
        OpenMBeanInfo openMBeanInfo = (OpenMBeanInfo)((Object)this.getMBeanInfo());
        MBeanAttributeInfo[] mBeanAttributeInfoArray = openMBeanInfo.getAttributes();
        OpenType<?> openType = null;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            if (!mBeanAttributeInfoArray[i].getName().equals(string)) continue;
            openType = ((OpenMBeanAttributeInfo)((Object)mBeanAttributeInfoArray[i])).getOpenType();
        }
        if (object instanceof List) {
            try {
                Class<?> clazz2 = Class.forName(((ArrayType)openType).getElementOpenType().getClassName());
                List list2 = (List)object;
                Object[] objectArray = (Object[])Array.newInstance(clazz2, list2.size());
                return list2.toArray(objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (InternalError)new InternalError("The class of the list element type could not be created").initCause(classNotFoundException);
            }
        }
        if (object instanceof Map) {
            TabularType tabularType = (TabularType)openType;
            TabularDataSupport tabularDataSupport = new TabularDataSupport(tabularType);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                try {
                    tabularDataSupport.put(new CompositeDataSupport(tabularType.getRowType(), new String[]{"key", "value"}, new Object[]{entry.getKey(), entry.getValue()}));
                }
                catch (OpenDataException openDataException) {
                    throw (InternalError)new InternalError("A problem occurred converting the map to a composite data structure.").initCause(openDataException);
                }
            }
            return tabularDataSupport;
        }
        CompositeType compositeType = (CompositeType)openType;
        Set<String> set = compositeType.keySet();
        Iterator<String> iterator = set.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>(set.size());
        while (iterator.hasNext()) {
            String string3 = iterator.next();
            Method method = null;
            try {
                method = clazz.getMethod("get" + string3, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                arrayList.add(method.invoke(object, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException, "Failed to retrieve " + string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ReflectionException(illegalArgumentException, "Failed to retrieve " + string3);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new MBeanException((Exception)invocationTargetException.getCause(), "The getter of " + string3 + " threw an exception");
            }
        }
        try {
            return new CompositeDataSupport(compositeType, set.toArray(new String[set.size()]), arrayList.toArray());
        }
        catch (OpenDataException openDataException) {
            throw (InternalError)new InternalError("A problem occurred converting the value to a composite data structure.").initCause(openDataException);
        }
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return (MBeanInfo)((Object)this.openInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = mBeanParameterInfo.getDescription();
        if (string == null) {
            return "param" + n;
        }
        return string;
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = mBeanParameterInfo.getDescription();
        if (string == null) {
            return "param" + n;
        }
        return string;
    }

    protected String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = mBeanParameterInfo.getName();
        if (string == null) {
            return "param" + n;
        }
        return string;
    }

    protected String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = mBeanParameterInfo.getName();
        if (string == null) {
            return "param" + n;
        }
        return string;
    }

    public MBeanInfo getMBeanInfo() {
        super.getMBeanInfo();
        return this.getCachedMBeanInfo();
    }

    private OpenMBeanParameterInfo[] translateSignature(MBeanParameterInfo[] mBeanParameterInfoArray) throws OpenDataException {
        OpenMBeanParameterInfo[] openMBeanParameterInfoArray = new OpenMBeanParameterInfoSupport[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            OpenMBeanParameterInfo openMBeanParameterInfo = Translator.translate(mBeanParameterInfoArray[i].getType());
            if (openMBeanParameterInfo.getMinValue() == null) {
                Object[] objectArray = openMBeanParameterInfo.getLegalValues() == null ? null : openMBeanParameterInfo.getLegalValues().toArray();
                openMBeanParameterInfoArray[i] = new OpenMBeanParameterInfoSupport(mBeanParameterInfoArray[i].getName(), mBeanParameterInfoArray[i].getDescription(), openMBeanParameterInfo.getOpenType(), openMBeanParameterInfo.getDefaultValue(), objectArray);
                continue;
            }
            openMBeanParameterInfoArray[i] = new OpenMBeanParameterInfoSupport(mBeanParameterInfoArray[i].getName(), mBeanParameterInfoArray[i].getDescription(), openMBeanParameterInfo.getOpenType(), openMBeanParameterInfo.getDefaultValue(), openMBeanParameterInfo.getMinValue(), openMBeanParameterInfo.getMaxValue());
        }
        return openMBeanParameterInfoArray;
    }
}

