/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import gnu.java.beans.encoder.Context;
import gnu.java.beans.encoder.ObjectId;
import java.util.HashMap;

public abstract class ScannerState {
    static final int TRANSITION_METHOD_INVOCATION = 0;
    static final int TRANSITION_STATIC_METHOD_INVOCATION = 1;
    static final int TRANSITION_STATIC_FIELD_ACCESS = 2;
    static final int TRANSITION_CLASS_RESOLUTION = 3;
    static final int TRANSITION_OBJECT_INSTANTIATION = 4;
    static final int TRANSITION_PRIMITIVE_INSTANTIATION = 5;
    static final int TRANSITION_OBJECT_ARRAY_INSTANTIATION = 6;
    static final int TRANSITION_PRIMITIVE_ARRAY_INSTANTIATION = 7;
    static final int TRANSITION_ARRAY_SET = 8;
    static final int TRANSITION_ARRAY_GET = 9;
    static final int TRANSITION_LIST_SET = 10;
    static final int TRANSITION_LIST_GET = 11;
    static final int TRANSITION_NULL_OBJECT = 12;
    static final int TRANSITION_STRING_REFERENCE = 13;
    static final int TRANSITION_OBJECT_REFERENCE = 14;
    static final int TRANSITION_FIRST = 0;
    static final int TRANSITION_LAST = 14;
    static final String DEFAULT_STATE_NAME = "default";
    String defaultSuccessor = "default";
    static String[] transitionNames = new String[]{"METHOD_INVOCATION", "STATIC_METHOD_INVOCATION", "STATIC_FIELD_ACCESS", "CLASS_RESOLUTION", "OBJECT_INSTANTIATION", "PRIMITIVE_INSTANTIATION", "OBJECT_ARRAY_INSTANTIATION", "PRIMITIVE_ARRAY_INSTANTIATION", "ARRAY_SET", "ARRAY_GET", "LIST_SET", "LIST_GET", "NULL_OBJECT", "STRING_REFERENCE", "OBJECT_REFERENCE"};
    HashMap transitions = new HashMap();
    int calls;
    Context context;
    String name;

    final void init(String string) {
        assert (this.name == null);
        this.name = string;
    }

    final String getName() {
        return this.name;
    }

    final void enter(Context context) {
        ++this.calls;
        this.context = context;
        this.enterImpl(context);
    }

    protected void enterImpl(Context context) {
    }

    final Context context() {
        return this.context;
    }

    final int getCalls() {
        return this.calls;
    }

    final void putSuccessor(int n, String string) {
        assert (n >= 0 && n <= 14) : "Transition identifier '" + n + "' is unknown.";
        this.transitions.put(new Integer(n), string);
    }

    final String getSuccessor(int n) {
        String string = (String)this.transitions.get(new Integer(n));
        return string == null ? this.defaultSuccessor : string;
    }

    final void setDefaultSuccessor(String string) {
        this.defaultSuccessor = string;
    }

    abstract void methodInvocation(String var1);

    abstract void staticMethodInvocation(String var1, String var2);

    abstract void staticFieldAccess(String var1, String var2);

    abstract void classResolution(String var1);

    abstract void objectInstantiation(String var1, ObjectId var2);

    abstract void primitiveInstantiation(String var1, String var2);

    abstract void objectArrayInstantiation(String var1, String var2, ObjectId var3);

    abstract void primitiveArrayInstantiation(String var1, String var2, ObjectId var3);

    abstract void arraySet(String var1);

    abstract void arrayGet(String var1);

    abstract void listGet();

    abstract void listSet();

    abstract void nullObject();

    abstract void stringReference(String var1);

    abstract void objectReference(ObjectId var1);

    abstract void end();

    void enter() {
    }
}

