/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.encoder;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.lang.reflect.Array;
import java.util.HashMap;

public class ArrayPersistenceDelegate
extends PersistenceDelegate {
    private static final HashMap NULL_VALUES = new HashMap();

    protected Expression instantiate(Object object, Encoder encoder) {
        Class<?> clazz = object.getClass().getComponentType();
        assert (clazz != null);
        return new Expression(object, Array.class, "newInstance", new Object[]{clazz, new Integer(Array.getLength(object))});
    }

    protected void initialize(Class clazz, Object object, Object object2, Encoder encoder) {
        int n = Array.getLength(object);
        if ((clazz = clazz.getComponentType()).isPrimitive()) {
            Object v = NULL_VALUES.get(clazz);
            for (int i = 0; i < n; ++i) {
                Object object3 = Array.get(object, i);
                if (object3.equals(v)) continue;
                encoder.writeExpression(new Expression(Array.class, "get", new Object[]{object, i}));
                encoder.writeStatement(new Statement(Array.class, "set", new Object[]{object, i, object3}));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Object object4 = Array.get(object, i);
                if (object4 == null) continue;
                encoder.writeExpression(new Expression(Array.class, "get", new Object[]{object, i}));
                encoder.writeStatement(new Statement(Array.class, "set", new Object[]{object, i, object4}));
            }
        }
    }

    static {
        NULL_VALUES.put(Boolean.TYPE, Boolean.FALSE);
        NULL_VALUES.put(Byte.TYPE, (byte)0);
        NULL_VALUES.put(Short.TYPE, (short)0);
        NULL_VALUES.put(Integer.TYPE, 0);
        NULL_VALUES.put(Long.TYPE, 0L);
        NULL_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        NULL_VALUES.put(Double.TYPE, 0.0);
    }
}

