/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractElementHandler;
import gnu.java.beans.decoder.ArrayHandler;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.BooleanHandler;
import gnu.java.beans.decoder.ByteHandler;
import gnu.java.beans.decoder.CharHandler;
import gnu.java.beans.decoder.ClassHandler;
import gnu.java.beans.decoder.Context;
import gnu.java.beans.decoder.DoubleHandler;
import gnu.java.beans.decoder.DummyHandler;
import gnu.java.beans.decoder.ElementHandler;
import gnu.java.beans.decoder.FloatHandler;
import gnu.java.beans.decoder.IntHandler;
import gnu.java.beans.decoder.JavaHandler;
import gnu.java.beans.decoder.LongHandler;
import gnu.java.beans.decoder.NullHandler;
import gnu.java.beans.decoder.ObjectHandler;
import gnu.java.beans.decoder.ShortHandler;
import gnu.java.beans.decoder.StringHandler;
import gnu.java.beans.decoder.VoidHandler;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PersistenceParser
extends DefaultHandler
implements Context {
    private ExceptionListener exceptionListener;
    private int skipElement;
    private HashMap handlerCreators = new HashMap();
    private ElementHandler currentHandler;
    JavaHandler javaHandler;
    private List objects = new LinkedList();
    private XMLDecoder decoder;

    public PersistenceParser(InputStream inputStream, ExceptionListener exceptionListener, ClassLoader classLoader, XMLDecoder xMLDecoder) {
        SAXParser sAXParser;
        this.exceptionListener = exceptionListener;
        this.decoder = xMLDecoder;
        DummyHandler dummyHandler = new DummyHandler();
        this.currentHandler = dummyHandler;
        this.javaHandler = new JavaHandler(dummyHandler, this, classLoader);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw (InternalError)new InternalError("No SAX Parser available.").initCause(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw (InternalError)new InternalError("No SAX Parser available.").initCause(sAXException);
        }
        this.handlerCreators.put("java", new JavaHandlerCreator());
        this.handlerCreators.put("object", new ObjectHandlerCreator());
        this.handlerCreators.put("void", new VoidHandlerCreator());
        this.handlerCreators.put("array", new ArrayHandlerCreator());
        this.handlerCreators.put("class", new ClassHandlerCreator());
        this.handlerCreators.put("null", new NullHandlerCreator());
        this.handlerCreators.put("char", new CharHandlerCreator());
        this.handlerCreators.put("string", new StringHandlerCreator());
        this.handlerCreators.put("boolean", new BooleanHandlerCreator());
        this.handlerCreators.put("byte", new ByteHandlerCreator());
        this.handlerCreators.put("short", new ShortHandlerCreator());
        this.handlerCreators.put("int", new IntHandlerCreator());
        this.handlerCreators.put("long", new LongHandlerCreator());
        this.handlerCreators.put("float", new FloatHandlerCreator());
        this.handlerCreators.put("double", new DoubleHandlerCreator());
        try {
            sAXParser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            exceptionListener.exceptionThrown(new IllegalArgumentException("XML data not well-formed."));
        }
        catch (IOException iOException) {
            exceptionListener.exceptionThrown(iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.currentHandler.hasFailed() || this.skipElement > 0) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element unusable due to previous error: " + string3));
            ++this.skipElement;
            return;
        }
        if (!this.currentHandler.isSubelementAllowed(string3)) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element is not allowed here: " + string3));
            ++this.skipElement;
            return;
        }
        if (!this.handlerCreators.containsKey(string3)) {
            this.exceptionListener.exceptionThrown(new IllegalArgumentException("Element unusable because tag is unknown: " + string3));
            ++this.skipElement;
            return;
        }
        AbstractElementHandler abstractElementHandler = ((Creator)this.handlerCreators.get(string3)).createHandler(this.currentHandler);
        this.currentHandler = abstractElementHandler;
        this.currentHandler.start(attributes, this.exceptionListener);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.skipElement > 0) {
            --this.skipElement;
            return;
        }
        this.currentHandler.end(this.exceptionListener);
        this.currentHandler = this.currentHandler.getParent();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skipElement > 0) {
            return;
        }
        this.currentHandler.characters(cArray, n, n2);
    }

    public void addParameterObject(Object object) throws AssemblyException {
        this.objects.add(object);
    }

    public void notifyStatement(Context context) throws AssemblyException {
    }

    public Object endContext(Context context) throws AssemblyException {
        return null;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int n, Object object) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Set method is not allowed in decoder context."));
    }

    public Object get(int n) throws AssemblyException {
        throw new AssemblyException(new IllegalArgumentException("Get method is not allowed in decoder context."));
    }

    public Object getResult() {
        return this.decoder;
    }

    public void setId(String string) {
        this.exceptionListener.exceptionThrown(new IllegalArgumentException("id attribute is not allowed for <java> tag."));
    }

    public String getId() {
        return null;
    }

    public boolean isStatement() {
        return true;
    }

    public void setStatement(boolean bl) {
    }

    public Iterator iterator() {
        return this.objects.iterator();
    }

    class ArrayHandlerCreator
    implements Creator {
        ArrayHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new ArrayHandler(elementHandler);
        }
    }

    class NullHandlerCreator
    implements Creator {
        NullHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new NullHandler(elementHandler);
        }
    }

    class ClassHandlerCreator
    implements Creator {
        ClassHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new ClassHandler(elementHandler);
        }
    }

    class VoidHandlerCreator
    implements Creator {
        VoidHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new VoidHandler(elementHandler);
        }
    }

    class ObjectHandlerCreator
    implements Creator {
        ObjectHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new ObjectHandler(elementHandler);
        }
    }

    class JavaHandlerCreator
    implements Creator {
        JavaHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return PersistenceParser.this.javaHandler;
        }
    }

    class StringHandlerCreator
    implements Creator {
        StringHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new StringHandler(elementHandler);
        }
    }

    class CharHandlerCreator
    implements Creator {
        CharHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new CharHandler(elementHandler);
        }
    }

    class DoubleHandlerCreator
    implements Creator {
        DoubleHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new DoubleHandler(elementHandler);
        }
    }

    class FloatHandlerCreator
    implements Creator {
        FloatHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new FloatHandler(elementHandler);
        }
    }

    class LongHandlerCreator
    implements Creator {
        LongHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new LongHandler(elementHandler);
        }
    }

    class IntHandlerCreator
    implements Creator {
        IntHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new IntHandler(elementHandler);
        }
    }

    class ShortHandlerCreator
    implements Creator {
        ShortHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new ShortHandler(elementHandler);
        }
    }

    class ByteHandlerCreator
    implements Creator {
        ByteHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new ByteHandler(elementHandler);
        }
    }

    class BooleanHandlerCreator
    implements Creator {
        BooleanHandlerCreator() {
        }

        public AbstractElementHandler createHandler(ElementHandler elementHandler) {
            return new BooleanHandler(elementHandler);
        }
    }

    static interface Creator {
        public AbstractElementHandler createHandler(ElementHandler var1);
    }
}

