/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;

class MethodFinder {
    private static HashMap typeMapping = new HashMap();

    private MethodFinder() {
    }

    static Method getMethod(Class clazz, String string, Object[] objectArray) throws NoSuchMethodException {
        Class[] classArray = MethodFinder.getArgumentTypes(objectArray);
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string) || !MethodFinder.matchingArgumentTypes(methodArray[i].getParameterTypes(), classArray)) continue;
            return methodArray[i];
        }
        throw new NoSuchMethodException("Could not find a matching method named " + string + "() in class " + clazz);
    }

    static Constructor getConstructor(Class clazz, Object[] objectArray) throws NoSuchMethodException {
        Class[] classArray = MethodFinder.getArgumentTypes(objectArray);
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (!MethodFinder.matchingArgumentTypes(constructorArray[i].getParameterTypes(), classArray)) continue;
            return constructorArray[i];
        }
        throw new NoSuchMethodException("Could not find a matching constructor in class " + clazz);
    }

    private static Class[] getArgumentTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        return classArray;
    }

    private static boolean matchingArgumentTypes(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i] == null) continue;
            if (typeMapping.containsKey(classArray2[i])) {
                Class clazz = (Class)typeMapping.get(classArray2[i]);
                if (classArray[i].isAssignableFrom(classArray2[i]) || classArray[i].isAssignableFrom(clazz)) continue;
                return false;
            }
            if (classArray[i].isAssignableFrom(classArray2[i])) continue;
            return false;
        }
        return true;
    }

    static {
        typeMapping.put(Byte.class, Byte.TYPE);
        typeMapping.put(Short.class, Short.TYPE);
        typeMapping.put(Integer.class, Integer.TYPE);
        typeMapping.put(Long.class, Long.TYPE);
        typeMapping.put(Float.class, Float.TYPE);
        typeMapping.put(Double.class, Double.TYPE);
        typeMapping.put(Character.class, Character.TYPE);
        typeMapping.put(Boolean.class, Boolean.TYPE);
    }
}

