/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.print;

import gnu.java.awt.print.SpooledDocument;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.util.Map;

class PostScriptGraphics2D
extends Graphics2D {
    private PrinterJob printerJob;
    private PrintWriter out;
    private AffineTransform currentTransform = new AffineTransform();
    private AffineTransform pageTransform;
    private RenderingHints renderingHints;
    private Paint currentPaint = null;
    private Shape clipShape = null;
    private Font currentFont = null;
    private Color currentColor = Color.black;
    private Color backgroundColor = Color.white;
    private Stroke currentStroke = null;
    private static Stroke ordinaryStroke = new BasicStroke(0.0f, 0, 0);
    private float cx;
    private float cy;
    private boolean currentFontIsPS;
    private double pageX = 595.0;
    private double pageY;
    private double Y = this.pageY = 842.0;
    private boolean gradientOn = false;

    public PostScriptGraphics2D(PrinterJob printerJob) {
        this.printerJob = printerJob;
        this.pageTransform = new AffineTransform();
        this.currentTransform = new AffineTransform();
        this.renderingHints = new RenderingHints(null);
        this.renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.renderingHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
    }

    public SpooledDocument spoolPostScript(Printable printable, PageFormat pageFormat, Pageable pageable) throws PrinterException {
        try {
            File file = File.createTempFile("cpspool", ".ps");
            file.deleteOnExit();
            this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO8859_1"), 1000000));
            this.writePSHeader();
            if (pageable != null) {
                for (int i = 0; i < pageable.getNumberOfPages(); ++i) {
                    this.spoolPage(this.out, pageable.getPrintable(i), pageable.getPageFormat(i), i);
                }
            } else {
                int n = 0;
                while (this.spoolPage(this.out, printable, pageFormat, n++) == 0) {
                }
            }
            this.out.println("%%Trailer");
            this.out.println("%%EOF");
            this.out.close();
            return new SpooledDocument(file);
        }
        catch (IOException iOException) {
            PrinterException printerException = new PrinterException();
            printerException.initCause(iOException);
            throw printerException;
        }
    }

    private void writePSHeader() {
        this.out.println("%!PS-Adobe-3.0");
        this.out.println("%%Title: " + this.printerJob.getJobName());
        this.out.println("%%Creator: GNU Classpath ");
        this.out.println("%%DocumentData: Clean8Bit");
        this.out.println("%%DocumentNeededResources: font Times-Roman Helvetica Courier");
        this.out.println("%%EndComments");
        this.out.println("%%BeginProlog");
        this.out.println("%%EndProlog");
        this.out.println("%%BeginSetup");
        this.out.println("%%EndFeature");
        this.setupFonts();
        this.out.println("%%EndSetup");
        this.setFont(new Font("Dialog", 0, 12));
        this.currentColor = Color.white;
        this.currentStroke = new BasicStroke();
        this.setPaint(this.currentColor);
        this.setStroke(this.currentStroke);
    }

    private void setupFonts() {
        this.out.println("/helveticaISO");
        this.out.println("/Helvetica findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
        this.out.println("/timesISO");
        this.out.println("/Times-Roman findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
        this.out.println("/courierISO");
        this.out.println("/Courier findfont dup length dict begin");
        this.out.println("{ 1 index /FID eq { pop pop } { def } ifelse } forall");
        this.out.println("/Encoding ISOLatin1Encoding def");
        this.out.println("currentdict end definefont pop");
    }

    public int spoolPage(PrintWriter printWriter, Printable printable, PageFormat pageFormat, int n) throws IOException, PrinterException {
        printWriter.println("%%BeginPageSetup");
        Paper paper = pageFormat.getPaper();
        this.pageX = paper.getWidth();
        this.pageY = paper.getHeight();
        if (pageFormat.getOrientation() == 1) {
            printWriter.println("%%Orientation: Portrait");
        } else {
            printWriter.println("%%Orientation: Landscape");
            double d = this.pageX;
            this.pageX = this.pageY;
            this.pageY = d;
        }
        this.setClip(0, 0, (int)this.pageX, (int)this.pageY);
        printWriter.println("gsave % first save");
        printWriter.println("<< /PageSize [" + this.pageX + " " + this.pageY + "] >> setpagedevice");
        if (pageFormat.getOrientation() != 0) {
            this.pageTransform.translate(this.pageX, 0.0);
            this.pageTransform.scale(-1.0, 1.0);
        }
        this.pushCTM();
        this.concatCTM(this.pageTransform);
        this.setTransform(new AffineTransform());
        printWriter.println("%%EndPageSetup");
        printWriter.println("gsave");
        if (printable.print(this, pageFormat, n) == 1) {
            return 1;
        }
        printWriter.println("grestore");
        printWriter.println("showpage");
        return 0;
    }

    private void pushCTM() {
        this.out.println("matrix currentmatrix   % pushCTM()");
    }

    private void popCTM() {
        this.out.println("setmatrix % restore CTM");
    }

    public Graphics create() {
        return null;
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.out.println("% drawOval()");
        this.setStroke(ordinaryStroke);
        this.draw(new Ellipse2D.Double(n, n2, n3, n4));
        this.setStroke(this.currentStroke);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        if (n <= 0 || nArray.length < n || nArray2.length < n) {
            return;
        }
        this.out.println("newpath % drawPolyLine()");
        this.out.println(nArray[0] + " " + nArray2[0] + " moveto");
        for (int i = 1; i < n; ++i) {
            this.out.println(nArray[i] + " " + nArray2[i] + " lineto");
        }
        this.out.println("closepath");
        this.out.println("stroke");
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.out.println("% drawRoundRect()");
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6);
        this.setStroke(ordinaryStroke);
        this.draw(double_);
        this.setStroke(this.currentStroke);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.out.println("% fillRoundRect()");
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6);
        this.fill(double_);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setStroke(ordinaryStroke);
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
        this.setStroke(this.currentStroke);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.out.println("% fillOval()");
        this.fill(new Ellipse2D.Double(n, n2, n3, n4));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.out.println("% fillPolygon()");
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.out.println("% drawLine()");
        this.setStroke(ordinaryStroke);
        this.out.println("newpath");
        this.out.println(n + " " + n2 + " moveto");
        this.out.println(n3 + " " + n4 + " lineto");
        this.out.println("stroke");
        this.setStroke(this.currentStroke);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n3 - 1, n4 - 1, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n5 > n7) {
            n9 = n5;
            n5 = n7;
            n7 = n9;
            boolean bl3 = bl = !bl;
        }
        if (n6 > n8) {
            n9 = n6;
            n6 = n8;
            n8 = n9;
            boolean bl4 = bl2 = !bl2;
        }
        if (n > n3) {
            n9 = n;
            n = n3;
            n3 = n9;
            boolean bl5 = bl = !bl;
        }
        if (n2 > n4) {
            n9 = n2;
            n2 = n4;
            n4 = n9;
            bl2 = !bl2;
        }
        n9 = 0;
        int n10 = n7 - n5;
        int n11 = n8 - n6;
        int[] nArray = new int[n10 * n11];
        int n12 = n3 - n;
        int n13 = n4 - n2;
        double d = (double)n12 / (double)n10;
        double d2 = (double)n13 / (double)n11;
        this.out.println("% drawImage() 2");
        this.out.println("gsave");
        this.out.println(n + " " + n2 + " translate");
        this.out.println(n12 + " " + n13 + " scale");
        this.out.println(n10 + " " + n11 + " 8 [" + (bl ? -n10 : n10) + " 0 0 " + (bl2 ? -n11 : n11) + " " + (bl ? n10 : 0) + " " + (bl2 ? n11 : 0) + " ]");
        this.out.println("{currentfile 3 string readhexstring pop} bind");
        this.out.println("false 3 colorimage");
        PixelGrabber pixelGrabber = new PixelGrabber(image, n5, n6, n10, n11, nArray, 0, n10);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return false;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return false;
        }
        for (int i = 0; i < n11; ++i) {
            for (int j = 0; j < n10; ++j) {
                this.out.print(this.colorTripleHex(new Color(nArray[i * n10 + j])));
                if (++n9 % 11 != 0) continue;
                this.out.println();
            }
        }
        this.out.println();
        this.out.println("%%EOF");
        this.out.println("grestore");
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        return this.drawImage(image, n, n2, n + n3, n2 + n4, 0, 0, n5 - 1, n6 - 1, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        this.drawImage((Image)bufferedImage2, n, n2, null);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        AffineTransform affineTransform2 = new AffineTransform(this.currentTransform);
        this.transform(affineTransform);
        boolean bl = this.drawImage(image, 0, 0, null, imageObserver);
        this.setTransform(affineTransform2);
        return bl;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.setStroke(ordinaryStroke);
        this.draw(new Polygon(nArray, nArray2, n));
        this.setStroke(this.currentStroke);
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(String string, float f, float f2) {
        if (string.trim().equals("")) {
            return;
        }
        if (this.currentFontIsPS) {
            this.drawStringPSFont(string, f, f2);
            return;
        }
        TextLayout textLayout = new TextLayout(string, this.currentFont, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.drawStringShape(shape);
    }

    private void drawStringPSFont(String string, float f, float f2) {
        this.out.println("% drawString PS font");
        this.out.println(f + " " + f2 + " moveto");
        this.saveAndInvertAxis();
        this.out.println("(" + string + ") show");
        this.restoreAxis();
    }

    private void saveAndInvertAxis() {
        this.popCTM();
        this.pushCTM();
        double[] dArray = new double[]{this.pageTransform.getScaleX(), this.pageTransform.getShearY(), this.pageTransform.getShearX(), this.pageTransform.getScaleY(), this.pageTransform.getTranslateX(), -this.pageTransform.getTranslateY() + this.pageY};
        double[] dArray2 = new double[]{this.currentTransform.getScaleX(), this.currentTransform.getShearY(), -this.currentTransform.getShearX(), -this.currentTransform.getScaleY(), this.currentTransform.getTranslateX(), this.currentTransform.getTranslateY()};
        AffineTransform affineTransform = new AffineTransform(dArray);
        affineTransform.concatenate(new AffineTransform(dArray2));
        this.concatCTM(affineTransform);
    }

    private void restoreAxis() {
        this.popCTM();
        this.pushCTM();
        AffineTransform affineTransform = new AffineTransform(this.pageTransform);
        affineTransform.concatenate(this.currentTransform);
        this.concatCTM(affineTransform);
    }

    private void drawStringShape(Shape shape) {
        this.saveAndInvertAxis();
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.out.println(fArray[0] + " " + (this.Y - (double)fArray[1]) + " moveto");
                    this.cx = fArray[0];
                    this.cy = fArray[1];
                    break;
                }
                case 1: {
                    this.out.println(fArray[0] + " " + (this.Y - (double)fArray[1]) + " lineto");
                    this.cx = fArray[0];
                    this.cy = fArray[1];
                    break;
                }
                case 2: {
                    float f = (this.cx + 2.0f * fArray[0]) / 3.0f;
                    float f2 = (this.cy + 2.0f * fArray[1]) / 3.0f;
                    float f3 = (2.0f * fArray[2] + fArray[0]) / 3.0f;
                    float f4 = (2.0f * fArray[3] + fArray[1]) / 3.0f;
                    this.out.print(f + " " + (this.Y - (double)f2) + " ");
                    this.out.print(f3 + " " + (this.Y - (double)f4) + " ");
                    this.out.println(fArray[2] + " " + (this.Y - (double)fArray[3]) + " curveto");
                    this.cx = fArray[2];
                    this.cy = fArray[3];
                    break;
                }
                case 3: {
                    this.out.print(fArray[0] + " " + (this.Y - (double)fArray[1]) + " ");
                    this.out.print(fArray[2] + " " + (this.Y - (double)fArray[3]) + " ");
                    this.out.println(fArray[4] + " " + (this.Y - (double)fArray[5]) + " curveto");
                    this.cx = fArray[4];
                    this.cy = fArray[5];
                    break;
                }
                case 4: {
                    this.out.println("closepath");
                }
            }
            pathIterator.next();
        }
        this.out.println("fill");
        this.restoreAxis();
    }

    public void setColor(Color color) {
        if (color.equals(this.currentColor)) {
            return;
        }
        this.gradientOn = false;
        this.currentColor = color;
        this.currentPaint = color;
        this.out.println(this.colorTriple(color) + " setrgbcolor");
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.out.println("% clearRect");
        Color color = this.currentColor;
        this.setColor(this.backgroundColor);
        this.fill(new Rectangle2D.Double(n, n2, n3, n4));
        this.setColor(color);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void dispose() {
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.out.println("% setClip()");
        this.setClip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    public void setClip(Shape shape) {
        this.clip(shape);
    }

    public Shape getClip() {
        return this.clipShape;
    }

    public Rectangle getClipBounds() {
        return this.clipShape.getBounds();
    }

    public Color getColor() {
        return this.currentColor;
    }

    public Font getFont() {
        return this.currentFont;
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.currentFont);
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public void setFont(Font font) {
        this.out.println("% setfont()");
        if (font == null) {
            font = new Font("Dialog", 0, 12);
        }
        this.currentFont = font;
        this.setPSFont();
    }

    private void setPSFont() {
        this.currentFontIsPS = false;
        String string = this.currentFont.getName();
        this.out.println("% setPSFont: Fontname: " + string);
        if (string.equalsIgnoreCase("Helvetica") || string.equalsIgnoreCase("SansSerif")) {
            this.out.print("/helveticaISO findfont ");
        } else if (string.equalsIgnoreCase("Times New Roman")) {
            this.out.print("/timesISO findfont ");
        } else if (string.equalsIgnoreCase("Courier")) {
            this.out.print("/courierISO findfont ");
        } else {
            return;
        }
        this.currentFontIsPS = true;
        this.out.print(this.currentFont.getSize() + " scalefont ");
        this.out.println("setfont");
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public void close() {
        this.out.println("showpage");
        this.out.println("%%Trailer");
        this.out.println("grestore % restore original stuff");
        this.out.println("%%EOF");
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.out = null;
    }

    public void addRenderingHints(Map map) {
    }

    private void writeShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.out.println(fArray[0] + " " + fArray[1] + " moveto");
                    this.cx = fArray[0];
                    this.cy = fArray[1];
                    break;
                }
                case 1: {
                    this.out.println(fArray[0] + " " + fArray[1] + " lineto");
                    this.cx = fArray[0];
                    this.cy = fArray[1];
                    break;
                }
                case 2: {
                    float f = (this.cx + 2.0f * fArray[0]) / 3.0f;
                    float f2 = (this.cy + 2.0f * fArray[1]) / 3.0f;
                    float f3 = (2.0f * fArray[2] + fArray[0]) / 3.0f;
                    float f4 = (2.0f * fArray[3] + fArray[1]) / 3.0f;
                    this.out.print(f + " " + (this.Y - (double)f2) + " ");
                    this.out.print(f3 + " " + (this.Y - (double)f4) + " ");
                    this.out.println(fArray[2] + " " + (this.Y - (double)fArray[3]) + " curveto");
                    this.cx = fArray[2];
                    this.cy = fArray[3];
                    break;
                }
                case 3: {
                    this.out.print(fArray[0] + " " + fArray[1] + " ");
                    this.out.print(fArray[2] + " " + fArray[3] + " ");
                    this.out.println(fArray[4] + " " + fArray[5] + " curveto");
                    this.cx = fArray[4];
                    this.cy = fArray[5];
                    break;
                }
                case 4: {
                    this.out.println("closepath");
                }
            }
            pathIterator.next();
        }
    }

    public void clip(Shape shape) {
        this.clipShape = shape;
        this.out.println("% clip INACTIVE");
    }

    public void draw(Shape shape) {
        if (!(this.currentStroke instanceof BasicStroke)) {
            this.fill(this.currentStroke.createStrokedShape(shape));
        }
        this.out.println("% draw");
        this.writeShape(shape);
        this.out.println("stroke");
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.out.println("% drawGlyphVector");
        Shape shape = glyphVector.getOutline();
        this.drawStringShape(AffineTransform.getTranslateInstance(f, f2).createTransformedShape(shape));
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(f, f2));
        this.drawStringShape(shape);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void fill(Shape shape) {
        this.out.println("% fill");
        if (!this.gradientOn) {
            this.writeShape(shape);
            this.out.println("fill");
        } else {
            this.out.println("gsave");
            this.writeShape(shape);
            this.out.println("clip");
            this.writeGradient();
            this.out.println("shfill");
            this.out.println("grestore");
        }
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Composite getComposite() {
        return null;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.out.println("% getDeviceConfiguration()");
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        this.out.println("% getFontRenderContext()");
        double[] dArray = new double[]{this.pageTransform.getScaleX(), 0.0, 0.0, -this.pageTransform.getScaleY(), 0.0, 0.0};
        return new FontRenderContext(new AffineTransform(dArray), false, true);
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public AffineTransform getTransform() {
        return this.currentTransform;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        return shape.intersects(double_);
    }

    public void setBackground(Color color) {
        this.out.println("% setBackground(" + color + ")");
        this.backgroundColor = color;
    }

    public void setComposite(Composite composite) {
    }

    public void setPaint(Paint paint) {
        this.currentPaint = paint;
        this.gradientOn = false;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (paint instanceof GradientPaint) {
            this.gradientOn = true;
            return;
        }
    }

    private String colorTriple(Color color) {
        return (double)color.getRed() / 255.0 + " " + (double)color.getGreen() / 255.0 + " " + (double)color.getBlue() / 255.0;
    }

    private String colorTripleHex(Color color) {
        String string = "00" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "00" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "00" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        return string + string2 + string3;
    }

    private void writeGradient() {
        GradientPaint gradientPaint = (GradientPaint)this.currentPaint;
        this.out.println("% writeGradient()");
        int n = 1;
        Point2D point2D = this.currentTransform.transform(gradientPaint.getPoint1(), null);
        Point2D point2D2 = this.currentTransform.transform(gradientPaint.getPoint2(), null);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX() - d;
        double d4 = point2D2.getY() - d2;
        while (d + (double)n * d3 < this.pageY && d2 + (double)n * d4 < this.pageX && d + (double)n * d3 > 0.0 && d2 + (double)n * d4 > 0.0) {
            ++n;
        }
        this.out.println("<<");
        this.out.println("/ShadingType 2");
        this.out.println("/ColorSpace [ /DeviceRGB ]");
        this.out.print("/Coords [");
        this.out.print(d + " " + d2 + " " + (d + (double)n * d3) + " " + (d2 + (double)n * d4) + " ");
        this.out.println("]");
        this.out.println("/Function <<");
        this.out.println("/FunctionType 0");
        this.out.println("/Order 1");
        this.out.println("/Domain [ 0 1 ]");
        this.out.println("/Range [ 0 1  0 1  0 1 ]");
        this.out.println("/BitsPerSample 8");
        this.out.println("/Size [ " + (1 + n) + " ]");
        this.out.print("/DataSource < " + this.colorTripleHex(gradientPaint.getColor1()) + " " + this.colorTripleHex(gradientPaint.getColor2()) + " ");
        while (n > 1) {
            if (gradientPaint.isCyclic()) {
                if (n % 2 == 1) {
                    this.out.print(this.colorTripleHex(gradientPaint.getColor1()) + " ");
                } else {
                    this.out.print(this.colorTripleHex(gradientPaint.getColor2()) + " ");
                }
            } else {
                this.out.print(this.colorTripleHex(gradientPaint.getColor2()) + " ");
            }
            --n;
        }
        this.out.println(">");
        this.out.println(">>");
        this.out.println(">>");
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
    }

    public void setRenderingHints(Map map) {
    }

    public void setStroke(Stroke stroke) {
        this.currentStroke = stroke;
        if (!(stroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke basicStroke = (BasicStroke)stroke;
        this.out.println("% setStroke()");
        try {
            this.out.println(basicStroke.getLineWidth() + " setlinewidth");
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                this.out.print("[ ");
                for (int i = 0; i < fArray.length; ++i) {
                    this.out.print(fArray[i] + " ");
                }
                this.out.println("] " + basicStroke.getDashPhase() + " setdash");
            } else {
                this.out.println("[] 0 setdash");
            }
            switch (basicStroke.getEndCap()) {
                case 0: {
                    this.out.println("0 setlinecap");
                    break;
                }
                case 1: {
                    this.out.println("1 setlinecap");
                    break;
                }
                case 2: {
                    this.out.println("2 setlinecap");
                }
            }
            switch (basicStroke.getLineJoin()) {
                case 2: {
                    this.out.println("2 setlinejoin");
                    break;
                }
                case 0: {
                    this.out.println("0 setlinejoin");
                    this.out.println(basicStroke.getMiterLimit() + " setmiterlimit");
                    break;
                }
                case 1: {
                    this.out.println("1 setlinejoin");
                }
            }
        }
        catch (Exception exception) {
            this.out.println("% Exception in setStroke()");
        }
    }

    private void concatCTM(AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.out.print("[ ");
        for (int i = 0; i < 6; ++i) {
            this.out.print(dArray[i] + " ");
        }
        this.out.println("] concat");
    }

    public void setTransform(AffineTransform affineTransform) {
        this.currentTransform = affineTransform;
        AffineTransform affineTransform2 = new AffineTransform(this.pageTransform);
        affineTransform2.concatenate(this.currentTransform);
        this.out.println("% setTransform()");
        this.out.println("% pageTransform:" + this.pageTransform);
        this.out.println("% currentTransform:" + this.currentTransform);
        this.out.println("% totalTransform:" + affineTransform2);
        this.popCTM();
        this.pushCTM();
        this.concatCTM(affineTransform2);
    }

    public void transform(AffineTransform affineTransform) {
        this.currentTransform.concatenate(affineTransform);
        this.concatCTM(affineTransform);
    }

    public void shear(double d, double d2) {
        this.out.println("% shear()");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.shear(d, d2);
        this.transform(affineTransform);
    }

    public void translate(int n, int n2) {
        this.out.println("% translate()");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        this.transform(affineTransform);
    }

    public void translate(double d, double d2) {
        this.out.println("% translate(" + d + ", " + d2 + ")");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d, d2);
        this.transform(affineTransform);
    }

    public void rotate(double d) {
        this.out.println("% rotate(" + d + ")");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d);
        this.transform(affineTransform);
    }

    public void rotate(double d, double d2, double d3) {
        this.out.println("% rotate()");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(d, d2, d3);
        this.transform(affineTransform);
    }

    public void scale(double d, double d2) {
        this.out.println("% scale(" + d + ", " + d2 + ")");
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        this.transform(affineTransform);
    }
}

