/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LabelPeer;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SwingLabelPeer
extends SwingComponentPeer
implements LabelPeer {
    public SwingLabelPeer(Label label) {
        SwingLabel swingLabel = new SwingLabel(label);
        swingLabel.setText(label.getText());
        swingLabel.setOpaque(true);
        this.init(label, swingLabel);
        this.setAlignment(label.getAlignment());
    }

    public void setText(String string) {
        ((JLabel)this.swingComponent.getJComponent()).setText(string);
    }

    public void setAlignment(int n) {
        JLabel jLabel = (JLabel)this.swingComponent.getJComponent();
        switch (n) {
            case 2: {
                jLabel.setHorizontalAlignment(4);
                break;
            }
            case 1: {
                jLabel.setHorizontalAlignment(0);
                break;
            }
            default: {
                jLabel.setHorizontalAlignment(2);
            }
        }
    }

    private class SwingLabel
    extends JLabel
    implements SwingComponent {
        Label label;

        SwingLabel(Label label) {
            this.label = label;
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void handleMouseMotionEvent(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        public void handleKeyEvent(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
        }

        public void handleFocusEvent(FocusEvent focusEvent) {
            this.processFocusEvent(focusEvent);
        }

        public Point getLocationOnScreen() {
            return SwingLabelPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean bl = false;
            if (this.label != null) {
                bl = this.label.isShowing();
            }
            return bl;
        }

        public Image createImage(int n, int n2) {
            return SwingLabelPeer.this.createImage(n, n2);
        }

        public Graphics getGraphics() {
            return SwingLabelPeer.this.getGraphics();
        }

        public Container getParent() {
            Container container = null;
            if (this.label != null) {
                container = this.label.getParent();
            }
            return container;
        }
    }
}

