/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingContainerPeer;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import sun.awt.CausedFocusEvent;

public class SwingComponentPeer
implements ComponentPeer {
    protected Component awtComponent;
    protected SwingComponent swingComponent;
    protected Font peerFont;
    protected Rectangle paintArea;

    protected SwingComponentPeer() {
    }

    protected void init(Component component, SwingComponent swingComponent) {
        Component component2;
        this.awtComponent = component;
        this.swingComponent = swingComponent;
        if (this.swingComponent != null && (component2 = this.swingComponent.getJComponent()) != null) {
            ((JComponent)component2).addNotify();
            RepaintManager.currentManager((JComponent)component2).setDoubleBufferingEnabled(false);
            System.setProperty("gnu.awt.swing.doublebuffering", "true");
        }
        if (!(this instanceof LightweightPeer)) {
            component2 = this.awtComponent;
            Container container = component2.getParent();
            while (container != null && !(container.getPeer() instanceof SwingContainerPeer)) {
                component2 = container;
                container = component2.getParent();
            }
            if (container != null && container.getPeer() instanceof SwingContainerPeer) {
                SwingContainerPeer swingContainerPeer = (SwingContainerPeer)container.getPeer();
                swingContainerPeer.addHeavyweightDescendent(this.awtComponent);
            }
        }
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return Toolkit.getDefaultToolkit().checkImage(image, n, n2, imageObserver);
    }

    public Image createImage(ImageProducer imageProducer) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        return image;
    }

    public Image createImage(int n, int n2) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.createImage(n, n2);
    }

    public void disable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(false);
        }
    }

    public void dispose() {
        if (!(this instanceof LightweightPeer)) {
            Component component = this.awtComponent;
            Container container = component.getParent();
            while (container != null && !(container.getPeer() instanceof SwingContainerPeer)) {
                component = container;
                container = component.getParent();
            }
            if (container != null && container.getPeer() instanceof SwingContainerPeer) {
                SwingContainerPeer swingContainerPeer = (SwingContainerPeer)container.getPeer();
                swingContainerPeer.removeHeavyweightDescendent(this.awtComponent);
            }
        }
        this.awtComponent = null;
        this.swingComponent = null;
    }

    public void enable() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(true);
        }
    }

    public ColorModel getColorModel() {
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getFontMetrics(font);
    }

    public Graphics getGraphics() {
        Container container = this.awtComponent.getParent();
        Graphics graphics = container.getGraphics();
        graphics.translate(this.awtComponent.getX(), this.awtComponent.getY());
        graphics.setClip(0, 0, this.awtComponent.getWidth(), this.awtComponent.getHeight());
        return graphics;
    }

    public Point getLocationOnScreen() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        Point point = componentPeer.getLocationOnScreen();
        point.x += this.awtComponent.getX();
        point.y += this.awtComponent.getY();
        return point;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 800: 
            case 801: {
                Rectangle rectangle;
                if (!this.awtComponent.isShowing()) break;
                Object object = this;
                synchronized (object) {
                    this.coalescePaintEvent((PaintEvent)aWTEvent);
                    assert (this.paintArea != null);
                    rectangle = this.paintArea;
                    this.paintArea = null;
                }
                object = this.awtComponent.getGraphics();
                try {
                    ((Graphics)object).clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    this.peerPaint((Graphics)object, aWTEvent.getID() == 801);
                    Object var6_5 = null;
                    ((Graphics)object).dispose();
                    break;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    ((Graphics)object).dispose();
                    throw throwable;
                }
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                this.handleMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 503: 
            case 506: {
                this.handleMouseMotionEvent((MouseEvent)aWTEvent);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.handleKeyEvent((KeyEvent)aWTEvent);
                break;
            }
            case 1004: 
            case 1005: {
                this.handleFocusEvent((FocusEvent)aWTEvent);
                break;
            }
        }
    }

    public void hide() {
        Container container;
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(false);
        }
        if ((container = this.awtComponent.getParent()) != null) {
            container.repaint(this.awtComponent.getX(), this.awtComponent.getY(), this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
    }

    public boolean isFocusTraversable() {
        return this.swingComponent != null ? this.swingComponent.getJComponent().isFocusable() : false;
    }

    public boolean isFocusable() {
        return this.swingComponent != null ? this.swingComponent.getJComponent().isFocusable() : false;
    }

    public Dimension minimumSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getMinimumSize() : new Dimension(0, 0);
        return dimension;
    }

    public Dimension preferredSize() {
        Dimension dimension = this.swingComponent != null ? this.swingComponent.getJComponent().getPreferredSize() : new Dimension(0, 0);
        return dimension;
    }

    public void paint(Graphics graphics) {
        this.peerPaint(graphics, false);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        Container container = this.awtComponent.getParent();
        if (container != null) {
            ComponentPeer componentPeer = container.getPeer();
            return componentPeer.prepareImage(image, n, n2, imageObserver);
        }
        return Toolkit.getDefaultToolkit().prepareImage(image, n, n2, imageObserver);
    }

    public void print(Graphics graphics) {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().repaint(l, n, n2, n3, n4);
        } else {
            PaintEvent paintEvent = new PaintEvent(this.awtComponent, 801, new Rectangle(n, n2, n3, n4));
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(paintEvent);
        }
    }

    public void requestFocus() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        eventQueue.postEvent(new FocusEvent(this.awtComponent, 1004, false));
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        EventQueue eventQueue = toolkit.getSystemEventQueue();
        eventQueue.postEvent(new FocusEvent(component, 1004, bl));
        return true;
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
        }
    }

    public void setBackground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBackground(color);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setCursor(Cursor cursor) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setCursor(cursor);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setEnabled(bl);
        }
    }

    public void setFont(Font font) {
        this.peerFont = font;
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setForeground(color);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setVisible(true);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getGraphicsConfiguration();
    }

    public void setEventMask(long l) {
    }

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void coalescePaintEvent(PaintEvent paintEvent) {
        SwingComponentPeer swingComponentPeer = this;
        synchronized (swingComponentPeer) {
            Rectangle rectangle = paintEvent.getUpdateRect();
            if (this.paintArea == null) {
                this.paintArea = rectangle;
            } else {
                Rectangle.union(this.paintArea, rectangle, this.paintArea);
            }
        }
    }

    public void updateCursorImmediately() {
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public VolatileImage createVolatileImage(int n, int n2) {
        Container container = this.awtComponent.getParent();
        VolatileImage volatileImage = null;
        if (container != null) {
            ComponentPeer componentPeer = container.getPeer();
            volatileImage = componentPeer.createVolatileImage(n, n2);
        }
        return volatileImage;
    }

    public void createBuffers(int n, BufferCapabilities bufferCapabilities) throws AWTException {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.createBuffers(n, bufferCapabilities);
    }

    public Image getBackBuffer() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        return componentPeer.getBackBuffer();
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.flip(flipContents);
    }

    public void destroyBuffers() {
        Container container = this.awtComponent.getParent();
        ComponentPeer componentPeer = container.getPeer();
        componentPeer.destroyBuffers();
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this.swingComponent != null ? this.swingComponent.getJComponent().getBounds() : new Rectangle();
        return rectangle;
    }

    public void reparent(ContainerPeer containerPeer) {
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(n, n2, n3, n4);
        }
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void layout() {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().doLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void peerPaint(Graphics graphics, boolean bl) {
        this.peerPaintComponent(graphics);
        Graphics graphics2 = graphics.create();
        try {
            if (bl) {
                this.awtComponent.update(graphics2);
            } else {
                this.awtComponent.paint(graphics2);
            }
            Object var5_4 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    protected void peerPaintComponent(Graphics graphics) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().paint(graphics);
        }
    }

    protected void handleMouseEvent(MouseEvent mouseEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseEvent(mouseEvent);
        }
    }

    protected void handleMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleMouseMotionEvent(mouseEvent);
        }
    }

    protected void handleKeyEvent(KeyEvent keyEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleKeyEvent(keyEvent);
        }
    }

    protected void handleFocusEvent(FocusEvent focusEvent) {
        if (this.swingComponent != null) {
            this.swingComponent.handleFocusEvent(focusEvent);
        }
    }

    public Component getComponent() {
        return this.awtComponent;
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l, CausedFocusEvent.Cause cause) {
        return true;
    }
}

