/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtImageGraphics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.VolatileImage;
import java.util.Hashtable;
import java.util.WeakHashMap;

public class QtVolatileImage
extends VolatileImage {
    int width = -1;
    int height = -1;
    Hashtable props;
    long nativeObject;
    static ColorModel nativeModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    WeakHashMap painters;
    boolean killFlag;

    public native void clear();

    private native int[] getPixels();

    private native void createImage();

    private native void freeImage();

    public native void blit(QtImage var1);

    public native void blit(QtImage var1, int var2, int var3, int var4, int var5);

    private native void createScaledImage(QtVolatileImage var1, int var2);

    private native void drawPixels(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private native void drawPixelsScaled(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void drawPixelsTransformed(QtGraphics var1, QMatrix var2);

    native void drawPixelsScaledFlipped(QtGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    public QtVolatileImage(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.createImage();
        this.clear();
    }

    private QtVolatileImage(QtVolatileImage qtVolatileImage, int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.createScaledImage(qtVolatileImage, n3);
    }

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.painters == null || this.painters.isEmpty()) {
            this.freeImage();
        } else {
            this.killFlag = true;
        }
    }

    public int getWidth(ImageObserver imageObserver) {
        return this.getWidth();
    }

    public int getHeight(ImageObserver imageObserver) {
        return this.getHeight();
    }

    public Object getProperty(String string, ImageObserver imageObserver) {
        Object v = this.props.get(string);
        return v == null ? UndefinedProperty : v;
    }

    public ImageProducer getSource() {
        return new MemoryImageSource(this.width, this.height, nativeModel, this.getPixels(), 0, this.width);
    }

    void putPainter(QtImageGraphics qtImageGraphics) {
        if (this.painters == null) {
            this.painters = new WeakHashMap();
        }
        this.painters.put(qtImageGraphics, "dummy");
    }

    void removePainter(QtImageGraphics qtImageGraphics) {
        this.painters.remove(qtImageGraphics);
        if (this.killFlag && this.painters.isEmpty()) {
            this.freeImage();
        }
    }

    public Graphics getGraphics() {
        QtImageGraphics qtImageGraphics = new QtImageGraphics(this);
        this.putPainter(qtImageGraphics);
        return qtImageGraphics;
    }

    public Image getScaledInstance(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new QtVolatileImage(this, n, n2, n3);
    }

    public void flush() {
    }

    public int checkImage(ImageObserver imageObserver) {
        return 35;
    }

    public boolean drawImage(QtGraphics qtGraphics, QMatrix qMatrix, ImageObserver imageObserver) {
        this.drawPixelsTransformed(qtGraphics, qMatrix);
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, Color color, ImageObserver imageObserver) {
        if (color != null) {
            this.drawPixels(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), n, n2, true);
        } else {
            this.drawPixels(qtGraphics, 0, 0, 0, n, n2, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (color != null) {
            this.drawPixelsScaled(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), n, n2, n3, n4, true);
        } else {
            this.drawPixelsScaled(qtGraphics, 0, 0, 0, n, n2, n3, n4, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics qtGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        boolean bl = n > n3 ^ n5 > n7;
        boolean bl2 = n2 > n4 ^ n6 > n8;
        int n10 = Math.abs(n3 - n);
        int n11 = Math.abs(n4 - n2);
        int n12 = Math.abs(n7 - n5);
        int n13 = Math.abs(n8 - n6);
        int n14 = n5 < n7 ? n5 : n7;
        int n15 = n6 < n8 ? n6 : n8;
        int n16 = n < n3 ? n : n3;
        int n17 = n9 = n2 < n4 ? n2 : n4;
        if (n12 > this.width) {
            n10 = (int)((double)n10 * ((double)this.width / (double)n12));
            n12 = this.width - n14;
        }
        if (n13 > this.height) {
            n11 = (int)((double)n11 * ((double)this.height / (double)n13));
            n13 = this.height - n15;
        }
        if (n12 + n14 > this.width) {
            n10 = (int)((double)n10 * (double)(this.width - n14) / (double)n12);
            n12 = this.width - n14;
        }
        if (n13 + n15 > this.height) {
            n11 = (int)((double)n11 * (double)(this.width - n15) / (double)n13);
            n13 = this.height - n15;
        }
        if (n12 <= 0 || n13 <= 0 || n10 <= 0 || n11 <= 0) {
            return true;
        }
        if (color != null) {
            this.drawPixelsScaledFlipped(qtGraphics, color.getRed(), color.getGreen(), color.getBlue(), bl, bl2, n14, n15, n12, n13, n16, n9, n10, n11, true);
        } else {
            this.drawPixelsScaledFlipped(qtGraphics, 0, 0, 0, bl, bl2, n14, n15, n12, n13, n16, n9, n10, n11, false);
        }
        return true;
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public boolean contentsLost() {
        return false;
    }

    public Graphics2D createGraphics() {
        QtImageGraphics qtImageGraphics = new QtImageGraphics(this);
        this.putPainter(qtImageGraphics);
        return qtImageGraphics;
    }

    public ImageCapabilities getCapabilities() {
        return new ImageCapabilities(false){

            public boolean isTrueVolatile() {
                return false;
            }
        };
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getSnapshot() {
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 3);
        bufferedImage.setRGB(0, 0, this.width, this.height, this.getPixels(), 0, this.width);
        return bufferedImage;
    }

    public int getWidth() {
        return this.width;
    }

    public int validate(GraphicsConfiguration graphicsConfiguration) {
        return 0;
    }
}

