/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ComponentReshapeEvent;
import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;

public class GtkWindowPeer
extends GtkContainerPeer
implements WindowPeer {
    protected static final int GDK_WINDOW_TYPE_HINT_NORMAL = 0;
    protected static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
    protected static final int GDK_WINDOW_TYPE_HINT_MENU = 2;
    protected static final int GDK_WINDOW_TYPE_HINT_TOOLBAR = 3;
    protected static final int GDK_WINDOW_TYPE_HINT_SPLASHSCREEN = 4;
    protected static final int GDK_WINDOW_TYPE_HINT_UTILITY = 5;
    protected static final int GDK_WINDOW_TYPE_HINT_DOCK = 6;
    protected static final int GDK_WINDOW_TYPE_HINT_DESKTOP = 7;
    protected int windowState = 0;
    private int x;
    private int y;
    private int width;
    private int height;

    native void gtkWindowSetTitle(String var1);

    native void gtkWindowSetResizable(boolean var1);

    native void gtkWindowSetModal(boolean var1);

    native void gtkWindowSetAlwaysOnTop(boolean var1);

    native boolean gtkWindowHasFocus();

    native void realize();

    public void dispose() {
        super.dispose();
        GtkMainThread.destroyWindow();
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWidth() {
        return this.width;
    }

    int getHeight() {
        return this.height;
    }

    native void create(int var1, boolean var2, GtkWindowPeer var3);

    void create(int n, boolean bl) {
        Window window = (Window)this.awtComponent;
        GtkWindowPeer gtkWindowPeer = null;
        Container container = this.awtComponent.getParent();
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.height = this.awtComponent.getHeight();
        this.width = this.awtComponent.getWidth();
        if (!window.isFocusableWindow()) {
            n = 2;
        }
        if (container != null) {
            gtkWindowPeer = (GtkWindowPeer)this.awtComponent.getParent().getPeer();
        }
        this.create(n, bl, gtkWindowPeer);
    }

    void create() {
        this.create(0, false);
    }

    void setParent() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    void setVisibleAndEnabled() {
    }

    public native void setVisibleNative(boolean var1);

    public native void setVisibleNativeUnlocked(boolean var1);

    native void connectSignals();

    public GtkWindowPeer(Window window) {
        super(window);
        window.setFont(new Font("Dialog", 0, 12));
    }

    public native void toBack();

    public native void toFront();

    native void nativeSetBounds(int var1, int var2, int var3, int var4);

    native void nativeSetBoundsUnlocked(int var1, int var2, int var3, int var4);

    native void nativeSetLocation(int var1, int var2);

    native void nativeSetLocationUnlocked(int var1, int var2);

    protected void setLocation(int n, int n2) {
        this.nativeSetLocation(n, n2);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n != this.getX() || n2 != this.getY() || n3 != this.getWidth() || n4 != this.getHeight()) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
            this.nativeSetBounds(n, n2, n3 - this.insets.left - this.insets.right, n4 - this.insets.top - this.insets.bottom);
        }
    }

    public void setTitle(String string) {
        this.gtkWindowSetTitle(string);
    }

    protected native void setSize(int var1, int var2);

    public void setResizable(boolean bl) {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setSize(this.width - this.insets.left - this.insets.right, this.height - this.insets.top - this.insets.bottom);
        this.gtkWindowSetResizable(bl);
    }

    protected void postInsetsChangedEvent(int n, int n2, int n3, int n4) {
        this.insets.top = n;
        this.insets.left = n2;
        this.insets.bottom = n3;
        this.insets.right = n4;
    }

    protected void postConfigureEvent(int n, int n2, int n3, int n4) {
        int n5 = n - this.insets.left;
        int n6 = n2 - this.insets.top;
        int n7 = n3 + this.insets.left + this.insets.right;
        int n8 = n4 + this.insets.top + this.insets.bottom;
        if (n5 != this.x || n6 != this.y || n7 != this.width || n8 != this.height) {
            ComponentReshapeEvent componentReshapeEvent = new ComponentReshapeEvent(this.awtComponent, n5, n6, n7, n8);
            this.awtComponent.dispatchEvent(componentReshapeEvent);
        }
        if (n7 != this.getWidth() || n8 != this.getHeight()) {
            this.width = n7;
            this.height = n8;
            GtkWindowPeer.q().postEvent(new ComponentEvent(this.awtComponent, 101));
        }
        if (n5 != this.getX() || n6 != this.getY()) {
            this.x = n5;
            this.y = n6;
            GtkWindowPeer.q().postEvent(new ComponentEvent(this.awtComponent, 100));
        }
    }

    public void show() {
        this.x = this.awtComponent.getX();
        this.y = this.awtComponent.getY();
        this.width = this.awtComponent.getWidth();
        this.height = this.awtComponent.getHeight();
        this.setLocation(this.x, this.y);
        this.setVisible(true);
    }

    void postWindowEvent(int n, Window window, int n2) {
        if (n == 209) {
            if (this.windowState != n2) {
                if ((this.windowState & 1) != 0 && (n2 & 1) == 0) {
                    GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, 204, window, 0, 0));
                } else if ((this.windowState & 1) == 0 && (n2 & 1) != 0) {
                    GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, 203, window, 0, 0));
                }
                GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, n, window, this.windowState, n2));
                this.windowState = n2;
            }
        } else {
            GtkWindowPeer.q().postEvent(new WindowEvent((Window)this.awtComponent, n, window));
        }
    }

    public void updateAlwaysOnTop() {
        this.gtkWindowSetAlwaysOnTop(((Window)this.awtComponent).isAlwaysOnTop());
    }

    protected void postExposeEvent(int n, int n2, int n3, int n4) {
        GtkWindowPeer.q().postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(n + this.insets.left, n2 + this.insets.top, n3, n4)));
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        assert (component == this.awtComponent || this.isLightweightDescendant(component));
        boolean bl3 = false;
        if (this.gtkWindowHasFocus()) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component2 = keyboardFocusManager.getFocusOwner();
            if (component2 == component) {
                bl3 = true;
            } else {
                this.postFocusEvent(1004, bl);
                bl3 = true;
            }
        } else if (bl2) {
            bl3 = this.requestWindowFocus();
        }
        return bl3;
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        graphics.translate(-this.insets.left, -this.insets.top);
        return graphics;
    }

    protected void postMouseEvent(int n, long l, int n2, int n3, int n4, int n5, boolean bl) {
        super.postMouseEvent(n, l, n2, n3 + this.insets.left, n4 + this.insets.top, n5, bl);
    }

    public Point getLocationOnScreen() {
        int[] nArray = new int[2];
        if (Thread.currentThread() == GtkMainThread.mainThread) {
            this.gtkWindowGetLocationOnScreenUnlocked(nArray);
        } else {
            this.gtkWindowGetLocationOnScreen(nArray);
        }
        return new Point(nArray[0], nArray[1]);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void updateIconImages() {
    }

    public void updateMinimumSize() {
    }

    public void setModalBlocked(Dialog dialog, boolean bl) {
    }

    public void updateFocusableWindowState() {
    }

    public void setAlwaysOnTop(boolean bl) {
    }
}

