/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkImageConsumer;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkImage
extends Image {
    int width = -1;
    int height = -1;
    Hashtable<?, ?> props;
    boolean isLoaded;
    Pointer pixbuf;
    Vector<ImageObserver> observers;
    boolean errorLoading;
    ImageProducer source;
    static ColorModel nativeModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    private static GtkImage errorImage;
    static Object pixbufLock;

    private native void initFromBuffer(long var1);

    native int[] getPixels();

    private native void setPixels(int[] var1);

    private native boolean loadPixbuf(String var1);

    private native boolean loadImageFromData(byte[] var1);

    private native void createPixbuf();

    private native void freePixbuf();

    private native void createScaledPixbuf(GtkImage var1, int var2);

    public GtkImage(ImageProducer imageProducer) {
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = imageProducer;
        this.errorLoading = false;
        this.source.startProduction(new GtkImageConsumer(this, this.source));
    }

    public GtkImage() {
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(String string) {
        File file = new File(string);
        try {
            String string2 = file.getCanonicalPath();
            Object object = pixbufLock;
            synchronized (object) {
                if (!this.loadPixbuf(file.getCanonicalPath())) {
                    throw new IllegalArgumentException("Couldn't load image: " + string);
                }
            }
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Couldn't load image: " + string);
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(byte[] byArray) {
        Object object = pixbufLock;
        synchronized (object) {
            if (!this.loadImageFromData(byArray)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(URL uRL) {
        Object object;
        Object object2;
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (uRL == null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(5000);
        try {
            object2 = new BufferedInputStream(uRL.openStream());
            object = new byte[5000];
            int n = 0;
            while ((n = ((FilterInputStream)object2).read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n);
            }
            ((BufferedInputStream)object2).close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        object2 = byteArrayOutputStream.toByteArray();
        Object object3 = pixbufLock;
        object = object3;
        synchronized (object3) {
            if (!this.loadImageFromData((byte[])object2)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
            // ** MonitorExit[var4_5 /* !! */ ] (shouldn't be in output)
            this.isLoaded = true;
            this.observers = null;
            this.props = new Hashtable();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GtkImage(GtkImage gtkImage, int n, int n2, int n3) {
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        Object object = pixbufLock;
        synchronized (object) {
            this.createScaledPixbuf(gtkImage, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GtkImage(Pointer pointer) {
        this.pixbuf = pointer;
        Object object = pixbufLock;
        synchronized (object) {
            this.createFromPixbuf();
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    GtkImage(int n, int n2, long l) {
        this.width = n;
        this.height = n2;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.initFromBuffer(l);
    }

    static synchronized GtkImage getErrorImage() {
        if (errorImage == null) {
            errorImage = new GtkImage();
            GtkImage.errorImage.errorLoading = true;
        }
        return errorImage;
    }

    private native void createFromPixbuf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(int n, int n2, int[] nArray, Hashtable<?, ?> hashtable) {
        this.width = n;
        this.height = n2;
        Hashtable hashtable2 = this.props = hashtable != null ? hashtable : new Hashtable();
        if (n <= 0 || n2 <= 0 || nArray == null) {
            this.errorLoading = true;
            return;
        }
        Object object = pixbufLock;
        synchronized (object) {
            this.createPixbuf();
            this.setPixels(nArray);
        }
        this.isLoaded = true;
        this.deliver();
    }

    @Override
    public synchronized int getWidth(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.width;
    }

    @Override
    public synchronized int getHeight(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return -1;
        }
        return this.height;
    }

    @Override
    public synchronized Object getProperty(String string, ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            return UndefinedProperty;
        }
        Object obj = this.props.get(string);
        return obj == null ? UndefinedProperty : obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageProducer getSource() {
        int[] nArray;
        if (!this.isLoaded) {
            return null;
        }
        Object object = pixbufLock;
        synchronized (object) {
            if (this.errorLoading) {
                return null;
            }
            nArray = this.getPixels();
        }
        return new MemoryImageSource(this.width, this.height, nativeModel, nArray, 0, this.width);
    }

    @Override
    public Graphics getGraphics() {
        throw new IllegalAccessError("This method only works for off-screen Images.");
    }

    @Override
    public Image getScaledInstance(int n, int n2, int n3) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new GtkImage(this, n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        if (this.isLoaded && this.source != null) {
            this.observers = new Vector();
            this.isLoaded = false;
            Object object = pixbufLock;
            synchronized (object) {
                this.freePixbuf();
            }
            this.source.startProduction(new GtkImageConsumer(this, this.source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        if (this.isLoaded) {
            Object object = pixbufLock;
            synchronized (object) {
                this.freePixbuf();
            }
        }
    }

    public int checkImage(ImageObserver imageObserver) {
        if (this.addObserver(imageObserver)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    private void deliver() {
        int n = 39;
        if (this.observers != null) {
            for (int i = 0; i < this.observers.size(); ++i) {
                this.observers.elementAt(i).imageUpdate(this, n, 0, 0, this.width, this.height);
            }
        }
        this.observers = null;
    }

    private boolean addObserver(ImageObserver imageObserver) {
        if (!this.isLoaded) {
            if (imageObserver != null && !this.observers.contains(imageObserver)) {
                this.observers.addElement(imageObserver);
            }
            return true;
        }
        return false;
    }

    static {
        pixbufLock = new Object();
    }
}

