/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.peer.FramePeer;
import java.awt.peer.MenuBarPeer;

public class GtkFramePeer
extends GtkWindowPeer
implements FramePeer {
    private int menuBarHeight;
    private MenuBarPeer menuBar;

    native int getMenuBarHeight(MenuBarPeer var1);

    native void setMenuBarWidthUnlocked(MenuBarPeer var1, int var2);

    native void setMenuBarWidth(MenuBarPeer var1, int var2);

    native void setMenuBarPeer(MenuBarPeer var1);

    native void removeMenuBarPeer();

    native void gtkFixedSetVisible(boolean var1);

    private native void maximize();

    private native void unmaximize();

    private native void iconify();

    private native void deiconify();

    int getMenuBarHeight() {
        return this.menuBar == null ? 0 : this.getMenuBarHeight(this.menuBar);
    }

    public void setMenuBar(MenuBar menuBar) {
        if (menuBar == null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = null;
            this.removeMenuBarPeer();
            this.insets.top -= this.menuBarHeight;
            this.menuBarHeight = 0;
            if (this.awtComponent.isValid()) {
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        } else if (menuBar != null && this.menuBar == null) {
            this.gtkFixedSetVisible(false);
            this.menuBar = (MenuBarPeer)menuBar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            int n = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            if (n > 0) {
                this.setMenuBarWidth(this.menuBar, n);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            this.insets.top += this.menuBarHeight;
            if (this.awtComponent.isValid()) {
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        } else if (menuBar != null && this.menuBar != null) {
            this.gtkFixedSetVisible(false);
            this.removeMenuBarPeer();
            int n = this.menuBarHeight;
            int n2 = this.awtComponent.getWidth() - this.insets.left - this.insets.right;
            this.menuBar = (MenuBarPeer)menuBar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            if (n2 > 0) {
                this.setMenuBarWidth(this.menuBar, n2);
            }
            this.menuBarHeight = this.getMenuBarHeight();
            if (n != this.menuBarHeight) {
                this.insets.top += this.menuBarHeight - n;
                this.awtComponent.validate();
            }
            this.gtkFixedSetVisible(true);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = n3 - this.insets.left - this.insets.right;
        if (this.menuBar != null && n5 > 0) {
            this.setMenuBarWidth(this.menuBar, n5);
        }
        super.setBounds(n, n2, n3, n4 + this.menuBarHeight);
    }

    public void setResizable(boolean bl) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom + this.menuBarHeight);
        this.gtkWindowSetResizable(bl);
    }

    protected void postInsetsChangedEvent(int n, int n2, int n3, int n4) {
        this.insets.top = n + this.menuBarHeight;
        this.insets.left = n2;
        this.insets.bottom = n3;
        this.insets.right = n4;
    }

    public GtkFramePeer(Frame frame) {
        super(frame);
    }

    void create() {
        this.create(0, !((Frame)this.awtComponent).isUndecorated());
        Frame frame = (Frame)this.awtComponent;
        this.setMenuBar(frame.getMenuBar());
        this.setTitle(frame.getTitle());
        this.gtkWindowSetResizable(frame.isResizable());
        this.setIconImage(frame.getIconImage());
    }

    native void nativeSetIconImage(GtkImage var1);

    public void setIconImage(Image image) {
        if (image != null) {
            GtkImage gtkImage = image instanceof GtkImage ? (GtkImage)image : new GtkImage(image.getSource());
            if (gtkImage.isLoaded && !gtkImage.errorLoading) {
                this.nativeSetIconImage(gtkImage);
            }
        }
    }

    protected void postConfigureEvent(int n, int n2, int n3, int n4) {
        if (this.menuBar != null && n3 > 0) {
            this.setMenuBarWidthUnlocked(this.menuBar, n3);
        }
        int n5 = n4 - this.menuBarHeight;
        int n6 = n2 + this.menuBarHeight;
        super.postConfigureEvent(n, n6, n3, n5);
    }

    public int getState() {
        return this.windowState;
    }

    public void setState(int n) {
        switch (n) {
            case 0: {
                if ((this.windowState & 1) != 0) {
                    this.deiconify();
                }
                if ((this.windowState & 6) == 0) break;
                this.unmaximize();
                break;
            }
            case 1: {
                this.iconify();
                break;
            }
            case 6: {
                this.maximize();
            }
        }
    }

    public void setMaximizedBounds(Rectangle rectangle) {
    }

    public void setBoundsPrivate(int n, int n2, int n3, int n4) {
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public Rectangle getBoundsPrivate() {
        throw new InternalError("Not yet implemented");
    }
}

