/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GdkGraphicsConfiguration;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;

class GdkScreenGraphicsDevice
extends GraphicsDevice {
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private Window fullscreenWindow;
    private boolean oldWindowDecorationState;
    private Rectangle oldWindowBounds;
    private Rectangle bounds;
    private GdkGraphicsConfiguration[] configurations;
    GdkGraphicsEnvironment env;
    String idString;
    X11DisplayMode[] displayModes;
    DisplayMode fixedDisplayMode;
    private Pointer screen;

    static native void initIDs();

    GdkScreenGraphicsDevice(GdkGraphicsEnvironment gdkGraphicsEnvironment) {
        this.env = gdkGraphicsEnvironment;
        this.configurations = new GdkGraphicsConfiguration[1];
        this.configurations[0] = new GdkGraphicsConfiguration(this);
    }

    void init() {
        this.fixedDisplayMode = this.nativeGetFixedDisplayMode(this.env);
    }

    native DisplayMode nativeGetFixedDisplayMode(GdkGraphicsEnvironment var1);

    public int getType() {
        return 0;
    }

    public String getIDstring() {
        if (this.idString == null) {
            this.idString = this.nativeGetIDString();
        }
        return this.idString;
    }

    private native String nativeGetIDString();

    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configurations.clone();
    }

    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configurations[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode getDisplayMode() {
        if (this.fixedDisplayMode != null) {
            return this.fixedDisplayMode;
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        int n = this.nativeGetDisplayModeIndex(this.env);
        int n2 = this.nativeGetDisplayModeRate(this.env);
        return new DisplayMode(this.displayModes[n].width, this.displayModes[n].height, -1, n2);
    }

    native int nativeGetDisplayModeIndex(GdkGraphicsEnvironment var1);

    native int nativeGetDisplayModeRate(GdkGraphicsEnvironment var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayMode[] getDisplayModes() {
        if (this.fixedDisplayMode != null) {
            return new DisplayMode[]{this.fixedDisplayMode};
        }
        Object object = this;
        synchronized (object) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        object = new ArrayList();
        for (int i = 0; i < this.displayModes.length; ++i) {
            for (int j = 0; j < this.displayModes[i].rates.length; ++j) {
                ((ArrayList)object).add(new DisplayMode(this.displayModes[i].width, this.displayModes[i].height, -1, this.displayModes[i].rates[j]));
            }
        }
        return ((ArrayList)object).toArray(new DisplayMode[((ArrayList)object).size()]);
    }

    native X11DisplayMode[] nativeGetDisplayModes(GdkGraphicsEnvironment var1);

    public boolean isFullScreenSupported() {
        return true;
    }

    public boolean isDisplayChangeSupported() {
        return this.fixedDisplayMode == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMode(DisplayMode displayMode) {
        if (this.fixedDisplayMode != null) {
            throw new UnsupportedOperationException("Cannnot change display mode.");
        }
        if (displayMode == null) {
            throw new IllegalArgumentException("DisplayMode must not be null.");
        }
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.displayModes == null) {
                this.displayModes = this.nativeGetDisplayModes(this.env);
            }
        }
        for (int i = 0; i < this.displayModes.length; ++i) {
            if (this.displayModes[i].width != displayMode.getWidth() || this.displayModes[i].height != displayMode.getHeight()) continue;
            GdkScreenGraphicsDevice gdkScreenGraphicsDevice2 = this;
            synchronized (gdkScreenGraphicsDevice2) {
                this.nativeSetDisplayMode(this.env, i, (short)displayMode.getRefreshRate());
                this.bounds = null;
            }
            return;
        }
        throw new IllegalArgumentException("Mode not supported by this device.");
    }

    native void nativeSetDisplayMode(GdkGraphicsEnvironment var1, int var2, short var3);

    public void setFullScreenWindow(Window window) {
        Object object;
        if (this.fullscreenWindow != null && window != this.fullscreenWindow) {
            if (this.fullscreenWindow instanceof Frame && this.oldWindowDecorationState != ((Frame)(object = (Frame)this.fullscreenWindow)).isUndecorated()) {
                ((Window)object).dispose();
                ((Frame)object).setUndecorated(this.oldWindowDecorationState);
            }
            this.fullscreenWindow.setBounds(this.oldWindowBounds);
            if (!this.fullscreenWindow.isVisible()) {
                this.fullscreenWindow.setVisible(true);
            }
        }
        if (window != null) {
            if (window instanceof Frame) {
                object = (Frame)window;
                this.oldWindowDecorationState = ((Frame)object).isUndecorated();
                if (!this.oldWindowDecorationState) {
                    ((Window)object).dispose();
                    ((Frame)object).setUndecorated(true);
                }
            }
            this.oldWindowBounds = window.getBounds();
            object = this.getDisplayMode();
            window.setBounds(0, 0, ((DisplayMode)object).getWidth(), ((DisplayMode)object).getHeight());
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            window.requestFocus();
            window.toFront();
        }
        this.fullscreenWindow = window;
    }

    public Window getFullScreenWindow() {
        return this.fullscreenWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rectangle getBounds() {
        GdkScreenGraphicsDevice gdkScreenGraphicsDevice = this;
        synchronized (gdkScreenGraphicsDevice) {
            if (this.bounds == null) {
                this.bounds = this.nativeGetBounds();
            }
        }
        return this.bounds;
    }

    native Rectangle nativeGetBounds();

    static {
        System.loadLibrary("gtkpeer");
        GtkToolkit.initializeGlobalIDs();
        GdkScreenGraphicsDevice.initIDs();
    }

    static class X11DisplayMode {
        short[] rates;
        int width;
        int height;

        X11DisplayMode(int n, int n2, short[] sArray) {
            this.width = n;
            this.height = n2;
            this.rates = sArray;
        }
    }
}

