/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.image.ImageDecoder;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class GdkPixbufDecoder
extends ImageDecoder {
    static Object pixbufLock;
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private boolean needsClose = false;
    Vector curr;
    private Pointer nativeDecoder;
    static final ColorModel cm;
    static ArrayList<ImageFormatSpec> imageFormatSpecs;
    private static GdkPixbufReaderSpi readerSpi;
    private static GdkPixbufWriterSpi writerSpi;

    static native void initStaticState();

    native void initState();

    native void pumpBytes(byte[] var1, int var2) throws IOException;

    native void pumpDone() throws IOException;

    native void finish(boolean var1);

    static native void streamImage(int[] var0, String var1, int var2, int var3, boolean var4, GdkPixbufWriter var5);

    public GdkPixbufDecoder(DataInput dataInput) {
        super(dataInput);
    }

    public GdkPixbufDecoder(InputStream inputStream) {
        super(inputStream);
    }

    public GdkPixbufDecoder(String string) {
        super(string);
    }

    public GdkPixbufDecoder(URL uRL) {
        super(uRL);
    }

    public GdkPixbufDecoder(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
    }

    void areaPrepared(int n, int n2) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(i);
            imageConsumer.setDimensions(n, n2);
            imageConsumer.setColorModel(cm);
            imageConsumer.setHints(1);
        }
    }

    void areaUpdated(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(i);
            imageConsumer.setPixels(n, n2, n3, n4, cm, nArray, 0, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produce(Vector vector, InputStream inputStream) throws IOException {
        this.curr = vector;
        byte[] byArray = new byte[4096];
        int n = 0;
        Object object = pixbufLock;
        synchronized (object) {
            this.initState();
        }
        this.needsClose = true;
        while ((n = inputStream.read(byArray)) != -1) {
            object = pixbufLock;
            synchronized (object) {
                this.pumpBytes(byArray, n);
            }
        }
        object = pixbufLock;
        synchronized (object) {
            this.pumpDone();
        }
        this.needsClose = false;
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer imageConsumer = (ImageConsumer)this.curr.elementAt(i);
            imageConsumer.imageComplete(3);
        }
        this.curr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = pixbufLock;
        synchronized (object) {
            this.finish(this.needsClose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFormatSpec registerFormat(String string, boolean bl) {
        ImageFormatSpec imageFormatSpec = new ImageFormatSpec(string, bl);
        Class<GdkPixbufDecoder> clazz = GdkPixbufDecoder.class;
        synchronized (GdkPixbufDecoder.class) {
            if (imageFormatSpecs == null) {
                imageFormatSpecs = new ArrayList();
            }
            imageFormatSpecs.add(imageFormatSpec);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return imageFormatSpec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatNames(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ImageFormatSpec> arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            for (ImageFormatSpec imageFormatSpec : imageFormatSpecs) {
                if (bl && !imageFormatSpec.writable) continue;
                arrayList.add(imageFormatSpec.name);
                Iterator iterator = imageFormatSpec.extensions.iterator();
                while (iterator.hasNext()) {
                    arrayList.add((String)iterator.next());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatExtensions(boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList<ImageFormatSpec> arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            for (ImageFormatSpec imageFormatSpec : imageFormatSpecs) {
                if (bl && !imageFormatSpec.writable) continue;
                Iterator iterator = imageFormatSpec.extensions.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getFormatMimeTypes(boolean bl) {
        ArrayList arrayList = new ArrayList();
        ArrayList<ImageFormatSpec> arrayList2 = imageFormatSpecs;
        synchronized (arrayList2) {
            for (ImageFormatSpec imageFormatSpec : imageFormatSpecs) {
                if (bl && !imageFormatSpec.writable) continue;
                Iterator iterator = imageFormatSpec.mimeTypes.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String findFormatName(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("extension is not a string");
        }
        String string = (String)object;
        for (ImageFormatSpec imageFormatSpec : imageFormatSpecs) {
            if (bl && !imageFormatSpec.writable) continue;
            if (imageFormatSpec.name.equals(string)) {
                return string;
            }
            for (String string2 : imageFormatSpec.extensions) {
                if (!string2.equals(string)) continue;
                return imageFormatSpec.name;
            }
            for (String string2 : imageFormatSpec.mimeTypes) {
                if (!string2.equals(string)) continue;
                return imageFormatSpec.name;
            }
        }
        throw new IllegalArgumentException("unknown extension '" + string + "'");
    }

    public static synchronized GdkPixbufReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new GdkPixbufReaderSpi();
        }
        return readerSpi;
    }

    public static synchronized GdkPixbufWriterSpi getWriterSpi() {
        if (writerSpi == null) {
            writerSpi = new GdkPixbufWriterSpi();
        }
        return writerSpi;
    }

    public static void registerSpis(IIORegistry iIORegistry) {
        iIORegistry.registerServiceProvider(GdkPixbufDecoder.getReaderSpi(), ImageReaderSpi.class);
        iIORegistry.registerServiceProvider(GdkPixbufDecoder.getWriterSpi(), ImageWriterSpi.class);
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkPixbufDecoder.initStaticState();
        pixbufLock = new Object();
        cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GdkPixbufReader
    extends ImageReader
    implements ImageConsumer {
        GdkPixbufDecoder dec;
        BufferedImage bufferedImage;
        ColorModel defaultModel;
        int width;
        int height;
        String ext;

        public GdkPixbufReader(GdkPixbufReaderSpi gdkPixbufReaderSpi, Object object) {
            super(gdkPixbufReaderSpi);
            this.ext = GdkPixbufDecoder.findFormatName(object, false);
        }

        public GdkPixbufReader(GdkPixbufReaderSpi gdkPixbufReaderSpi, Object object, GdkPixbufDecoder gdkPixbufDecoder) {
            this(gdkPixbufReaderSpi, object);
            this.dec = gdkPixbufDecoder;
        }

        @Override
        public void setDimensions(int n, int n2) {
            this.processImageStarted(1);
            this.width = n;
            this.height = n2;
        }

        public void setProperties(Hashtable hashtable) {
        }

        @Override
        public void setColorModel(ColorModel colorModel) {
            this.defaultModel = colorModel;
        }

        @Override
        public void setHints(int n) {
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        }

        @Override
        public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
            int[] nArray2;
            if (colorModel == null) {
                colorModel = this.defaultModel;
            }
            if (this.bufferedImage == null) {
                this.bufferedImage = colorModel != null && colorModel.hasAlpha() ? new BufferedImage(this.width, this.height, 2) : new BufferedImage(this.width, this.height, 1);
            }
            if (colorModel != null) {
                nArray2 = new int[nArray.length];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n7 = i * n6 + j;
                        nArray2[n7] = colorModel.getRGB(nArray[n7]);
                    }
                }
            } else {
                nArray2 = nArray;
            }
            this.bufferedImage.setRGB(n, n2, n3, n4, nArray2, n5, n6);
            this.processImageProgress(n2 / (this.height == 0 ? 1 : this.height));
        }

        @Override
        public void imageComplete(int n) {
            this.processImageComplete();
        }

        public BufferedImage getBufferedImage() {
            if (this.bufferedImage == null && this.dec != null) {
                this.dec.startProduction(this);
            }
            return this.bufferedImage;
        }

        @Override
        public int getNumImages(boolean bl) throws IOException {
            return 1;
        }

        @Override
        public IIOMetadata getImageMetadata(int n) {
            return null;
        }

        @Override
        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        @Override
        public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
            BufferedImage bufferedImage = this.getBufferedImage();
            Vector<ImageTypeSpecifier> vector = new Vector<ImageTypeSpecifier>();
            vector.add(new ImageTypeSpecifier(bufferedImage));
            return vector.iterator();
        }

        @Override
        public int getHeight(int n) throws IOException {
            return this.getBufferedImage().getHeight();
        }

        @Override
        public int getWidth(int n) throws IOException {
            return this.getBufferedImage().getWidth();
        }

        @Override
        public void setInput(Object object, boolean bl, boolean bl2) {
            super.setInput(object, bl, bl2);
            Object object2 = this.getInput();
            if (object2 instanceof InputStream) {
                this.dec = new GdkPixbufDecoder((InputStream)object2);
            } else if (object2 instanceof DataInput) {
                this.dec = new GdkPixbufDecoder((DataInput)object2);
            } else {
                throw new IllegalArgumentException("input object not supported: " + object2);
            }
        }

        @Override
        public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
            return this.getBufferedImage();
        }
    }

    private static class GdkPixbufWriter
    extends ImageWriter
    implements Runnable {
        String ext;
        private static final Object DATADONE = new Object();
        private ArrayList<Object> data = new ArrayList();
        private IOException exception;

        public GdkPixbufWriter(GdkPixbufWriterSpi gdkPixbufWriterSpi, Object object) {
            super(gdkPixbufWriterSpi);
            this.ext = GdkPixbufDecoder.findFormatName(object, true);
        }

        public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
            return null;
        }

        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
            Object object;
            Object object2;
            RenderedImage renderedImage = iIOImage.getRenderedImage();
            Raster raster = renderedImage.getData();
            int n = raster.getWidth();
            int n2 = raster.getHeight();
            ColorModel colorModel = renderedImage.getColorModel();
            int[] nArray = CairoGraphics2D.findSimpleIntegerArray(renderedImage.getColorModel(), raster);
            if (nArray == null) {
                if (colorModel != null && colorModel.hasAlpha()) {
                    object2 = CairoSurface.getBufferedImage(n, n2);
                }
                object2 = new BufferedImage(n, n2, 1);
                object = new int[4];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        ((BufferedImage)object2).setRGB(j, i, colorModel.getRGB(raster.getPixel(j, i, (int[])object)));
                    }
                }
                nArray = CairoGraphics2D.findSimpleIntegerArray(((BufferedImage)object2).getColorModel(), ((BufferedImage)object2).getRaster());
                colorModel = ((BufferedImage)object2).getColorModel();
            }
            object2 = new Thread(this, "GdkPixbufWriter");
            ((Thread)object2).start();
            this.processImageStarted(1);
            Object object3 = pixbufLock;
            object = object3;
            synchronized (object3) {
                GdkPixbufDecoder.streamImage(nArray, this.ext, n, n2, colorModel.hasAlpha(), this);
                // ** MonitorExit[var11_11 /* !! */ ] (shouldn't be in output)
                ArrayList<Object> arrayList = this.data;
                object = arrayList;
                synchronized (arrayList) {
                    this.data.add(DATADONE);
                    this.data.notifyAll();
                    // ** MonitorExit[var11_11 /* !! */ ] (shouldn't be in output)
                    while (((Thread)object2).isAlive()) {
                        try {
                            ((Thread)object2).join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.exception != null) {
                        throw this.exception;
                    }
                    this.processImageComplete();
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(byte[] byArray) {
            ArrayList<Object> arrayList = this.data;
            synchronized (arrayList) {
                this.data.add(byArray);
                this.data.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = false;
            while (!bl) {
                ArrayList<Object> arrayList = this.data;
                synchronized (arrayList) {
                    block11: {
                        while (this.data.isEmpty()) {
                            try {
                                this.data.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        Object object = this.data.remove(0);
                        if (object == DATADONE) {
                            bl = true;
                        } else {
                            DataOutput dataOutput = (DataOutput)this.getOutput();
                            try {
                                dataOutput.write((byte[])object);
                            }
                            catch (IOException iOException) {
                                if (this.exception != null) break block11;
                                this.exception = iOException;
                            }
                        }
                    }
                }
            }
        }
    }

    public static class GdkPixbufReaderSpi
    extends ImageReaderSpi {
        public GdkPixbufReaderSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(false), GdkPixbufDecoder.getFormatExtensions(false), GdkPixbufDecoder.getFormatMimeTypes(false), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReader", new Class[]{ImageInputStream.class}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriterSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canDecodeInput(Object object) {
            return true;
        }

        public ImageReader createReaderInstance(Object object) {
            return new GdkPixbufReader(this, object);
        }

        public String getDescription(Locale locale) {
            return "GdkPixbuf Reader SPI";
        }
    }

    public static class GdkPixbufWriterSpi
    extends ImageWriterSpi {
        public GdkPixbufWriterSpi() {
            super("GdkPixbuf", "2.x", GdkPixbufDecoder.getFormatNames(true), GdkPixbufDecoder.getFormatExtensions(true), GdkPixbufDecoder.getFormatMimeTypes(true), "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriter", new Class[]{ImageOutputStream.class}, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReaderSpi"}, false, null, null, null, null, false, null, null, null, null);
        }

        public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
            return true;
        }

        public ImageWriter createWriterInstance(Object object) {
            return new GdkPixbufWriter(this, object);
        }

        public String getDescription(Locale locale) {
            return "GdkPixbuf Writer SPI";
        }
    }

    public static class ImageFormatSpec {
        public String name;
        public boolean writable = false;
        public ArrayList<String> mimeTypes = new ArrayList();
        public ArrayList<String> extensions = new ArrayList();

        public ImageFormatSpec(String string, boolean bl) {
            this.name = string;
            this.writable = bl;
        }

        public synchronized void addMimeType(String string) {
            this.mimeTypes.add(string);
        }

        public synchronized void addExtension(String string) {
            this.extensions.add(string);
        }
    }
}

