/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.ComponentGraphicsCopy;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkVolatileImage;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ComponentGraphics
extends CairoGraphics2D {
    private static final boolean hasXRenderExtension = ComponentGraphics.hasXRender();
    private GtkComponentPeer component;
    protected long cairo_t;
    private BufferedImage buffer;
    private BufferedImage componentBuffer;
    private static ThreadLocal<Integer> hasLock = new ThreadLocal();
    private static Integer ONE = 1;

    ComponentGraphics() {
    }

    private ComponentGraphics(GtkComponentPeer gtkComponentPeer) {
        this.component = gtkComponentPeer;
        this.cairo_t = this.initState(gtkComponentPeer);
        this.setup(this.cairo_t);
        Rectangle rectangle = gtkComponentPeer.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, rectangle.width, rectangle.height));
        this.setBackground(gtkComponentPeer.awtComponent.getBackground());
        this.setColor(gtkComponentPeer.awtComponent.getForeground());
    }

    private ComponentGraphics(ComponentGraphics componentGraphics) {
        this.component = componentGraphics.component;
        this.cairo_t = this.initState(this.component);
        this.copy(componentGraphics, this.cairo_t);
        Rectangle rectangle = this.component.awtComponent.getBounds();
        this.setClip(new Rectangle(0, 0, rectangle.width, rectangle.height));
        this.setBackground(this.component.awtComponent.getBackground());
        this.setColor(this.component.awtComponent.getForeground());
    }

    private native long initState(GtkComponentPeer var1);

    private void lock() {
        Integer n = hasLock.get();
        if (n == null) {
            this.start_gdk_drawing();
            hasLock.set(ONE);
        } else {
            hasLock.set(n + 1);
        }
    }

    private void unlock() {
        Integer n = hasLock.get();
        if (n == null) {
            throw new IllegalStateException();
        }
        if (n == ONE) {
            hasLock.set(null);
            this.end_gdk_drawing();
        } else if (n == 2) {
            hasLock.set(ONE);
        } else {
            hasLock.set(n - 1);
        }
    }

    protected native long initFromVolatile(long var1);

    private native void start_gdk_drawing();

    private native void end_gdk_drawing();

    public static native boolean hasXRender();

    private static native Pointer nativeGrab(GtkComponentPeer var0);

    private native void copyAreaNative(GtkComponentPeer var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void drawVolatile(GtkComponentPeer var1, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public static GtkImage grab(GtkComponentPeer gtkComponentPeer) {
        return new GtkImage(ComponentGraphics.nativeGrab(gtkComponentPeer));
    }

    public static Graphics2D getComponentGraphics(GtkComponentPeer gtkComponentPeer) {
        if (hasXRenderExtension) {
            return new ComponentGraphics(gtkComponentPeer);
        }
        Rectangle rectangle = gtkComponentPeer.awtComponent.getBounds();
        return new ComponentGraphicsCopy(rectangle.width, rectangle.height, gtkComponentPeer);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.component.getGraphicsConfiguration();
    }

    public Graphics create() {
        return new ComponentGraphics(this);
    }

    protected Rectangle2D getRealBounds() {
        return this.component.awtComponent.getBounds();
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaNative(this.component, n, n2, n3, n4, n5, n6);
    }

    public void draw(Shape shape) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setStroke(this.getStroke());
            graphics2D.setColor(this.getColor());
            graphics2D.draw(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
    }

    public void fill(Shape shape) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setColor(this.getColor());
            graphics2D.fill(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(renderedImage, affineTransform);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHints(this.getRenderingHints());
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            bl = super.drawImage(image, affineTransform, color, imageObserver);
        } else {
            Object object;
            if (!(image instanceof BufferedImage)) {
                object = image.getSource();
                if (object == null) {
                    return false;
                }
                image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            }
            object = (BufferedImage)image;
            Point2D point2D = new Point2D.Double(((BufferedImage)object).getMinX(), ((BufferedImage)object).getMinY());
            Point2D point2D2 = new Point2D.Double(((BufferedImage)object).getWidth() + ((BufferedImage)object).getMinX(), ((BufferedImage)object).getHeight() + ((BufferedImage)object).getMinY());
            if (affineTransform != null) {
                point2D = affineTransform.transform(point2D, point2D);
                point2D2 = affineTransform.transform(point2D2, point2D2);
            }
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHints(this.getRenderingHints());
            graphics2D.drawImage(image, affineTransform, imageObserver);
            bl = this.drawComposite(new Rectangle2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY()), imageObserver);
        }
        return bl;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(glyphVector, f, f2);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setStroke(this.getStroke());
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            rectangle2D = new Rectangle2D.Double((double)f + rectangle2D.getX(), (double)f2 + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.drawComposite(rectangle2D, null);
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof GtkVolatileImage) {
            GtkVolatileImage gtkVolatileImage = (GtkVolatileImage)image;
            int n3 = this.transform.getType();
            if (!(n3 != 0 && n3 != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                if (rectangle2D == null) {
                    rectangle2D = this.getRealBounds();
                }
                n = (int)((double)n + this.transform.getTranslateX());
                n2 = (int)((double)n2 + this.transform.getTranslateY());
                this.drawVolatile(this.component, gtkVolatileImage.nativePointer, n, n2, gtkVolatileImage.width, gtkVolatileImage.height, (int)(rectangle2D.getX() + this.transform.getTranslateX()), (int)(rectangle2D.getY() + this.transform.getTranslateY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                return true;
            }
            return super.drawImage((Image)gtkVolatileImage.getSnapshot(), n, n2, imageObserver);
        }
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageProducer imageProducer = image.getSource();
            if (imageProducer == null) {
                return false;
            }
            bufferedImage = (BufferedImage)Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        return super.drawImage((Image)bufferedImage, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        BufferedImage bufferedImage;
        if (image instanceof GtkVolatileImage && (this.clip == null || this.clip instanceof Rectangle2D)) {
            GtkVolatileImage gtkVolatileImage = (GtkVolatileImage)image;
            int n5 = this.transform.getType();
            if (!(n5 != 0 && n5 != 1 || this.clip != null && !(this.clip instanceof Rectangle2D))) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                if (rectangle2D == null) {
                    rectangle2D = this.getRealBounds();
                }
                n = (int)((double)n + this.transform.getTranslateX());
                n2 = (int)((double)n2 + this.transform.getTranslateY());
                this.drawVolatile(this.component, gtkVolatileImage.nativePointer, n, n2, n3, n4, (int)(rectangle2D.getX() + this.transform.getTranslateX()), (int)(rectangle2D.getY() + this.transform.getTranslateY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
                return true;
            }
            return super.drawImage(gtkVolatileImage.getSnapshot(), n, n2, n3, n4, imageObserver);
        }
        if ((image = AsyncImage.realImage(image, imageObserver)) instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            ImageProducer imageProducer = image.getSource();
            if (imageProducer == null) {
                return false;
            }
            bufferedImage = (BufferedImage)Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        return super.drawImage(bufferedImage, n, n2, n3, n4, imageObserver);
    }

    private boolean drawComposite(Rectangle2D rectangle2D, ImageObserver imageObserver) {
        Rectangle rectangle = this.getClipBounds();
        Rectangle2D.intersect(rectangle2D, rectangle, rectangle2D);
        rectangle = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(rectangle2D, rectangle, rectangle2D);
        BufferedImage bufferedImage = this.buffer;
        if (!rectangle2D.equals(bufferedImage.getRaster().getBounds())) {
            bufferedImage = bufferedImage.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        double[] dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getMaxX(), rectangle2D.getMaxY()};
        this.transform.transform(dArray, 0, dArray, 0, 2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        Rectangle2D.intersect(double_, this.getClipInDevSpace(), double_);
        GtkImage gtkImage = ComponentGraphics.grab(this.component);
        Graphics2D graphics2D = this.componentBuffer.createGraphics();
        graphics2D.drawImage(gtkImage, 0, 0, null);
        graphics2D.dispose();
        BufferedImage bufferedImage2 = this.componentBuffer;
        if (!double_.equals(bufferedImage2.getRaster().getBounds())) {
            bufferedImage2 = bufferedImage2.getSubimage((int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight());
        }
        this.compCtx.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage2.getRaster());
        boolean bl = super.drawImage((Image)bufferedImage2, AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY()), null, null);
        return bl;
    }

    private void createBuffer() {
        Object object;
        if (this.buffer == null) {
            object = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.component.awtComponent.getWidth(), this.component.awtComponent.getHeight()), new Point(0, 0));
            this.buffer = new BufferedImage(GtkVolatileImage.gdkColorModel, (WritableRaster)object, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            object = (Graphics2D)this.buffer.getGraphics();
            ((Graphics2D)object).setBackground(new Color(0, 0, 0, 0));
            ((Graphics)object).clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
        if (this.componentBuffer == null) {
            object = Raster.createWritableRaster(GtkVolatileImage.createGdkSampleModel(this.component.awtComponent.getWidth(), this.component.awtComponent.getHeight()), new Point(0, 0));
            this.componentBuffer = new BufferedImage(GtkVolatileImage.gdkColorModel, (WritableRaster)object, GtkVolatileImage.gdkColorModel.isAlphaPremultiplied(), new Hashtable());
        }
    }

    protected ColorModel getNativeCM() {
        return GtkVolatileImage.gdkColorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long init(long l) {
        long l2;
        try {
            this.lock();
            l2 = super.init(l);
            Object var6_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.unlock();
            throw throwable;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawPixels(long l, int[] nArray, int n, int n2, int n3, double[] dArray, double d, int n4) {
        try {
            this.lock();
            super.drawPixels(l, nArray, n, n2, n3, dArray, d, n4);
            Object var12_9 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGradient(long l, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        try {
            this.lock();
            super.setGradient(l, d, d2, d3, d4, n, n2, n3, n4, n5, n6, n7, n8, bl);
            Object var21_15 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var21_16 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPaintPixels(long l, int[] nArray, int n, int n2, int n3, boolean bl, int n4, int n5) {
        try {
            this.lock();
            super.setPaintPixels(l, nArray, n, n2, n3, bl, n4, n5);
            Object var11_9 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetMatrix(long l, double[] dArray) {
        try {
            this.lock();
            super.cairoSetMatrix(l, dArray);
            Object var5_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoScale(long l, double d, double d2) {
        try {
            this.lock();
            super.cairoScale(l, d, d2);
            Object var8_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetOperator(long l, int n) {
        try {
            this.lock();
            super.cairoSetOperator(l, n);
            Object var5_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetRGBAColor(long l, double d, double d2, double d3, double d4) {
        try {
            this.lock();
            super.cairoSetRGBAColor(l, d, d2, d3, d4);
            Object var12_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var12_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetFillRule(long l, int n) {
        try {
            this.lock();
            super.cairoSetFillRule(l, n);
            Object var5_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetLine(long l, double d, int n, int n2, double d2) {
        try {
            this.lock();
            super.cairoSetLine(l, d, n, n2, d2);
            Object var10_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetDash(long l, double[] dArray, int n, double d) {
        try {
            this.lock();
            super.cairoSetDash(l, dArray, n, d);
            Object var8_5 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoRectangle(long l, double d, double d2, double d3, double d4) {
        try {
            this.lock();
            super.cairoRectangle(l, d, d2, d3, d4);
            Object var12_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var12_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoArc(long l, double d, double d2, double d3, double d4, double d5) {
        try {
            this.lock();
            super.cairoArc(l, d, d2, d3, d4, d5);
            Object var14_7 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var14_8 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSave(long l) {
        try {
            this.lock();
            super.cairoSave(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoRestore(long l) {
        try {
            this.lock();
            super.cairoRestore(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoNewPath(long l) {
        try {
            this.lock();
            super.cairoNewPath(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoClosePath(long l) {
        try {
            this.lock();
            super.cairoClosePath(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoMoveTo(long l, double d, double d2) {
        try {
            this.lock();
            super.cairoMoveTo(l, d, d2);
            Object var8_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoLineTo(long l, double d, double d2) {
        try {
            this.lock();
            super.cairoLineTo(l, d, d2);
            Object var8_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoCurveTo(long l, double d, double d2, double d3, double d4, double d5, double d6) {
        try {
            this.lock();
            super.cairoCurveTo(l, d, d2, d3, d4, d5, d6);
            Object var16_8 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var16_9 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoStroke(long l) {
        try {
            this.lock();
            super.cairoStroke(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoFill(long l, double d) {
        try {
            this.lock();
            super.cairoFill(l, d);
            Object var6_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoClip(long l) {
        try {
            this.lock();
            super.cairoClip(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoResetClip(long l) {
        try {
            this.lock();
            super.cairoResetClip(l);
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cairoSetAntialias(long l, boolean bl) {
        try {
            this.lock();
            super.cairoSetAntialias(l, bl);
            Object var5_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCairoSurface(CairoSurface cairoSurface, AffineTransform affineTransform, double d, int n) {
        try {
            this.lock();
            super.drawCairoSurface(cairoSurface, affineTransform, d, n);
            Object var7_5 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.unlock();
            throw throwable;
        }
    }
}

