/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoGraphics2D;
import gnu.java.awt.peer.gtk.CairoSurface;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.util.Hashtable;

public class CairoSurfaceGraphics
extends CairoGraphics2D {
    protected CairoSurface surface;
    private BufferedImage buffer;
    private long cairo_t;

    public CairoSurfaceGraphics(CairoSurface cairoSurface) {
        this.surface = cairoSurface;
        this.cairo_t = cairoSurface.newCairoContext();
        this.setup(this.cairo_t);
        this.setClip(0, 0, cairoSurface.width, cairoSurface.height);
    }

    private CairoSurfaceGraphics(CairoSurfaceGraphics cairoSurfaceGraphics) {
        this.surface = cairoSurfaceGraphics.surface;
        this.cairo_t = this.surface.newCairoContext();
        this.copy(cairoSurfaceGraphics, this.cairo_t);
    }

    public Graphics create() {
        return new CairoSurfaceGraphics(this);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    protected Rectangle2D getRealBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.surface.width, this.surface.height);
    }

    public void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        this.surface.copyAreaNative(n, n2, n3, n4, n5, n6, this.surface.width);
    }

    public void draw(Shape shape) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        Rectangle rectangle = this.findStrokedBounds(shape);
        if (this.shiftDrawCalls) {
            ++rectangle.width;
            ++rectangle.height;
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.draw(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setStroke(this.getStroke());
            graphics2D.setColor(this.getColor());
            graphics2D.setTransform(this.transform);
            graphics2D.draw(shape);
            this.drawComposite(rectangle.getBounds2D(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    public void fill(Shape shape) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.fill(shape);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setColor(this.getColor());
            graphics2D.setTransform(this.transform);
            graphics2D.fill(shape);
            this.drawComposite(shape.getBounds2D(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawRenderedImage(renderedImage, affineTransform);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHints(this.getRenderingHints());
            graphics2D.setTransform(this.transform);
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
            this.drawComposite(this.buffer.getRaster().getBounds(), null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            bl = super.drawImage(image, affineTransform, color, imageObserver);
        } else {
            Object object;
            if (!(image instanceof BufferedImage)) {
                object = image.getSource();
                if (object == null) {
                    return false;
                }
                image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object);
            }
            object = (BufferedImage)image;
            Rectangle2D rectangle2D = new Rectangle(((BufferedImage)object).getMinX(), ((BufferedImage)object).getMinY(), ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
            if (affineTransform != null) {
                rectangle2D = CairoSurfaceGraphics.getTransformedBounds(rectangle2D, affineTransform);
            }
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setRenderingHints(this.getRenderingHints());
            graphics2D.drawImage(image, affineTransform, imageObserver);
            bl = this.drawComposite(rectangle2D, imageObserver);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
        return bl;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        if (!this.surface.sharedBuffer) {
            this.surface.syncJavaToNative(this.surface.surfacePointer, this.surface.getData());
        }
        if (this.comp == null || this.comp instanceof AlphaComposite) {
            super.drawGlyphVector(glyphVector, f, f2);
        } else {
            this.createBuffer();
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setPaint(this.getPaint());
            graphics2D.setStroke(this.getStroke());
            graphics2D.drawGlyphVector(glyphVector, f, f2);
            Rectangle2D rectangle2D = glyphVector.getLogicalBounds();
            rectangle2D = new Rectangle2D.Double((double)f + rectangle2D.getX(), (double)f2 + rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.drawComposite(rectangle2D, null);
        }
        if (!this.surface.sharedBuffer) {
            this.surface.syncNativeToJava(this.surface.surfacePointer, this.surface.getData());
        }
    }

    private boolean drawComposite(Rectangle2D rectangle2D, ImageObserver imageObserver) {
        rectangle2D = CairoSurfaceGraphics.getTransformedBounds(rectangle2D, this.transform);
        Rectangle2D rectangle2D2 = this.getClipInDevSpace();
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        rectangle2D2 = new Rectangle(this.buffer.getMinX(), this.buffer.getMinY(), this.buffer.getWidth(), this.buffer.getHeight());
        Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        d = Math.round(d);
        d2 = Math.round(d2);
        rectangle2D.setRect(d, d2, Math.round(d3 - d), Math.round(d4 - d2));
        BufferedImage bufferedImage = this.buffer;
        if (!rectangle2D.equals(bufferedImage.getRaster().getBounds())) {
            bufferedImage = bufferedImage.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        }
        BufferedImage bufferedImage2 = CairoSurface.getBufferedImage(this.surface);
        bufferedImage2 = bufferedImage2.getSubimage((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        this.compCtx.compose(bufferedImage.getRaster(), bufferedImage2.getRaster(), bufferedImage.getRaster());
        Composite composite = this.comp;
        this.setComposite(AlphaComposite.Src);
        boolean bl = super.drawImage((Image)bufferedImage, AffineTransform.getTranslateInstance(rectangle2D.getX(), rectangle2D.getY()), null, null);
        this.setComposite(composite);
        this.updateColor();
        return bl;
    }

    private void createBuffer() {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(this.getBufferCM(), this.surface.createCompatibleWritableRaster(), this.getBufferCM().isAlphaPremultiplied(), new Hashtable());
        } else {
            Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
            graphics2D.setBackground(new Color(0, 0, 0, 0));
            graphics2D.clearRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
        }
    }

    protected ColorModel getNativeCM() {
        return CairoSurface.cairoCM_pre;
    }

    protected ColorModel getBufferCM() {
        return CairoSurface.cairoColorModel;
    }
}

