/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.AsyncImage;
import gnu.java.awt.peer.gtk.BufferedImageGraphics;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.FreetypeGlyphVector;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.ImagingOpException;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CairoGraphics2D
extends Graphics2D {
    long nativePointer;
    Paint paint;
    boolean customPaint;
    Stroke stroke;
    Color fg;
    Color bg;
    Shape clip;
    AffineTransform transform;
    Font font;
    Composite comp;
    CompositeContext compCtx;
    private RenderingHints hints;
    private boolean antialias = false;
    private boolean ignoreAA = false;
    protected boolean shiftDrawCalls = false;
    private boolean firstClip = true;
    private Shape originalClip;
    private static BasicStroke draw3DRectStroke;
    static ColorModel rgb32;
    static ColorModel argb32;
    public static final int INTERPOLATION_NEAREST = 0;
    public static final int INTERPOLATION_BILINEAR = 1;
    public static final int INTERPOLATION_BICUBIC = 5;
    public static final int ALPHA_INTERPOLATION_SPEED = 2;
    public static final int ALPHA_INTERPOLATION_QUALITY = 3;
    public static final int ALPHA_INTERPOLATION_DEFAULT = 4;

    public void setup(long l) {
        this.nativePointer = this.init(l);
        this.setRenderingHints(new RenderingHints(this.getDefaultHints()));
        this.setFont(new Font("SansSerif", 0, 12));
        this.setColor(Color.black);
        this.setBackground(Color.white);
        this.setPaint(Color.black);
        this.setStroke(new BasicStroke());
        this.setTransform(new AffineTransform());
        this.cairoSetAntialias(this.nativePointer, this.antialias);
    }

    public void copy(CairoGraphics2D cairoGraphics2D, long l) {
        this.nativePointer = this.init(l);
        this.paint = cairoGraphics2D.paint;
        this.stroke = cairoGraphics2D.stroke;
        this.setRenderingHints(cairoGraphics2D.hints);
        Color color = cairoGraphics2D.fg.getAlpha() != -1 ? new Color(cairoGraphics2D.fg.getRed(), cairoGraphics2D.fg.getGreen(), cairoGraphics2D.fg.getBlue(), cairoGraphics2D.fg.getAlpha()) : new Color(cairoGraphics2D.fg.getRGB());
        if (cairoGraphics2D.bg != null) {
            this.bg = cairoGraphics2D.bg.getAlpha() != -1 ? new Color(cairoGraphics2D.bg.getRed(), cairoGraphics2D.bg.getGreen(), cairoGraphics2D.bg.getBlue(), cairoGraphics2D.bg.getAlpha()) : new Color(cairoGraphics2D.bg.getRGB());
        }
        this.firstClip = cairoGraphics2D.firstClip;
        this.originalClip = cairoGraphics2D.originalClip;
        this.clip = cairoGraphics2D.getClip();
        this.transform = cairoGraphics2D.transform == null ? null : new AffineTransform(cairoGraphics2D.transform);
        this.setFont(cairoGraphics2D.font);
        this.setColor(color);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setTransformImpl(this.transform);
        this.setClip(this.clip);
        this.setComposite(this.comp);
        this.antialias = !cairoGraphics2D.antialias;
        this.setAntialias(cairoGraphics2D.antialias);
    }

    @Override
    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.disposeNative(this.nativePointer);
        this.nativePointer = 0L;
        if (this.compCtx != null) {
            this.compCtx.dispose();
        }
    }

    protected native long init(long var1);

    @Override
    public abstract Graphics create();

    @Override
    public abstract GraphicsConfiguration getDeviceConfiguration();

    protected abstract void copyAreaImpl(int var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract Rectangle2D getRealBounds();

    public native void disposeNative(long var1);

    protected native void drawPixels(long var1, int[] var3, int var4, int var5, int var6, double[] var7, double var8, int var10);

    protected native void setGradient(long var1, double var3, double var5, double var7, double var9, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, boolean var19);

    protected native void setPaintPixels(long var1, int[] var3, int var4, int var5, int var6, boolean var7, int var8, int var9);

    protected native void cairoSetMatrix(long var1, double[] var3);

    protected native void cairoScale(long var1, double var3, double var5);

    protected native void cairoSetOperator(long var1, int var3);

    protected native void cairoSetRGBAColor(long var1, double var3, double var5, double var7, double var9);

    protected native void cairoSetFillRule(long var1, int var3);

    protected native void cairoSetLine(long var1, double var3, int var5, int var6, double var7);

    protected native void cairoSetDash(long var1, double[] var3, int var4, double var5);

    protected native void cairoDrawGlyphVector(long var1, GdkFontPeer var3, float var4, float var5, int var6, int[] var7, float[] var8, long[] var9);

    protected native void cairoSetFont(long var1, GdkFontPeer var3);

    protected native void cairoRectangle(long var1, double var3, double var5, double var7, double var9);

    protected native void cairoArc(long var1, double var3, double var5, double var7, double var9, double var11);

    protected native void cairoSave(long var1);

    protected native void cairoRestore(long var1);

    protected native void cairoNewPath(long var1);

    protected native void cairoClosePath(long var1);

    protected native void cairoMoveTo(long var1, double var3, double var5);

    protected native void cairoLineTo(long var1, double var3, double var5);

    protected native void cairoCurveTo(long var1, double var3, double var5, double var7, double var9, double var11, double var13);

    protected native void cairoStroke(long var1);

    protected native void cairoFill(long var1, double var3);

    protected native void cairoClip(long var1);

    protected native void cairoResetClip(long var1);

    protected native void cairoSetAntialias(long var1, boolean var3);

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.updateClip(this.transform);
        this.setTransformImpl(affineTransform);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        if (this.clip != null) {
            this.setClip(this.clip);
        }
    }

    private void setTransformImpl(AffineTransform affineTransform) {
        this.transform = affineTransform;
        if (this.transform != null) {
            double[] dArray = new double[6];
            this.transform.getMatrix(dArray);
            this.cairoSetMatrix(this.nativePointer, dArray);
        }
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        if (this.transform == null) {
            this.transform = new AffineTransform(affineTransform);
        } else {
            this.transform.concatenate(affineTransform);
        }
        if (this.clip != null) {
            try {
                AffineTransform affineTransform2 = affineTransform.createInverse();
                this.updateClip(affineTransform2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
        }
        this.setTransformImpl(this.transform);
    }

    @Override
    public void rotate(double d) {
        this.transform(AffineTransform.getRotateInstance(d));
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    @Override
    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    @Override
    public void translate(double d, double d2) {
        if (this.transform != null) {
            this.transform.translate(d, d2);
        } else {
            this.transform = AffineTransform.getTranslateInstance(d, d2);
        }
        if (this.clip != null) {
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                rectangle2D.setRect(rectangle2D.getX() - d, rectangle2D.getY() - d2, rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d, -d2);
                this.updateClip(affineTransform);
            }
        }
        this.setTransformImpl(this.transform);
    }

    @Override
    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }

    @Override
    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    @Override
    public void clip(Shape shape) {
        if (shape == null) {
            this.setClip(null);
            return;
        }
        if (this.clip == null) {
            this.clip = this.getRealBounds();
        }
        if (this.clip instanceof Rectangle2D && shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)this.clip;
            Rectangle2D rectangle2D2 = (Rectangle2D)shape;
            Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
            this.setClip(rectangle2D);
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area area2 = shape instanceof Area ? (Area)shape : new Area(shape);
            area.intersect(area2);
            this.clip = area;
            this.setClip(this.clip);
        }
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
            this.customPaint = false;
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint texturePaint = (TexturePaint)this.paint;
            BufferedImage bufferedImage = texturePaint.getImage();
            int n = (int)texturePaint.getAnchorRect().getWidth();
            int n2 = (int)texturePaint.getAnchorRect().getHeight();
            double d = (double)n / (double)bufferedImage.getWidth();
            double d2 = (double)n2 / (double)bufferedImage.getHeight();
            AffineTransform affineTransform = new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, this.getRenderingHints());
            BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
            int[] nArray = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
            this.setPaintPixels(this.nativePointer, nArray, n, n2, n, true, 0, 0);
            this.customPaint = false;
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)this.paint;
            Point2D point2D = gradientPaint.getPoint1();
            Point2D point2D2 = gradientPaint.getPoint2();
            Color color = gradientPaint.getColor1();
            Color color2 = gradientPaint.getColor2();
            this.setGradient(this.nativePointer, point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), color2.getRed(), color2.getGreen(), color2.getBlue(), color2.getAlpha(), gradientPaint.isCyclic());
            this.customPaint = false;
        } else {
            this.customPaint = true;
        }
    }

    protected void setCustomPaint(Rectangle rectangle) {
        if (this.paint instanceof Color || this.paint instanceof TexturePaint || this.paint instanceof GradientPaint) {
            return;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Rectangle2D rectangle2D = CairoGraphics2D.getTransformedBounds(rectangle, this.transform);
        int n5 = (int)rectangle2D.getX();
        int n6 = (int)rectangle2D.getY();
        int n7 = (int)Math.ceil(rectangle2D.getWidth());
        int n8 = (int)Math.ceil(rectangle2D.getHeight());
        PaintContext paintContext = this.paint.createContext(CairoSurface.cairoColorModel, new Rectangle(n5, n6, n7, n8), rectangle, this.transform, this.hints);
        Raster raster = paintContext.getRaster(n5, n6, n7, n8);
        AffineTransform affineTransform = new AffineTransform(this.transform);
        this.setTransformImpl(new AffineTransform());
        if (paintContext.getColorModel().equals(CairoSurface.cairoColorModel) && raster.getSampleModel().getTransferType() == 3) {
            this.setPaintPixels(this.nativePointer, (int[])raster.getDataElements(0, 0, n7, n8, null), n7, n8, n7, false, n5, n6);
        } else if (paintContext.getColorModel().equals(CairoSurface.cairoCM_opaque) && raster.getSampleModel().getTransferType() == 3) {
            int[] nArray = (int[])raster.getDataElements(0, 0, n7, n8, null);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0xFF000000 | nArray[i] & 0xFFFFFF;
            }
            this.setPaintPixels(this.nativePointer, nArray, n7, n8, n7, false, n5, n6);
        } else {
            WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(raster.getMinX(), raster.getMinY()));
            writableRaster.setRect(raster);
            BufferedImage bufferedImage = new BufferedImage(paintContext.getColorModel(), writableRaster, paintContext.getColorModel().isAlphaPremultiplied(), null);
            this.setPaintPixels(this.nativePointer, bufferedImage.getRGB(0, 0, n7, n8, null, 0, n7), n7, n8, n7, false, n5, n6);
        }
        this.setTransformImpl(affineTransform);
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)this.stroke;
            this.cairoSetLine(this.nativePointer, basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit());
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                double[] dArray = new double[fArray.length];
                for (int i = 0; i < fArray.length; ++i) {
                    dArray[i] = fArray[i];
                }
                this.cairoSetDash(this.nativePointer, dArray, dArray.length, basicStroke.getDashPhase());
            } else {
                this.cairoSetDash(this.nativePointer, new double[0], 0, 0.0);
            }
        }
    }

    protected Rectangle findStrokedBounds(Shape shape) {
        Rectangle rectangle = shape.getBounds();
        if (this.stroke instanceof BasicStroke) {
            int n = (int)Math.ceil(((BasicStroke)this.stroke).getLineWidth());
            rectangle.x -= n / 2;
            rectangle.y -= n / 2;
            rectangle.height += n;
            rectangle.width += n;
        } else {
            Shape shape2 = this.stroke.createStrokedShape(shape);
            rectangle = shape2.getBounds();
        }
        return rectangle;
    }

    @Override
    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            color = Color.BLACK;
        }
        this.fg = color;
        this.paint = color;
        this.updateColor();
    }

    void updateColor() {
        if (this.fg == null) {
            this.fg = Color.BLACK;
        }
        this.cairoSetRGBAColor(this.nativePointer, (double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0, (double)this.fg.getAlpha() / 255.0);
    }

    @Override
    public Color getColor() {
        return this.fg;
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        if (this.clip == null) {
            this.setClip(new Rectangle(n, n2, n3, n4));
        } else if (this.clip instanceof Rectangle) {
            CairoGraphics2D.computeIntersection(n, n2, n3, n4, (Rectangle)this.clip);
            this.setClip(this.clip);
        } else {
            this.clip(new Rectangle(n, n2, n3, n4));
        }
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        if (this.clip instanceof Rectangle2D) {
            return this.clip.getBounds2D();
        }
        GeneralPath generalPath = new GeneralPath();
        PathIterator pathIterator = this.clip.getPathIterator(null);
        generalPath.append(pathIterator, false);
        return generalPath;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D rectangle2D = this.clip.getBounds2D();
        if (this.transform == null) {
            return rectangle2D;
        }
        return CairoGraphics2D.getTransformedBounds(this.clip.getBounds2D(), this.transform);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.setClip(new Rectangle2D.Double(n, n2, n3, n4));
    }

    @Override
    public void setClip(Shape shape) {
        if (this.firstClip) {
            this.originalClip = shape;
            this.firstClip = false;
        }
        this.clip = shape;
        this.cairoResetClip(this.nativePointer);
        if (this.clip != null) {
            this.cairoNewPath(this.nativePointer);
            if (this.clip instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)this.clip;
                this.cairoRectangle(this.nativePointer, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null), false);
            }
            this.cairoClip(this.nativePointer);
        }
    }

    @Override
    public void setBackground(Color color) {
        if (color == null) {
            color = Color.WHITE;
        }
        this.bg = color;
    }

    @Override
    public Color getBackground() {
        return this.bg;
    }

    @Override
    public Composite getComposite() {
        if (this.comp == null) {
            return AlphaComposite.SrcOver;
        }
        return this.comp;
    }

    @Override
    public void setComposite(Composite composite) {
        if (this.comp == composite) {
            return;
        }
        this.comp = composite;
        if (this.compCtx != null) {
            this.compCtx.dispose();
        }
        this.compCtx = null;
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.cairoSetOperator(this.nativePointer, alphaComposite.getRule());
        } else {
            this.cairoSetOperator(this.nativePointer, 3);
            if (composite != null) {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
                }
                this.compCtx = composite.createContext(this.getBufferCM(), this.getNativeCM(), this.hints);
            }
        }
    }

    protected abstract ColorModel getNativeCM();

    protected ColorModel getBufferCM() {
        return this.getNativeCM();
    }

    @Override
    public void draw(Shape shape) {
        if (this.stroke != null && !(this.stroke instanceof BasicStroke) || this.comp instanceof AlphaComposite && (double)((AlphaComposite)this.comp).getAlpha() != 1.0) {
            this.fill(this.stroke.createStrokedShape(shape));
            return;
        }
        if (this.customPaint) {
            Rectangle rectangle = this.findStrokedBounds(shape);
            this.setCustomPaint(rectangle);
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_OFF));
        this.createPath(shape, true);
        this.cairoStroke(this.nativePointer);
    }

    @Override
    public void fill(Shape shape) {
        this.createPath(shape, false);
        if (this.customPaint) {
            this.setCustomPaint(shape.getBounds());
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_ANTIALIASING).equals(RenderingHints.VALUE_ANTIALIAS_OFF));
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        this.cairoFill(this.nativePointer, d);
    }

    private void createPath(Shape shape, boolean bl) {
        this.cairoNewPath(this.nativePointer);
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            double d = this.shiftX(rectangle2D.getX(), this.shiftDrawCalls && bl);
            double d2 = this.shiftY(rectangle2D.getY(), this.shiftDrawCalls && bl);
            double d3 = Math.round(rectangle2D.getWidth());
            double d4 = Math.round(rectangle2D.getHeight());
            this.cairoRectangle(this.nativePointer, d, d2, d3, d4);
        } else if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            this.cairoMoveTo(this.nativePointer, this.shiftX(line2D.getX1(), this.shiftDrawCalls && bl), this.shiftY(line2D.getY1(), this.shiftDrawCalls && bl));
            this.cairoLineTo(this.nativePointer, this.shiftX(line2D.getX2(), this.shiftDrawCalls && bl), this.shiftY(line2D.getY2(), this.shiftDrawCalls && bl));
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            double d = Math.min(ellipse2D.getHeight(), ellipse2D.getWidth()) / 2.0;
            double d5 = 1.0;
            double d6 = 1.0;
            if (ellipse2D.getHeight() != ellipse2D.getWidth()) {
                this.cairoSave(this.nativePointer);
                if (ellipse2D.getHeight() < ellipse2D.getWidth()) {
                    d5 = ellipse2D.getWidth() / (d * 2.0);
                } else {
                    d6 = ellipse2D.getHeight() / (d * 2.0);
                }
                if (d5 != 1.0 || d6 != 1.0) {
                    this.cairoScale(this.nativePointer, d5, d6);
                }
            }
            this.cairoArc(this.nativePointer, this.shiftX(ellipse2D.getCenterX() / d5, this.shiftDrawCalls && bl), this.shiftY(ellipse2D.getCenterY() / d6, this.shiftDrawCalls && bl), d, 0.0, Math.PI * 2);
            if (d5 != 1.0 || d6 != 1.0) {
                this.cairoRestore(this.nativePointer);
            }
        } else {
            this.walkPath(shape.getPathIterator(null), this.shiftDrawCalls && bl);
        }
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.bg != null) {
            this.cairoSetRGBAColor(this.nativePointer, (double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0, (double)this.bg.getAlpha() / 255.0);
        }
        Composite composite = this.comp;
        this.setComposite(AlphaComposite.Src);
        this.fillRect(n, n2, n3, n4);
        this.setComposite(composite);
        this.updateColor();
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        Stroke stroke = this.stroke;
        this.setStroke(draw3DRectStroke);
        super.draw3DRect(n, n2, n3, n4, bl);
        this.setStroke(stroke);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            this.fill(new Rectangle(n, n2, 1, 1));
        } else {
            this.draw(new Line2D.Double(n, n2, n3, n4));
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.draw(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        for (int i = 1; i < n; ++i) {
            this.draw(new Line2D.Double(nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i]));
        }
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.drawArc(n, n2, n3, n4, 0, 360);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.fillArc(n, n2, n3, n4, 0, 360);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        Point2D point2D = this.transform.transform(new Point2D.Double(n, n2), null);
        Point2D point2D2 = this.transform.transform(new Point2D.Double(n + n3, n2 + n4), null);
        Point2D point2D3 = this.transform.transform(new Point2D.Double(n + n5, n2 + n6), null);
        int n7 = (int)point2D.getX();
        int n8 = (int)point2D.getY();
        int n9 = (int)(point2D2.getX() - point2D.getX());
        int n10 = (int)(point2D2.getY() - point2D.getY());
        int n11 = (int)(point2D3.getX() - point2D.getX());
        int n12 = (int)(point2D3.getY() - point2D.getY());
        Rectangle2D rectangle2D = this.getRealBounds();
        if (n9 <= 0 || n10 <= 0) {
            return;
        }
        if ((double)(n7 + n11) > rectangle2D.getWidth() || (double)(n8 + n12) > rectangle2D.getHeight()) {
            return;
        }
        if ((double)(n7 + n11 + n9) < rectangle2D.getX() || (double)(n8 + n12 + n10) < rectangle2D.getY()) {
            return;
        }
        if ((double)(n7 + n11) < rectangle2D.getX()) {
            n9 = n7 + n11 + n9;
            n7 = (int)rectangle2D.getX() - n11;
        }
        if ((double)(n8 + n12) < rectangle2D.getY()) {
            n10 = n8 + n12 + n10;
            n8 = (int)rectangle2D.getY() - n12;
        }
        if ((double)(n7 + n11 + n9) >= rectangle2D.getWidth()) {
            n9 = (int)rectangle2D.getWidth() - n11 - n7;
        }
        if ((double)(n8 + n12 + n10) >= rectangle2D.getHeight()) {
            n10 = (int)rectangle2D.getHeight() - n12 - n8;
        }
        this.copyAreaImpl(n7, n8, n9, n10, n11, n12);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.hints.put(key, object);
        this.shiftDrawCalls = this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.putAll(map);
        boolean bl = this.shiftDrawCalls = map.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || map.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
        if (this.compCtx != null) {
            this.compCtx.dispose();
            this.compCtx = this.comp.createContext(this.getNativeCM(), this.getNativeCM(), this.hints);
        }
    }

    public void addRenderingHints(Map map) {
        this.hints.putAll((Map<?, ?>)map);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private int getInterpolation() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            return 0;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 1;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BICUBIC)) {
            return 5;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
            return 2;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
            return 3;
        }
        if (this.hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
            return 4;
        }
        return 1;
    }

    private void setAntialias(boolean bl) {
        if (this.ignoreAA) {
            return;
        }
        if (bl != this.antialias) {
            this.antialias = !this.antialias;
            this.cairoSetAntialias(this.nativePointer, this.antialias);
        }
    }

    protected boolean drawImage(Image image, AffineTransform affineTransform, Color color, ImageObserver imageObserver) {
        Rectangle2D rectangle2D;
        Object object;
        Object object2;
        AffineTransform affineTransform2;
        if (image == null) {
            return false;
        }
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        try {
            affineTransform2 = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException("Unable to invert transform " + affineTransform.toString());
        }
        image = AsyncImage.realImage(image, imageObserver);
        if (!(image instanceof BufferedImage)) {
            object2 = image.getSource();
            if (object2 == null) {
                return false;
            }
            image = Toolkit.getDefaultToolkit().createImage((ImageProducer)object2);
        }
        object2 = (BufferedImage)image;
        double[] dArray = new double[6];
        int n = ((BufferedImage)object2).getWidth();
        int n2 = ((BufferedImage)object2).getHeight();
        Raster raster = BufferedImageGraphics.bufferedImages.get(object2) != null ? (Raster)BufferedImageGraphics.bufferedImages.get(object2) : ((BufferedImage)object2).getRaster();
        affineTransform2.getMatrix(dArray);
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        if (raster instanceof CairoSurface && ((CairoSurface)raster).sharedBuffer) {
            this.drawCairoSurface((CairoSurface)raster, affineTransform, d, this.getInterpolation());
            this.updateColor();
            return true;
        }
        if (color != null) {
            object = this.bg;
            this.setBackground(color);
            rectangle2D = new Rectangle2D.Double(0.0, 0.0, n, n2);
            rectangle2D = CairoGraphics2D.getTransformedBounds(rectangle2D, affineTransform);
            this.clearRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            this.setBackground((Color)object);
        }
        object = ((BufferedImage)object2).getRGB(0, 0, n, n2, null, 0, n);
        this.cairoSave(this.nativePointer);
        rectangle2D = new Rectangle2D.Double(0.0, 0.0, n, n2);
        rectangle2D = CairoGraphics2D.getTransformedBounds(rectangle2D, affineTransform);
        this.cairoRectangle(this.nativePointer, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.cairoClip(this.nativePointer);
        this.drawPixels(this.nativePointer, (int[])object, n, n2, n, dArray, d, this.getInterpolation());
        this.cairoRestore(this.nativePointer);
        this.updateColor();
        return true;
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.drawRaster(renderedImage.getColorModel(), renderedImage.getData(), affineTransform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createRendering(new RenderContext(affineTransform)), affineTransform);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.drawImage(image, affineTransform, null, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImageOp != null) {
            bufferedImage2 = bufferedImageOp.filter(bufferedImage, null);
        }
        this.drawImage((Image)bufferedImage2, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null, null);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n, n2), null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        if (d == 0.0 || d2 == 0.0) {
            return true;
        }
        return this.drawImage(image, new AffineTransform(d, 0.0, 0.0, d2, (double)n, (double)n2), color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        int n9;
        int n10;
        int n11;
        int n12;
        if (image == null) {
            return false;
        }
        int n13 = n7 - n5;
        int n14 = n8 - n6;
        int n15 = n3 - n;
        int n16 = n4 - n2;
        if (n15 == 0 || n16 == 0 || n13 == 0 || n14 == 0) {
            return true;
        }
        double d = (double)n15 / (double)n13;
        double d2 = (double)n16 / (double)n14;
        Shape shape = this.getClip();
        if (n < n3) {
            n12 = n;
            n11 = n3 - n;
        } else {
            n12 = n3;
            n11 = n - n3;
        }
        if (n2 < n4) {
            n10 = n2;
            n9 = n4 - n2;
        } else {
            n10 = n4;
            n9 = n2 - n4;
        }
        this.clipRect(n12, n10, n11, n9);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((double)n - (double)n5 * d, (double)n2 - (double)n6 * d2);
        affineTransform.scale(d, d2);
        boolean bl = this.drawImage(image, affineTransform, color, imageObserver);
        this.setClip(shape);
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    protected void drawCairoSurface(CairoSurface cairoSurface, AffineTransform affineTransform, double d, int n) {
        Object object;
        Cloneable cloneable;
        if (cairoSurface.getSampleModelTranslateX() != 0 || cairoSurface.getSampleModelTranslateY() != 0) {
            cloneable = new Point2D.Double(0.0, 0.0);
            object = new Point2D.Double(cairoSurface.getSampleModelTranslateX(), cairoSurface.getSampleModelTranslateY());
            affineTransform.transform((Point2D)cloneable, (Point2D)cloneable);
            affineTransform.transform((Point2D)object, (Point2D)object);
            affineTransform.translate(((Point2D)object).getX() - ((Point2D)cloneable).getX(), ((Point2D)object).getY() - ((Point2D)cloneable).getY());
        }
        cloneable = new Rectangle(-cairoSurface.getSampleModelTranslateX(), -cairoSurface.getSampleModelTranslateY(), cairoSurface.width, cairoSurface.height);
        object = affineTransform.createTransformedShape((Shape)((Object)cloneable));
        this.cairoSave(this.nativePointer);
        this.walkPath(object.getPathIterator(null), false);
        this.cairoClip(this.nativePointer);
        try {
            double[] dArray = new double[6];
            affineTransform.createInverse().getMatrix(dArray);
            cairoSurface.nativeDrawSurface(cairoSurface.surfacePointer, this.nativePointer, dArray, d, n);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        this.cairoRestore(this.nativePointer);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (string == null || string.length() == 0) {
            return;
        }
        GdkFontPeer gdkFontPeer = (GdkFontPeer)this.font.getPeer();
        TextLayout textLayout = gdkFontPeer.textLayoutCache.get(string);
        if (textLayout == null) {
            textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            gdkFontPeer.textLayoutCache.put(string, textLayout);
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        this.ignoreAA = true;
        textLayout.draw(this, f, f2);
        this.ignoreAA = false;
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        double d = 1.0;
        if (glyphVector.getNumGlyphs() <= 0) {
            return;
        }
        if (this.customPaint) {
            this.setCustomPaint(glyphVector.getOutline().getBounds());
        }
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        this.setAntialias(!this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING).equals(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
        this.ignoreAA = true;
        if (glyphVector instanceof FreetypeGlyphVector && d == 1.0 && !((FreetypeGlyphVector)glyphVector).hasTransforms()) {
            GdkFontPeer gdkFontPeer;
            int n = glyphVector.getNumGlyphs();
            int[] nArray = glyphVector.getGlyphCodes(0, n, null);
            long[] lArray = ((FreetypeGlyphVector)glyphVector).getGlyphFonts(0, n, null);
            float[] fArray = glyphVector.getGlyphPositions(0, n, null);
            this.setFont(glyphVector.getFont());
            GdkFontPeer gdkFontPeer2 = gdkFontPeer = (GdkFontPeer)this.font.getPeer();
            synchronized (gdkFontPeer2) {
                this.cairoDrawGlyphVector(this.nativePointer, gdkFontPeer, f, f2, n, nArray, fArray, lArray);
            }
        } else {
            this.translate(f, f2);
            this.fill(glyphVector.getOutline());
            this.translate(-f, -f2);
        }
        this.ignoreAA = false;
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        GlyphVector glyphVector = this.getFont().createGlyphVector(this.getFontRenderContext(), attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return ((GdkFontPeer)font.getPeer()).getFontMetrics(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font font) {
        GdkFontPeer gdkFontPeer;
        if (font == null) {
            return;
        }
        this.font = font.getPeer() instanceof GdkFontPeer ? font : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(font.getName(), font.getAttributes());
        GdkFontPeer gdkFontPeer2 = gdkFontPeer = (GdkFontPeer)this.getFont().getPeer();
        synchronized (gdkFontPeer2) {
            this.cairoSetFont(this.nativePointer, gdkFontPeer);
        }
    }

    @Override
    public Font getFont() {
        if (this.font == null) {
            return new Font("SansSerif", 0, 12);
        }
        return this.font;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            Shape shape2 = this.stroke.createStrokedShape(shape);
            return shape2.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return shape.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont().toString() + ",color=" + this.fg.toString() + "]";
    }

    private boolean drawRaster(ColorModel colorModel, Raster raster, AffineTransform affineTransform, Color color) {
        int n;
        if (raster == null) {
            return false;
        }
        SampleModel sampleModel = raster.getSampleModel();
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer == null || sampleModel == null) {
            return false;
        }
        if (colorModel == null) {
            colorModel = ColorModel.getRGBdefault();
        }
        double[] dArray = new double[6];
        if (affineTransform != null) {
            affineTransform.getMatrix(dArray);
        } else {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
            dArray[2] = 0.0;
            dArray[3] = 1.0;
            dArray[4] = 0.0;
            dArray[5] = 0.0;
        }
        int[] nArray = CairoGraphics2D.findSimpleIntegerArray(colorModel, raster);
        if (nArray == null) {
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                nArray = raster.getPixels(0, 0, raster.getWidth(), raster.getHeight(), nArray);
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = colorModel.getRGB(nArray[n]);
                }
            } else {
                nArray = new int[raster.getWidth() * raster.getHeight()];
                for (n = 0; n < nArray.length; ++n) {
                    nArray[n] = colorModel.getRGB(dataBuffer.getElem(n));
                }
            }
        }
        if (colorModel.hasAlpha()) {
            if (color != null && colorModel.hasAlpha()) {
                for (n = 0; n < nArray.length; ++n) {
                    if (colorModel.getAlpha(nArray[n]) != 0) continue;
                    nArray[n] = color.getRGB();
                }
            }
        } else {
            n = 0;
            while (n < nArray.length) {
                int n2 = n++;
                nArray[n2] = nArray[n2] | 0xFF000000;
            }
        }
        double d = 1.0;
        if (this.comp instanceof AlphaComposite) {
            d = ((AlphaComposite)this.comp).getAlpha();
        }
        this.drawPixels(this.nativePointer, nArray, raster.getWidth(), raster.getHeight(), raster.getWidth(), dArray, d, this.getInterpolation());
        this.updateColor();
        return true;
    }

    private double shiftX(double d, boolean bl) {
        if (bl) {
            double d2 = 0.5;
            if (!this.transform.isIdentity()) {
                d2 /= this.transform.getScaleX();
            }
            return d + d2;
        }
        return d;
    }

    private double shiftY(double d, boolean bl) {
        if (bl) {
            double d2 = 0.5;
            if (!this.transform.isIdentity()) {
                d2 /= this.transform.getScaleY();
            }
            return d + d2;
        }
        return d;
    }

    private void walkPath(PathIterator pathIterator, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[6];
        this.cairoSetFillRule(this.nativePointer, pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    d = this.shiftX(dArray[0], bl);
                    d2 = this.shiftY(dArray[1], bl);
                    this.cairoMoveTo(this.nativePointer, d, d2);
                    break;
                }
                case 1: {
                    d = this.shiftX(dArray[0], bl);
                    d2 = this.shiftY(dArray[1], bl);
                    this.cairoLineTo(this.nativePointer, d, d2);
                    break;
                }
                case 2: {
                    double d3 = d + 0.6666666666666666 * (this.shiftX(dArray[0], bl) - d);
                    double d4 = d2 + 0.6666666666666666 * (this.shiftY(dArray[1], bl) - d2);
                    double d5 = d3 + 0.3333333333333333 * (this.shiftX(dArray[2], bl) - d);
                    double d6 = d4 + 0.3333333333333333 * (this.shiftY(dArray[3], bl) - d2);
                    d = this.shiftX(dArray[2], bl);
                    d2 = this.shiftY(dArray[3], bl);
                    this.cairoCurveTo(this.nativePointer, d3, d4, d5, d6, d, d2);
                    break;
                }
                case 3: {
                    d = this.shiftX(dArray[4], bl);
                    d2 = this.shiftY(dArray[5], bl);
                    this.cairoCurveTo(this.nativePointer, this.shiftX(dArray[0], bl), this.shiftY(dArray[1], bl), this.shiftX(dArray[2], bl), this.shiftY(dArray[3], bl), d, d2);
                    break;
                }
                case 4: {
                    this.cairoClosePath(this.nativePointer);
                }
            }
            pathIterator.next();
        }
    }

    private Map<RenderingHints.Key, Object> getDefaultHints() {
        HashMap<RenderingHints.Key, Object> hashMap = new HashMap<RenderingHints.Key, Object>();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        hashMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        hashMap.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hashMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return hashMap;
    }

    public static int[] findSimpleIntegerArray(ColorModel colorModel, Raster raster) {
        if (colorModel == null || raster == null) {
            return null;
        }
        if (!colorModel.getColorSpace().isCS_sRGB()) {
            return null;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        if (directColorModel.getRedMask() != 0xFF0000 || directColorModel.getGreenMask() != 65280 || directColorModel.getBlueMask() != 255) {
            return null;
        }
        if (!(raster instanceof WritableRaster)) {
            return null;
        }
        if (raster.getSampleModel().getDataType() != 3) {
            return null;
        }
        if (!(raster.getDataBuffer() instanceof DataBufferInt)) {
            return null;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        if (dataBufferInt.getNumBanks() != 1) {
            return null;
        }
        return dataBufferInt.getData();
    }

    private void updateClip(AffineTransform affineTransform) {
        if (this.clip == null) {
            return;
        }
        double[] dArray = new double[4];
        affineTransform.getMatrix(dArray);
        if (this.clip instanceof Rectangle2D && dArray[1] == 0.0 && dArray[2] == 0.0) {
            Rectangle2D rectangle2D = (Rectangle2D)this.clip;
            double[] dArray2 = new double[]{rectangle2D.getX(), rectangle2D.getY()};
            double[] dArray3 = new double[]{rectangle2D.getWidth(), rectangle2D.getHeight()};
            affineTransform.transform(dArray2, 0, dArray2, 0, 1);
            affineTransform.deltaTransform(dArray3, 0, dArray3, 0, 1);
            rectangle2D.setRect(dArray2[0], dArray2[1], dArray3[0], dArray3[1]);
        } else {
            if (!(this.clip instanceof GeneralPath)) {
                this.clip = new GeneralPath(this.clip);
            }
            GeneralPath generalPath = (GeneralPath)this.clip;
            generalPath.transform(affineTransform);
        }
    }

    private static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    static Rectangle2D getTransformedBounds(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = rectangle2D.getX();
        double d6 = rectangle2D.getX() + rectangle2D.getWidth();
        double d7 = d5;
        double d8 = d6;
        double d9 = d4 = rectangle2D.getY();
        double d10 = d3 = rectangle2D.getY() + rectangle2D.getHeight();
        double[] dArray = new double[]{d5, d4, d6, d9, d7, d3, d8, d10};
        affineTransform.transform(dArray, 0, dArray, 0, 4);
        double d11 = d2 = dArray[0];
        double d12 = d = dArray[1];
        for (int i = 0; i < 8; ++i) {
            if (dArray[i] < d2) {
                d2 = dArray[i];
            }
            if (dArray[i] > d11) {
                d11 = dArray[i];
            }
            if (dArray[++i] < d) {
                d = dArray[i];
            }
            if (!(dArray[i] > d12)) continue;
            d12 = dArray[i];
        }
        return new Rectangle2D.Double(d2, d, d11 - d2, d12 - d);
    }

    static {
        System.loadLibrary("gtkpeer");
        draw3DRectStroke = new BasicStroke();
        rgb32 = new DirectColorModel(32, 0xFF0000, 65280, 255);
        argb32 = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    }
}

