/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer;

import gnu.java.awt.peer.GnomeDesktopPeer;
import gnu.java.awt.peer.KDEDesktopPeer;
import java.awt.AWTPermission;
import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.prefs.Preferences;

public class ClasspathDesktopPeer
implements DesktopPeer {
    protected static final String _DEFAULT_BROWSER = "firefox";
    protected static final String _BROWSE = "html";
    protected static final String _MAIL = "mail";
    protected static final String _EDIT = "edit";
    protected static final String _PRINT = "print";
    protected static final String _OPEN = "open";
    protected static final KDEDesktopPeer kde = new KDEDesktopPeer();
    protected static final GnomeDesktopPeer gnome = new GnomeDesktopPeer();
    protected static final ClasspathDesktopPeer classpath = new ClasspathDesktopPeer();
    protected Preferences prefs = Preferences.userNodeForPackage(ClasspathDesktopPeer.class).node("Desktop");

    protected ClasspathDesktopPeer() {
    }

    public boolean isSupported(Desktop.Action action) {
        String string = null;
        switch (action) {
            case BROWSE: {
                string = _BROWSE;
                break;
            }
            case MAIL: {
                string = _MAIL;
                break;
            }
            case EDIT: {
                string = _EDIT;
                break;
            }
            case PRINT: {
                string = _PRINT;
                break;
            }
            default: {
                string = _OPEN;
            }
        }
        return this.supportCommand(string);
    }

    public void browse(URI uRI) throws IOException {
        this.checkPermissions();
        String string = this.getCommand(_BROWSE);
        if (string == null) {
            throw new UnsupportedOperationException();
        }
        string = string + " " + uRI.toString();
        Runtime.getRuntime().exec(string);
    }

    public void edit(File file) throws IOException {
        this.checkPermissions(file, false);
        String string = this.getCommand(_EDIT);
        if (string == null) {
            throw new UnsupportedOperationException();
        }
        string = string + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(string);
    }

    public void mail(URI uRI) throws IOException {
        this.checkPermissions();
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("mailto")) {
            throw new IllegalArgumentException("URI Scheme not of type mailto");
        }
        String string2 = this.getCommand(_MAIL);
        if (string2 == null) {
            throw new UnsupportedOperationException();
        }
        string2 = string2 + " " + uRI.toString();
        Runtime.getRuntime().exec(string2);
    }

    public void mail() throws IOException {
        this.checkPermissions();
        String string = this.getCommand(_MAIL);
        if (string == null) {
            throw new UnsupportedOperationException();
        }
        Runtime.getRuntime().exec(string);
    }

    public void open(File file) throws IOException {
        this.checkPermissions(file, true);
        String string = this.getCommand(_OPEN);
        if (string == null) {
            throw new UnsupportedOperationException();
        }
        string = string + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(string);
    }

    public void print(File file) throws IOException {
        this.checkPrintPermissions(file);
        String string = this.getCommand(_PRINT);
        if (string == null) {
            throw new UnsupportedOperationException();
        }
        string = string + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(string);
    }

    protected String getCommand(String string) {
        String string2 = System.getProperty("gnu.java.awt.peer.Desktop." + string + ".command");
        if (string2 == null) {
            string2 = this.prefs.node(string).get("command", null);
        }
        return string2;
    }

    protected void checkPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
        }
    }

    protected void checkPermissions(File file, boolean bl) {
        this.checkPermissions();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(file.toString());
            if (!bl) {
                securityManager.checkWrite(file.toString());
            }
        }
    }

    protected void checkPrintPermissions(File file) {
        this.checkPermissions(file, true);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
    }

    protected boolean supportCommand(String string) {
        return this.getCommand(string) != null;
    }

    public static DesktopPeer getDesktop() {
        String string = System.getenv("GNOME_DESKTOP_SESSION_ID");
        if (string == null) {
            string = System.getenv("KDE_FULL_SESSION");
            if (string != null) {
                return kde;
            }
        } else {
            return gnome;
        }
        return classpath;
    }
}

